/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.gui.IGuiCallback;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;

public class GuiManager
implements IGuiHandler {
    private static final List<IGuiCallback> callbacks = new ArrayList<IGuiCallback>(64);
    private static final int lastUsedBuiltintId = 2;

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        IGuiCallback c;
        TileEntity te;
        TileSyncable syncable;
        if (ID == 0 && (syncable = WorldUtil.cast(te = world.func_175625_s(new BlockPos(x, y, z)), TileSyncable.class)) != null) {
            return syncable.getServerGuiElement(player);
        }
        if (callbacks.size() + 2 > ID && (c = callbacks.get(ID - 2)) != null) {
            return c.getServerGuiElement(player, world, new BlockPos(x, y, z));
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        IGuiCallback c;
        TileEntity te;
        TileSyncable syncable;
        if (ID == 0 && (syncable = WorldUtil.cast(te = world.func_175625_s(new BlockPos(x, y, z)), TileSyncable.class)) != null) {
            return syncable.getClientGuiElement(player);
        }
        if (callbacks.size() + 2 > ID && (c = callbacks.get(ID - 2)) != null) {
            return c.getClientGuiElement(player, world, new BlockPos(x, y, z));
        }
        return null;
    }

    public static void openGui(EntityPlayer player, TileSyncable tile) {
        if (player != null && tile != null && !player.field_70170_p.field_72995_K && tile.hasGui()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)HammerCore.instance, (int)0, (World)player.field_70170_p, (int)tile.func_174877_v().func_177958_n(), (int)tile.func_174877_v().func_177956_o(), (int)tile.func_174877_v().func_177952_p());
        }
    }

    public static void registerGuiCallback(IGuiCallback callback) {
        callback.setGuiID(callbacks.size());
        callbacks.add(callback);
    }

    public static void openGuiCallback(int callbackID, EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)HammerCore.instance, (int)(2 + callbackID), (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
    }

    public static void openGuiCallback(IGuiCallback callbackID, EntityPlayer player, World world, BlockPos pos) {
        GuiManager.openGuiCallback(callbackID.getGuiID(), player, world, pos);
    }

    public static void openGuiCallback(int callbackID, EntityPlayer player, WorldLocation loc) {
        GuiManager.openGuiCallback(callbackID, player, loc.getWorld(), loc.getPos());
    }

    public static void openGuiCallback(IGuiCallback callbackID, EntityPlayer player, WorldLocation loc) {
        GuiManager.openGuiCallback(callbackID.getGuiID(), player, loc.getWorld(), loc.getPos());
    }
}

