/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.zeitheron.hammercore.utils.PlayerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;

public class SkinUtils {
    private static final Map<UUID, GameProfile> uuidProfiles = new HashMap<UUID, GameProfile>();
    private static final Map<String, GameProfile> nameProfiles = new HashMap<String, GameProfile>();

    public static GameProfile bakeProfileByUUID(UUID uid) {
        if (uuidProfiles.get(uid) != null) {
            return uuidProfiles.get(uid);
        }
        GameProfile profile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(uid, PlayerUtil.getUsernameFromUUID(uid)));
        uuidProfiles.put(uid, profile);
        return profile;
    }

    public static GameProfile bakeProfileByUsername(String username) {
        if (nameProfiles.get(username) != null) {
            return nameProfiles.get(username);
        }
        GameProfile profile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(PlayerUtil.getUUIDFromUsername(username), username));
        nameProfiles.put(username, profile);
        return profile;
    }

    public static ResourceLocation getSkinTexture(GameProfile profile) {
        profile = TileEntitySkull.func_174884_b((GameProfile)profile);
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (profile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            } else {
                UUID uuid = EntityPlayer.func_146094_a((GameProfile)profile);
                resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
            }
        }
        return resourcelocation;
    }
}

