/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.asm;

import com.zeitheron.hammercore.asm.HammerCoreTransformer;
import com.zeitheron.hammercore.asm.TransformerSystem;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GlASM {
    final TransformerSystem asm;

    public GlASM(TransformerSystem asm) {
        this.asm = asm;
    }

    public byte[] patchForgeHooksASM(String name, byte[] bytes, boolean obfuscated, String transformedName) {
        this.asm.info("Transforming " + transformedName + " (" + name + ")...");
        this.asm.push();
        String targetMethod = "";
        String transformTypeName = "";
        if (obfuscated) {
            targetMethod = "handleCameraTransforms";
            transformTypeName = "Lbwc$b;";
        } else {
            targetMethod = "handleCameraTransforms";
            transformTypeName = "Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            if (m.name.compareTo(targetMethod) != 0) continue;
            InsnList code = m.instructions;
            List vars = m.localVariables;
            int paramloc = -1;
            if (!obfuscated) {
                paramloc = 1;
            }
            for (int i = 0; i < vars.size() && paramloc == -1; ++i) {
                LocalVariableNode p = (LocalVariableNode)vars.get(i);
                if (p.desc.compareTo(transformTypeName) != 0) continue;
                paramloc = i;
            }
            if (paramloc <= -1) continue;
            MethodInsnNode method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "setTransform", "(" + transformTypeName + ")V", false);
            code.insertBefore(code.get(2), (AbstractInsnNode)method);
            code.insertBefore(code.get(2), (AbstractInsnNode)new VarInsnNode(25, paramloc));
            this.asm.info("Patched handleCameraTransforms!");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        this.asm.pop();
        return writer.toByteArray();
    }

    public byte[] patchGlStateManagerASM(String name, byte[] bytes, boolean obfuscated, String transformedName) {
        this.asm.info("Transforming " + transformedName + " (" + name + ")...");
        this.asm.push();
        String enableLighting = "";
        String disableLighting = "";
        if (obfuscated) {
            enableLighting = "func_179145_e";
            disableLighting = "func_179140_f";
        } else {
            enableLighting = "enableLighting";
            disableLighting = "disableLighting";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            MethodInsnNode method;
            InsnList code;
            if (m.desc.compareTo("()V") != 0) continue;
            if (m.name.compareTo(enableLighting) == 0 || m.name.compareTo("e") == 0) {
                code = m.instructions;
                method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "enableLighting", "()V", false);
                code.insertBefore(code.get(2), (AbstractInsnNode)method);
                this.asm.info("Patched enableLighting!");
            }
            if (m.name.compareTo(disableLighting) != 0 && m.name.compareTo("f") != 0) continue;
            code = m.instructions;
            method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "disableLighting", "()V", false);
            code.insertBefore(code.get(2), (AbstractInsnNode)method);
            this.asm.info("Patched disableLighting!");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        this.asm.pop();
        return writer.toByteArray();
    }

    public byte[] patchTERendererASM(String name, byte[] bytes, boolean obfuscated, String transformedName) {
        this.asm.info("Transforming " + transformedName + " (" + name + ")...");
        this.asm.push();
        String entityName = "";
        String targetMethod = "";
        String targetDesc = "";
        if (obfuscated) {
            targetMethod = "a";
            entityName = "Lavj;";
            targetDesc = "(Lavj;FI)V";
        } else {
            targetMethod = "render";
            entityName = "Lnet/minecraft/tileentity/TileEntity;";
            targetDesc = "(Lnet/minecraft/tileentity/TileEntity;FI)V";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            if (m.name.compareTo(targetMethod) != 0 || m.desc.compareTo(targetDesc) != 0) continue;
            InsnList code = m.instructions;
            List vars = m.localVariables;
            int paramloc = 1;
            AbstractInsnNode returnNode = null;
            for (AbstractInsnNode insn : code) {
                if (insn.getOpcode() != 177) continue;
                returnNode = insn;
                break;
            }
            if (returnNode == null || paramloc <= -1) continue;
            MethodInsnNode method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "renderTileEntity", "(" + entityName + ")V", false);
            code.insertBefore(code.get(2), (AbstractInsnNode)method);
            code.insertBefore(code.get(2), (AbstractInsnNode)new VarInsnNode(25, paramloc));
            this.asm.info("Patched render!");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        this.asm.pop();
        return writer.toByteArray();
    }

    public byte[] patchRenderManagerASM(String name, byte[] bytes, boolean obfuscated, String transformedName) {
        this.asm.info("Transforming " + transformedName + " (" + name + ")...");
        this.asm.push();
        String entityName = "";
        String entityFieldName = "";
        String targetMethod = "";
        String targetDesc = "";
        if (obfuscated) {
            targetMethod = "a";
            entityName = "Lvg;";
            targetDesc = "(Lvg;DDDFFZ)V";
        } else {
            targetMethod = "renderEntity";
            entityName = "Lnet/minecraft/entity/Entity;";
            targetDesc = "(Lnet/minecraft/entity/Entity;DDDFFZ)V";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            if (m.name.compareTo(targetMethod) != 0 || m.desc.compareTo(targetDesc) != 0) continue;
            InsnList code = m.instructions;
            List vars = m.localVariables;
            int paramloc = 1;
            AbstractInsnNode returnNode = null;
            for (AbstractInsnNode insn : code) {
                if (insn.getOpcode() != 177) continue;
                returnNode = insn;
                break;
            }
            if (returnNode == null || paramloc <= -1) continue;
            MethodInsnNode method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "renderEntity", "(" + entityName + ")V", false);
            code.insertBefore(code.get(2), (AbstractInsnNode)method);
            code.insertBefore(code.get(2), (AbstractInsnNode)new VarInsnNode(25, paramloc));
            this.asm.info("Patched renderEntity!");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        this.asm.pop();
        return writer.toByteArray();
    }

    public byte[] patchProfilerASM(String name, byte[] bytes, boolean obfuscated, String transformedName) {
        this.asm.info("Transforming " + transformedName + " (" + name + ")...");
        this.asm.push();
        String targetMethod = "";
        targetMethod = obfuscated ? "c" : "endStartSection";
        String targetMethod2 = "";
        targetMethod2 = obfuscated ? "a" : "startSection";
        String targetMethod3 = "";
        targetMethod3 = obfuscated ? "b" : "endSection";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            MethodInsnNode method;
            AbstractInsnNode returnNode;
            int paramloc;
            List vars;
            InsnList code;
            if (m.name.compareTo(targetMethod2) == 0 && m.desc.compareTo("(Ljava/lang/String;)V") == 0) {
                code = m.instructions;
                vars = m.localVariables;
                paramloc = 1;
                returnNode = null;
                for (AbstractInsnNode insn : code) {
                    if (insn.getOpcode() != 177) continue;
                    returnNode = insn;
                    break;
                }
                if (paramloc > -1) {
                    method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "profilerStart", "(Ljava/lang/String;)V", false);
                    code.insertBefore(code.get(2), (AbstractInsnNode)method);
                    code.insertBefore(code.get(2), (AbstractInsnNode)new VarInsnNode(25, paramloc));
                    this.asm.info("Patched startSection!");
                }
            }
            if (m.name.compareTo(targetMethod) == 0 && m.desc.compareTo("(Ljava/lang/String;)V") == 0) {
                code = m.instructions;
                vars = m.localVariables;
                paramloc = 1;
                returnNode = null;
                for (AbstractInsnNode insn : code) {
                    if (insn.getOpcode() != 177) continue;
                    returnNode = insn;
                    break;
                }
                if (paramloc > -1) {
                    method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "profilerEndStart", "(Ljava/lang/String;)V", false);
                    code.insertBefore(code.get(2), (AbstractInsnNode)method);
                    code.insertBefore(code.get(2), (AbstractInsnNode)new VarInsnNode(25, paramloc));
                    this.asm.info("Patched endStartSection!");
                }
            }
            if (m.name.compareTo(targetMethod3) != 0 || m.desc.compareTo("()V") != 0) continue;
            code = m.instructions;
            vars = m.localVariables;
            paramloc = 1;
            returnNode = null;
            for (AbstractInsnNode insn : code) {
                if (insn.getOpcode() != 177) continue;
                returnNode = insn;
                break;
            }
            if (paramloc <= -1) continue;
            method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "profilerEnd", "()V", false);
            code.insertBefore(code.get(2), (AbstractInsnNode)method);
            this.asm.info("Patched endSection!");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        this.asm.pop();
        return writer.toByteArray();
    }

    public byte[] patchRenderChunkASM(String name, byte[] bytes, boolean obfuscated, String transformedName) {
        this.asm.info("Transforming " + transformedName + " (" + name + ")...");
        this.asm.push();
        HammerCoreTransformer.MethodSignature preRenderChunk = new HammerCoreTransformer.MethodSignature("preRenderChunk", "func_178003_a", "a", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V", "(Lbxr;)V");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            if (!preRenderChunk.isThisMethod(m)) continue;
            InsnList code = m.instructions;
            List vars = m.localVariables;
            int paramloc = -1;
            if (!obfuscated) {
                paramloc = 1;
            }
            for (int i = 0; i < vars.size() && paramloc == -1; ++i) {
                LocalVariableNode p = (LocalVariableNode)vars.get(i);
                if (!preRenderChunk.isThisDesc("(" + p.desc + ")V")) continue;
                paramloc = i;
            }
            AbstractInsnNode returnNode = null;
            for (AbstractInsnNode insn : code) {
                if (insn.getOpcode() != 177) continue;
                returnNode = insn;
                break;
            }
            if (returnNode == null || paramloc <= -1) continue;
            code.insertBefore(returnNode, (AbstractInsnNode)new VarInsnNode(25, paramloc));
            MethodInsnNode method = new MethodInsnNode(184, "com/zeitheron/hammercore/asm/McHooks", "preRenderChunk", m.desc, false);
            code.insertBefore(returnNode, (AbstractInsnNode)method);
            this.asm.info("Patched preRenderChunk!");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        this.asm.pop();
        return writer.toByteArray();
    }
}

