/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.multipart;

import com.zeitheron.hammercore.api.multipart.IMultipartProvider;
import com.zeitheron.hammercore.api.multipart.MultipartAPI;
import com.zeitheron.hammercore.api.multipart.MultipartSignature;
import com.zeitheron.hammercore.internal.blocks.multipart.TileMultipart;
import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockMultipartProvider
extends Item {
    public final IMultipartProvider provider;

    public ItemBlockMultipartProvider(IMultipartProvider provider) {
        this.provider = provider;
    }

    public ItemBlockMultipartProvider() {
        this.provider = (IMultipartProvider)((Object)this);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (WorldUtil.cast(worldIn.func_175625_s(pos), TileMultipart.class) == null && !worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (WorldUtil.cast(worldIn.func_175625_s(pos), TileMultipart.class) == null && !worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            return EnumActionResult.FAIL;
        }
        TileMultipart tmp = MultipartAPI.getOrPlaceMultipart(worldIn, pos);
        ItemStack itemstack = player.func_184586_b(hand);
        if (!(tmp == null || itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("LastPlaced"))) {
            MultipartSignature s = this.provider.createSignature(tmp.getNextSignatureIndex(), itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ);
            if (!tmp.canPlace(s) || !this.provider.canPlaceInto(tmp, itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ)) {
                if (WorldUtil.cast(worldIn.func_175625_s(pos = pos.func_177972_a(facing)), TileMultipart.class) == null && !worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
                    return EnumActionResult.FAIL;
                }
                tmp = MultipartAPI.getOrPlaceMultipart(worldIn, pos);
            }
            if (this.provider.canPlaceInto(tmp, itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ) && tmp.addMultipart(s)) {
                NBTTagCompound nbt;
                SoundType soundtype = s.getSoundType(player);
                try {
                    float br = (soundtype.func_185843_a() + 1.0f * soundtype.func_185843_a() + 1.0f) * 512.0f;
                    List ps = worldIn.func_73046_m().func_184103_al().func_181057_v();
                    for (EntityPlayerMP p : ps) {
                        if (p.field_70170_p.field_73011_w.getDimension() != worldIn.field_73011_w.getDimension() || p.func_174818_b(pos) > (double)br) continue;
                        p.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(soundtype.func_185841_e(), SoundCategory.BLOCKS, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b()));
                    }
                }
                catch (Throwable br) {
                    // empty catch block
                }
                if ((nbt = itemstack.func_77978_p()) == null) {
                    nbt = new NBTTagCompound();
                    itemstack.func_77982_d(nbt);
                }
                nbt.func_74768_a("LastPlaced", 1);
                if (!worldIn.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("LastPlaced")) {
                stack.func_77978_p().func_82580_o("LastPlaced");
            }
            if (stack.func_77978_p().func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }
}

