/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore;

import com.zeitheron.hammercore.CrashUtil;
import com.zeitheron.hammercore.RayCubeRegistry;
import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.api.GameRules;
import com.zeitheron.hammercore.api.HammerCoreAPI;
import com.zeitheron.hammercore.api.IHammerCoreAPI;
import com.zeitheron.hammercore.api.IProcess;
import com.zeitheron.hammercore.api.RequiredDeps;
import com.zeitheron.hammercore.api.WrappedFMLLog;
import com.zeitheron.hammercore.api.mhb.IRayRegistry;
import com.zeitheron.hammercore.api.mhb.RaytracePlugin;
import com.zeitheron.hammercore.cfg.ConfigHolder;
import com.zeitheron.hammercore.cfg.HCModConfigurations;
import com.zeitheron.hammercore.cfg.IConfigReloadListener;
import com.zeitheron.hammercore.cfg.tickslip.TickSlipConfig;
import com.zeitheron.hammercore.command.CommandBuildStructure;
import com.zeitheron.hammercore.command.CommandExportStructure;
import com.zeitheron.hammercore.command.CommandLoadChunk;
import com.zeitheron.hammercore.command.CommandLyingItem;
import com.zeitheron.hammercore.command.CommandPosToLong;
import com.zeitheron.hammercore.command.CommandReloadTickRates;
import com.zeitheron.hammercore.command.CommandSetEnchantmentColor;
import com.zeitheron.hammercore.command.CommandSetLootTable;
import com.zeitheron.hammercore.command.CommandTPX;
import com.zeitheron.hammercore.command.CommandTimeToTicks;
import com.zeitheron.hammercore.event.GetAllRequiredApisEvent;
import com.zeitheron.hammercore.fluiddict.FluidDictionary;
import com.zeitheron.hammercore.internal.GuiManager;
import com.zeitheron.hammercore.internal.SimpleRegisterKernel;
import com.zeitheron.hammercore.internal.SimpleRegistration;
import com.zeitheron.hammercore.internal.chunk.ChunkLoaderHC;
import com.zeitheron.hammercore.internal.init.ItemsHC;
import com.zeitheron.hammercore.internal.init.ManualHC;
import com.zeitheron.hammercore.lib.zlib.database.SafeStore;
import com.zeitheron.hammercore.lib.zlib.weupnp.AttuneResult;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.internal.opts.PacketReqOpts;
import com.zeitheron.hammercore.proxy.AudioProxy_Common;
import com.zeitheron.hammercore.proxy.BookProxy_Common;
import com.zeitheron.hammercore.proxy.NativeProxy_Common;
import com.zeitheron.hammercore.proxy.ParticleProxy_Common;
import com.zeitheron.hammercore.proxy.PipelineProxy_Common;
import com.zeitheron.hammercore.proxy.RenderProxy_Common;
import com.zeitheron.hammercore.utils.AnnotatedInstanceUtil;
import com.zeitheron.hammercore.utils.CommonMessages;
import com.zeitheron.hammercore.utils.HammerCoreUtils;
import com.zeitheron.hammercore.utils.charging.ItemChargeHelper;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import com.zeitheron.hammercore.utils.recipes.BrewingRecipe;
import com.zeitheron.hammercore.utils.recipes.helper.RecipeRegistry;
import com.zeitheron.hammercore.utils.recipes.helper.RegisterRecipes;
import com.zeitheron.hammercore.utils.structure.StructureAPI;
import com.zeitheron.hammercore.world.WorldGenHammerCore;
import com.zeitheron.hammercore.world.WorldGenHelper;
import com.zeitheron.hammercore.world.data.PerChunkDataManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

@Mod(modid="hammercore", version="2.0.6.37", name="HammerLib", guiFactory="com.zeitheron.hammercore.cfg.gui.GuiConfigFactory", certificateFingerprint="9f5e2a811a8332a842b34f6967b7db0ac4f24856", updateJSON="https://api.modrinth.com/updates/PlkSuVtM/forge_updates.json", acceptedMinecraftVersions="[1.12.2]")
public class HammerCore {
    public static final String CERTIFICATE_FINGERPRINT = "9f5e2a811a8332a842b34f6967b7db0ac4f24856";
    public static final List<AttuneResult> closeAfterLogoff = new ArrayList<AttuneResult>();
    public static boolean invalidCertificate = false;
    public static final Map<String, String> invalidCertificates = new HashMap<String, String>();
    public static final List<IProcess> updatables = new ArrayList<IProcess>(16);
    @SidedProxy(modId="hammercore", clientSide="com.zeitheron.hammercore.proxy.RenderProxy_Client", serverSide="com.zeitheron.hammercore.proxy.RenderProxy_Common")
    public static RenderProxy_Common renderProxy;
    @SidedProxy(modId="hammercore", clientSide="com.zeitheron.hammercore.proxy.AudioProxy_Client", serverSide="com.zeitheron.hammercore.proxy.AudioProxy_Common")
    public static AudioProxy_Common audioProxy;
    @SidedProxy(modId="hammercore", clientSide="com.zeitheron.hammercore.proxy.ParticleProxy_Client", serverSide="com.zeitheron.hammercore.proxy.ParticleProxy_Common")
    public static ParticleProxy_Common particleProxy;
    @SidedProxy(modId="hammercore", clientSide="com.zeitheron.hammercore.proxy.BookProxy_Client", serverSide="com.zeitheron.hammercore.proxy.BookProxy_Common")
    public static BookProxy_Common bookProxy;
    @SidedProxy(modId="hammercore", clientSide="com.zeitheron.hammercore.proxy.PipelineProxy_Client", serverSide="com.zeitheron.hammercore.proxy.PipelineProxy_Common")
    public static PipelineProxy_Common pipelineProxy;
    @SidedProxy(modId="hammercore", clientSide="com.zeitheron.hammercore.proxy.NativeProxy_Client", serverSide="com.zeitheron.hammercore.proxy.NativeProxy_Common")
    public static NativeProxy_Common nativeProxy;
    @Mod.Instance(value="hammercore")
    public static HammerCore instance;
    public static final CreativeTabs tab;
    public static final Map<IHammerCoreAPI, HammerCoreAPI> APIS;
    public static final Logger LOG;
    private List<IRayRegistry> raytracePlugins;
    private List<ConfigHolder> configListeners;
    private List<RecipeRegistry> recipeRegistries;
    private List<SimpleRegisterKernel> kernels;
    public List<Object> MCFBusObjects;
    public static int client_ticks;
    private static final byte[][] data;
    public static final List<String> DRAGONS;
    private static final HCAuthor[] HCAUTHORS;
    public static final List<String> AUTHORS;

    public HammerCore() {
        CommonMessages.printMessageOnIllegalRedistribution(HammerCore.class, LOG, "HammerLib", "https://www.curseforge.com/minecraft/mc-mods/hammer-lib");
    }

    @Mod.EventHandler
    public void certificateViolation(FMLFingerprintViolationEvent e) {
        LOG.warn("*****************************");
        LOG.warn("WARNING: Somebody has been tampering with HammerCore jar!");
        LOG.warn("It is highly recommended that you redownload mod from https://www.curseforge.com/projects/247401 !");
        LOG.warn("*****************************");
        invalidCertificate = true;
        invalidCertificates.put("hammercore", "https://www.curseforge.com/projects/247401");
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent e) {
        renderProxy.construct();
        audioProxy.construct();
        this.kernels = SimpleRegisterKernel.doScan(e.getASMHarvestedData());
        if (!FluidRegistry.isUniversalBucketEnabled()) {
            FluidRegistry.enableUniversalBucket();
        }
        new FluidDictionary();
    }

    public static void registerKernelsForMod(String modid) {
        for (SimpleRegisterKernel kernel : HammerCore.instance.kernels) {
            if (!kernel.is(modid)) continue;
            kernel.registerBlocks();
            kernel.registerItems();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        List<IHammerCoreAPI> apis = AnnotatedInstanceUtil.getInstances(e.getAsmData(), HammerCoreAPI.class, IHammerCoreAPI.class);
        this.MCFBusObjects = AnnotatedInstanceUtil.getInstances(e.getAsmData(), MCFBus.class, Object.class);
        List<Object> toRegister = this.MCFBusObjects;
        List<IConfigReloadListener> listeners = AnnotatedInstanceUtil.getInstances(e.getAsmData(), HCModConfigurations.class, IConfigReloadListener.class);
        renderProxy.preInit(e.getAsmData());
        HammerCore.registerKernelsForMod("hammercore");
        TickSlipConfig.reload(new File(e.getModConfigurationDirectory(), "hammercore" + File.separator + "tile_entity_tick_slip.json"));
        toRegister.add(this);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Loading", (int)(4 + apis.size() + toRegister.size() + listeners.size()));
        bar.step("Registering Chunk Storage");
        PerChunkDataManager.register();
        bar.step("Loading ItemChargeHelper modules");
        ItemChargeHelper.preInit(e.getAsmData());
        this.configListeners = new ArrayList<ConfigHolder>();
        int i = 0;
        for (IConfigReloadListener listener : listeners) {
            bar.step("Registering Custom Configs (" + ++i + "/" + listeners.size() + ")");
            ConfigHolder h = new ConfigHolder(listener, new Configuration(listener.getSuggestedConfigurationFile()));
            h.reload();
            this.configListeners.add(h);
            LOG.info("Added \"" + h.listener.getClass().getName() + "\" to Hammer Core Simple Configs.");
        }
        this.raytracePlugins = AnnotatedInstanceUtil.getInstances(e.getAsmData(), RaytracePlugin.class, IRayRegistry.class);
        this.recipeRegistries = AnnotatedInstanceUtil.getInstances(e.getAsmData(), RegisterRecipes.class, RecipeRegistry.class);
        i = 0;
        for (Object o : toRegister) {
            bar.step("Registering Objects to Event Bus (" + ++i + "/" + toRegister.size() + ")");
            MinecraftForge.EVENT_BUS.register(o);
            MCFBus bus = toRegister.getClass().getDeclaredAnnotation(MCFBus.class);
            if (bus != null && !bus.log()) continue;
            LOG.info("Added \"" + o + "\" to MCF Event Bus.");
        }
        LOG.info("Added " + toRegister.size() + " object to MCF Event Bus.");
        GetAllRequiredApisEvent evt = new GetAllRequiredApisEvent();
        MinecraftForge.EVENT_BUS.post((Event)evt);
        RequiredDeps.addRequests(evt);
        i = 0;
        for (IHammerCoreAPI api : apis) {
            bar.step("Registering external libraries (" + ++i + "/" + apis.size() + ")");
            HammerCoreAPI apia = api.getClass().getAnnotation(HammerCoreAPI.class);
            if (apia == null) continue;
            WrappedFMLLog log = new WrappedFMLLog(apia.name());
            api.init(log, apia.version());
            APIS.put(api, apia);
        }
        bar.step("Setting up Network");
        HCNet.INSTANCE.init();
        bar.step("Registering GameRules");
        GameRules.registerGameRule(new GameRules.GameRuleEntry("hc_rainfall", true, "gamerules.hc_rainfall", GameRules.ValueType.BOOLEAN_VALUE));
        GameRules.registerGameRule(new GameRules.GameRuleEntry("hc_falldamagemult", Float.valueOf(1.0f), "gamerules.hc_falldamagemult", GameRules.ValueType.DECIMAL_VALUE));
        ModMetadata meta = e.getModMetadata();
        meta.autogenerated = false;
        meta.version = "2.0.6.37";
        meta.description = "Core used by most of Zeitheron's Mods. ";
        meta.authorList = HammerCore.getHCAuthorsArray();
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        renderProxy.init();
        bookProxy.init();
        ManualHC.register();
        for (RecipeRegistry r : this.recipeRegistries) {
            r.oredict();
        }
        for (RecipeRegistry r : this.recipeRegistries) {
            r.smelting();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiManager());
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)BrewingRecipe.INSTANCE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenHammerCore(), (int)0);
        StructureAPI.registerSpawnableStructure(new ResourceLocation("hammercore", "well"));
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.zeitheron.hammercore.compat.top.GetTOP");
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.zeitheron.hammercore.compat.waila.GetWaila.register");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        renderProxy.postInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent e) {
        renderProxy.loadComplete();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandTPX());
        e.registerServerCommand((ICommand)new CommandBuildStructure());
        e.registerServerCommand((ICommand)new CommandTimeToTicks());
        e.registerServerCommand((ICommand)new CommandLoadChunk());
        e.registerServerCommand((ICommand)new CommandSetEnchantmentColor());
        e.registerServerCommand((ICommand)new CommandPosToLong());
        e.registerServerCommand((ICommand)new CommandSetLootTable());
        e.registerServerCommand((ICommand)new CommandExportStructure());
        e.registerServerCommand((ICommand)new CommandLyingItem());
        e.registerServerCommand((ICommand)new CommandReloadTickRates());
        this.reloadPlugins();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent e) {
        GameRules.load(FMLCommonHandler.instance().getMinecraftServerInstance());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent evt) {
        ChunkLoaderHC.INSTANCE.isAlive();
        GameRules.cleanup();
        closeAfterLogoff.forEach(r -> {
            try {
                LOG.info("Closing port " + r.getInternalPort() + " on " + (Object)((Object)r.getProtocol()));
                r.undo();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        });
        closeAfterLogoff.clear();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent e) {
        WorldGenHelper.CHUNKLOADERS.clear();
    }

    @SubscribeEvent
    public void getApis(GetAllRequiredApisEvent evt) {
    }

    @SubscribeEvent
    public void recipesEvent(RegistryEvent.Register<IRecipe> reg) {
        IForgeRegistry fr = reg.getRegistry();
        fr.register(SimpleRegistration.parseShapelessRecipe(new ItemStack((Item)ItemsHC.MANUAL), new ItemStack(Items.field_151099_bA), OreDictionary.doesOreNameExist((String)"gearIron") ? "gearIron" : "ingotIron").setRegistryName("hammercore", "manual"));
        if (ItemsHC.WRENCH != null) {
            fr.register(SimpleRegistration.parseShapedRecipe(new ItemStack((Item)ItemsHC.WRENCH), " i ", " gi", "i  ", Character.valueOf('i'), OreDictionary.doesOreNameExist((String)"stickIron") ? "stickIron" : "ingotIron", Character.valueOf('g'), OreDictionary.doesOreNameExist((String)"gearIron") ? "gearIron" : "ingotIron").setRegistryName("hammercore", "wrench"));
        }
        for (RecipeRegistry rr : this.recipeRegistries) {
            rr.collect().stream().filter(r -> r != null && r.getRegistryName() != null).forEach(arg_0 -> ((IForgeRegistry)fr).register(arg_0));
        }
        SimpleRegistration.$addRegisterRecipes(arg_0 -> ((IForgeRegistry)fr).register(arg_0));
    }

    @SubscribeEvent
    public void playerConnected(PlayerEvent.PlayerLoggedInEvent evt) {
        EntityPlayer client2;
        if (evt.player instanceof EntityPlayerMP) {
            HCNet.INSTANCE.sendTo(new PacketReqOpts(), (EntityPlayerMP)evt.player);
        }
        if ((client2 = renderProxy.getClientPlayer()) != null && client2.func_146103_bH().getId().equals(evt.player.func_146103_bH().getId())) {
            return;
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent evt) {
        if (evt.side == Side.SERVER) {
            if (evt.phase == TickEvent.Phase.START) {
                ChunkLoaderHC.INSTANCE.update();
            }
            for (int i = 0; evt.phase == TickEvent.Phase.START && i < updatables.size(); ++i) {
                try {
                    IProcess upd = updatables.get(i);
                    upd.update();
                    if (upd.isAlive()) continue;
                    upd.onKill();
                    updatables.remove(i);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public int hashCode() {
        return 0x666666;
    }

    @SubscribeEvent
    public void configReloaded(ConfigChangedEvent evt) {
        String mid = evt.getModID();
        for (ConfigHolder holder : this.configListeners) {
            if (!holder.listener.getModid().equals(mid)) continue;
            holder.reload();
        }
    }

    public void reloadPlugins() {
        RayCubeRegistry.instance.cubes.clear();
        RayCubeRegistry.instance.mgrs.clear();
        for (IRayRegistry reg : this.raytracePlugins) {
            LOG.info("Registering raytrace plugin: " + reg.getClass().getName() + " ...");
            long start = System.currentTimeMillis();
            reg.registerCubes(RayCubeRegistry.instance);
            LOG.info("Registered raytrace  plugin: " + reg.getClass().getName() + " in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public static HCAuthor[] getHCAuthors() {
        return (HCAuthor[])HCAUTHORS.clone();
    }

    public static List<String> getHCAuthorsArray() {
        ArrayList<String> a = new ArrayList<String>();
        for (HCAuthor h : HCAUTHORS) {
            if (!h.isAuthor()) continue;
            a.add(h.getUsername());
        }
        return Collections.unmodifiableList(a);
    }

    public static String getHCMainDev() {
        return HCAUTHORS[0].getUsername();
    }

    static {
        tab = HammerCoreUtils.createDynamicCreativeTab("hammercore", 60);
        APIS = new HashMap<IHammerCoreAPI, HammerCoreAPI>();
        LOG = LogManager.getLogger((String)"HammerLib");
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new CrashUtil());
        client_ticks = 0;
        data = new byte[][]{{-109, -99, 124, -113, -102, 6, -25, -55, 55, 52, 30, 111, 71, 124, 80, -4, -112, 87, 60, -106, -11, 17, -115, 106, -46, -101, 21, 83, -55, -68, 92, -101, -41, 121, -96, 23, 8, 7, 77, 96, -37, 22, -60, -63, -127, 80, -66, -70}};
        DRAGONS = Arrays.asList(new String[0]);
        HCAUTHORS = new HCAuthor[]{new HCAuthor("Zeitheron", TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + "         " + TextFormatting.RESET + "   ", () -> {
            float sine = 0.5f * ((float)Math.sin(Math.toRadians(16 * client_ticks)) + 1.0f);
            int r = 16;
            int g = 180;
            int b = 205 + (int)(sine * 50.0f);
            return ColorHelper.packRGB((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        }, true, data[0])};
        AUTHORS = HammerCore.getHCAuthorsArray();
    }

    public static class HCAuthor {
        private final String username;
        private final String dname;
        private final Supplier<Integer> color;
        private final boolean isAuthor;
        private final SafeStore store;

        private HCAuthor(String username, String dname, Supplier<Integer> color, boolean isAuthor, byte ... passcode) {
            this.username = username;
            this.dname = dname;
            this.color = color;
            this.isAuthor = isAuthor;
            this.store = passcode.length > 0 ? new SafeStore(passcode) : null;
        }

        public SafeStore getStore() {
            return this.store;
        }

        public boolean isAuthor() {
            return this.isAuthor;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayName() {
            return this.dname;
        }

        public Supplier<Integer> getColor() {
            return this.color;
        }
    }
}

