/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.network;

import li.cil.oc.Settings$;
import li.cil.oc.api.network.WirelessEndpoint;
import li.cil.oc.util.BlockPosition;
import li.cil.oc.util.BlockPosition$;
import li.cil.oc.util.ExtendedBlock$;
import li.cil.oc.util.ExtendedWorld$;
import li.cil.oc.util.RTree;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.convert.WrapAsScala$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

public final class WirelessNetwork$ {
    public static final WirelessNetwork$ MODULE$;
    private final Map<Object, RTree<WirelessEndpoint>> dimensions;

    static {
        new WirelessNetwork$();
    }

    public Map<Object, RTree<WirelessEndpoint>> dimensions() {
        return this.dimensions;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (!e.getWorld().field_72995_K) {
            this.dimensions().remove((Object)BoxesRunTime.boxToInteger((int)e.getWorld().field_73011_w.getDimension()));
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.getWorld().field_72995_K) {
            this.dimensions().remove((Object)BoxesRunTime.boxToInteger((int)e.getWorld().field_73011_w.getDimension()));
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        WrapAsScala$.MODULE$.collectionAsScalaIterable(e.getChunk().func_177434_r().values()).foreach((Function1)new Serializable(){

            public final Object apply(TileEntity x0$2) {
                Object object;
                TileEntity tileEntity = x0$2;
                if (tileEntity instanceof WirelessEndpoint) {
                    TileEntity tileEntity2 = tileEntity;
                    object = BoxesRunTime.boxToBoolean((boolean)WirelessNetwork$.MODULE$.remove((WirelessEndpoint)tileEntity2));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
        });
    }

    public void add(WirelessEndpoint endpoint) {
        ((RTree)this.dimensions().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)this.dimension(endpoint)), (Function0)new Serializable(){

            public final RTree<WirelessEndpoint> apply() {
                return new RTree<WirelessEndpoint>(Settings$.MODULE$.get().rTreeMaxEntries(), (Function1<WirelessEndpoint, Tuple3<Object, Object, Object>>)new Serializable(this){

                    public final Tuple3<Object, Object, Object> apply(WirelessEndpoint endpoint) {
                        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)((double)endpoint.x() + 0.5)), (Object)BoxesRunTime.boxToDouble((double)((double)endpoint.y() + 0.5)), (Object)BoxesRunTime.boxToDouble((double)((double)endpoint.z() + 0.5)));
                    }
                });
            }
        })).add(endpoint);
    }

    public void update(WirelessEndpoint endpoint) {
        Option option = this.dimensions().get((Object)BoxesRunTime.boxToInteger((int)this.dimension(endpoint)));
        if (option instanceof Some) {
            Some some;
            Tuple3 tuple3;
            Some some2 = (Some)option;
            RTree tree = (RTree)some2.x();
            Option<Tuple3<Object, Object, Object>> option2 = tree.apply(endpoint);
            if (option2 instanceof Some && (tuple3 = (Tuple3)(some = (Some)option2).x()) != null) {
                BoxedUnit boxedUnit;
                double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double z = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                double dx = package$.MODULE$.abs((double)endpoint.x() + 0.5 - x);
                double dy = package$.MODULE$.abs((double)endpoint.y() + 0.5 - y);
                double dz = package$.MODULE$.abs((double)endpoint.z() + 0.5 - z);
                if (dx > 0.5 || dy > 0.5 || dz > 0.5) {
                    tree.remove(endpoint);
                    tree.add(endpoint);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean remove(WirelessEndpoint endpoint, int dimension) {
        boolean bl;
        Option option = this.dimensions().get((Object)BoxesRunTime.boxToInteger((int)dimension));
        if (option instanceof Some) {
            Some some = (Some)option;
            RTree set2 = (RTree)some.x();
            bl = set2.remove(endpoint);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean remove(WirelessEndpoint endpoint) {
        boolean bl;
        Option option = this.dimensions().get((Object)BoxesRunTime.boxToInteger((int)this.dimension(endpoint)));
        if (option instanceof Some) {
            Some some = (Some)option;
            RTree set2 = (RTree)some.x();
            bl = set2.remove(endpoint);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterable<WirelessEndpoint> computeReachableFrom(WirelessEndpoint endpoint, double strength) {
        Option option = this.dimensions().get((Object)BoxesRunTime.boxToInteger((int)this.dimension(endpoint)));
        if (!(option instanceof Some)) return (Iterable)scala.package$.MODULE$.Iterable().empty();
        Some some = (Some)option;
        RTree tree = (RTree)some.x();
        if (!(strength > 0.0)) return (Iterable)scala.package$.MODULE$.Iterable().empty();
        double range = strength + 1.0;
        return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)tree.query(this.offset(endpoint, -range), this.offset(endpoint, range)).filter((Function1)new Serializable(endpoint){
            private final WirelessEndpoint endpoint$1;

            public final boolean apply(WirelessEndpoint x$1) {
                WirelessEndpoint wirelessEndpoint = x$1;
                WirelessEndpoint wirelessEndpoint2 = this.endpoint$1;
                return wirelessEndpoint != null ? !wirelessEndpoint.equals(wirelessEndpoint2) : wirelessEndpoint2 != null;
            }
            {
                this.endpoint$1 = endpoint$1;
            }
        })).map((Function1)new Serializable(endpoint){
            private final WirelessEndpoint endpoint$1;

            public final Tuple2<WirelessEndpoint, Object> apply(WirelessEndpoint endpoint) {
                return WirelessNetwork$.MODULE$.li$cil$oc$server$network$WirelessNetwork$$zipWithSquaredDistance(this.endpoint$1, endpoint);
            }
            {
                this.endpoint$1 = endpoint$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(range){
            private final double range$1;

            public final boolean apply(Tuple2<WirelessEndpoint, Object> x$2) {
                return (double)x$2._2$mcI$sp() <= this.range$1 * this.range$1;
            }
            {
                this.range$1 = range$1;
            }
        })).map((Function1)new Serializable(){

            public final Tuple2<WirelessEndpoint, Object> apply(Tuple2<WirelessEndpoint, Object> x0$1) {
                Tuple2<WirelessEndpoint, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    WirelessEndpoint c = (WirelessEndpoint)tuple2._1();
                    int distance = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)c, (Object)BoxesRunTime.boxToDouble((double)Math.sqrt(distance)));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(endpoint, strength){
            private final WirelessEndpoint endpoint$1;
            private final double strength$1;

            public final boolean apply(Tuple2<WirelessEndpoint, Object> info) {
                return WirelessNetwork$.MODULE$.li$cil$oc$server$network$WirelessNetwork$$isUnobstructed(this.endpoint$1, this.strength$1, info);
            }
            {
                this.endpoint$1 = endpoint$1;
                this.strength$1 = strength$1;
            }
        })).map((Function1)new Serializable(){

            public final WirelessEndpoint apply(Tuple2<WirelessEndpoint, Object> x$3) {
                return (WirelessEndpoint)x$3._1();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private int dimension(WirelessEndpoint endpoint) {
        return endpoint.world().field_73011_w.getDimension();
    }

    private Tuple3<Object, Object, Object> offset(WirelessEndpoint endpoint, double value) {
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)((double)endpoint.x() + 0.5 + value)), (Object)BoxesRunTime.boxToDouble((double)((double)endpoint.y() + 0.5 + value)), (Object)BoxesRunTime.boxToDouble((double)((double)endpoint.z() + 0.5 + value)));
    }

    public Tuple2<WirelessEndpoint, Object> li$cil$oc$server$network$WirelessNetwork$$zipWithSquaredDistance(WirelessEndpoint reference, WirelessEndpoint endpoint) {
        int dx = endpoint.x() - reference.x();
        int dy = endpoint.y() - reference.y();
        int dz = endpoint.z() - reference.z();
        return new Tuple2((Object)endpoint, (Object)BoxesRunTime.boxToInteger((int)(dx * dx + dy * dy + dz * dz)));
    }

    public boolean li$cil$oc$server$network$WirelessNetwork$$isUnobstructed(WirelessEndpoint reference, double strength, Tuple2<WirelessEndpoint, Object> info) {
        Tuple2<WirelessEndpoint, Object> tuple2 = info;
        if (tuple2 != null) {
            boolean bl;
            Tuple2 tuple22;
            WirelessEndpoint endpoint = (WirelessEndpoint)tuple2._1();
            double distance = tuple2._2$mcD$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)endpoint, (Object)BoxesRunTime.boxToDouble((double)distance));
            WirelessEndpoint endpoint2 = (WirelessEndpoint)tuple23._1();
            double distance2 = tuple23._2$mcD$sp();
            double gap = distance2 - 1.0;
            if (gap > 0.0) {
                Vec3d vec3d;
                World world = endpoint2.world();
                Vec3d origin = new Vec3d((double)reference.x(), (double)reference.y(), (double)reference.z());
                Vec3d target = new Vec3d((double)endpoint2.x(), (double)endpoint2.y(), (double)endpoint2.z());
                Vec3d delta = this.subtract(target, origin);
                Vec3d v = delta.func_72432_b();
                if (v.field_72450_a == 0.0 && v.field_72449_c == 0.0) {
                    Predef$.MODULE$.assert(v.field_72448_b != 0.0);
                    vec3d = new Vec3d(1.0, 0.0, 0.0);
                } else {
                    vec3d = new Vec3d(0.0, 1.0, 0.0);
                }
                Vec3d up = vec3d;
                Vec3d side = this.crossProduct(v, up);
                Vec3d top = this.crossProduct(v, side);
                DoubleRef hardness = DoubleRef.create((double)0.0);
                int samples = package$.MODULE$.max(1, (int)package$.MODULE$.sqrt(gap));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), samples).foreach$mVc$sp((Function1)new Serializable(gap, world, origin, v, side, top, hardness){
                    private final double gap$1;
                    private final World world$1;
                    private final Vec3d origin$1;
                    private final Vec3d v$1;
                    private final Vec3d side$1;
                    private final Vec3d top$1;
                    private final DoubleRef hardness$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        double rGap = this.world$1.field_73012_v.nextDouble() * this.gap$1;
                        int rSide = this.world$1.field_73012_v.nextInt(3) - 1;
                        int rTop = this.world$1.field_73012_v.nextInt(3) - 1;
                        int x = (int)(this.origin$1.field_72450_a + this.v$1.field_72450_a * rGap + this.side$1.field_72450_a * (double)rSide + this.top$1.field_72450_a * (double)rTop);
                        int y = (int)(this.origin$1.field_72448_b + this.v$1.field_72448_b * rGap + this.side$1.field_72448_b * (double)rSide + this.top$1.field_72448_b * (double)rTop);
                        int z = (int)(this.origin$1.field_72449_c + this.v$1.field_72449_c * rGap + this.side$1.field_72449_c * (double)rSide + this.top$1.field_72449_c * (double)rTop);
                        BlockPosition blockPos = BlockPosition$.MODULE$.apply(x, y, z, this.world$1);
                        if (ExtendedWorld$.MODULE$.extendedWorld(this.world$1).isBlockLoaded(blockPos)) {
                            Option option = Option$.MODULE$.apply((Object)ExtendedWorld$.MODULE$.extendedWorld(this.world$1).getBlock(blockPos));
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Block block = (Block)some.x();
                                this.hardness$1.elem += (double)ExtendedBlock$.MODULE$.extendedBlock(block).getBlockHardness(blockPos);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    {
                        this.gap$1 = gap$1;
                        this.world$1 = world$1;
                        this.origin$1 = origin$1;
                        this.v$1 = v$1;
                        this.side$1 = side$1;
                        this.top$1 = top$1;
                        this.hardness$1 = hardness$1;
                    }
                });
                hardness.elem *= gap / (double)samples;
                bl = strength - gap > hardness.elem;
            } else {
                bl = true;
            }
            return bl;
        }
        throw new MatchError(tuple2);
    }

    private Vec3d subtract(Vec3d v1, Vec3d v2) {
        return new Vec3d(v1.field_72450_a - v2.field_72450_a, v1.field_72448_b - v2.field_72448_b, v1.field_72449_c - v2.field_72449_c);
    }

    private Vec3d crossProduct(Vec3d v1, Vec3d v2) {
        return new Vec3d(v1.field_72448_b * v2.field_72449_c - v1.field_72449_c * v2.field_72448_b, v1.field_72449_c * v2.field_72450_a - v1.field_72450_a * v2.field_72449_c, v1.field_72450_a * v2.field_72448_b - v1.field_72448_b * v2.field_72450_a);
    }

    private WirelessNetwork$() {
        MODULE$ = this;
        this.dimensions = Map$.MODULE$.empty();
    }
}

