/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util.world;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.util.world.WorldBorderUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldFileUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import java.lang.reflect.Field;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class WorldInfoUtils {
    private static Field field_worldInfo = null;

    public static void loadAndSetCustomWorldInfo(World world) {
        if (world.field_73011_w instanceof IWorldProviderJED && ((IWorldProviderJED)world.field_73011_w).getWorldInfoHasBeenSet()) {
            return;
        }
        int dimension = world.field_73011_w.getDimension();
        if (DimensionConfig.instance().useCustomWorldInfoFor(dimension)) {
            if (world.func_72912_H().getClass() == DerivedWorldInfo.class) {
                JustEnoughDimensions.logInfo("WorldInfoUtils.loadAndSetCustomWorldInfo(): Overriding the existing DerivedWorldInfo with WorldInfoJED in dimension {}", dimension);
                WorldInfoJED info = WorldInfoUtils.createCustomWorldInfoFor(world, dimension);
                WorldInfoUtils.setWorldInfo(world, info);
            } else if (!(world.func_72912_H() instanceof WorldInfoJED)) {
                JustEnoughDimensions.logInfo("WorldInfoUtils.loadAndSetCustomWorldInfo(): Applying WorldInfo properties to an existing WorldInfo instance of type '{}' in dimension {}", world.func_72912_H().getClass().getName(), dimension);
                boolean generatorChanged = WorldInfoUtils.applyValuesToExistingWorldInfo(world, dimension);
                WorldInfoUtils.applyChangesFromNewWorldInfo(world, generatorChanged);
            }
        }
    }

    private static WorldInfoJED createCustomWorldInfoFor(World world, int dimension) {
        NBTTagCompound nbt = WorldInfoUtils.getWorldInfoTag(world, dimension, true, true);
        return new WorldInfoJED(nbt);
    }

    public static NBTTagCompound getWorldInfoTag(World world, int dimension, boolean readFromDisk, boolean inheritFromOverworld) {
        boolean isDimensionInit;
        NBTTagCompound nbt;
        NBTTagCompound nBTTagCompound = nbt = readFromDisk ? WorldFileUtils.loadWorldInfoFromFile(world, WorldFileUtils.getWorldDirectory(world)) : null;
        boolean bl = readFromDisk ? nbt == null : (isDimensionInit = !WorldFileUtils.jedLevelFileExists(world));
        if (nbt == null) {
            if (inheritFromOverworld) {
                NBTTagCompound playerNBT = world.func_72912_H().func_76072_h();
                nbt = world.func_72912_H().func_76082_a(playerNBT);
            } else {
                nbt = new NBTTagCompound();
            }
        }
        DimensionConfig.instance().setWorldInfoValues(dimension, nbt, DimensionConfig.WorldInfoType.REGULAR);
        if (isDimensionInit) {
            DimensionConfig.instance().setWorldInfoValues(dimension, nbt, DimensionConfig.WorldInfoType.ONE_TIME);
        }
        return nbt;
    }

    private static void setWorldInfo(World world, WorldInfoJED info) {
        if (field_worldInfo != null) {
            try {
                field_worldInfo.set(world, (Object)info);
                WorldInfoUtils.applyChangesFromNewWorldInfo(world, false);
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("WorldInfoUtils.setWorldInfo(): Failed to override WorldInfo for dimension {}", (Object)world.field_73011_w.getDimension());
            }
        }
    }

    private static void applyChangesFromNewWorldInfo(World world, boolean generatorChanged) {
        world.field_73011_w.func_76558_a(world);
        WorldBorderUtils.setWorldBorderValues(world);
        if (!(world.field_73011_w instanceof IWorldProviderJED)) {
            WorldUtils.reCreateChunkGenerator(world, generatorChanged);
        }
    }

    private static boolean applyValuesToExistingWorldInfo(World world, int dimension) {
        boolean generatorChanged;
        NBTTagCompound nbt = WorldInfoUtils.getWorldInfoTag(world, dimension, false, false);
        WorldInfo info = world.func_72912_H();
        boolean hasGeneratorOptions = nbt.func_150297_b("generatorOptions", 8);
        boolean hasSeed = nbt.func_150297_b("RandomSeed", 4);
        boolean bl = generatorChanged = hasGeneratorOptions || hasSeed;
        if (hasSeed || hasGeneratorOptions) {
            long seed = hasSeed ? nbt.func_74763_f("RandomSeed") : info.func_76063_b();
            GameType gameType = nbt.func_150297_b("GameType", 3) ? GameType.func_77146_a((int)nbt.func_74762_e("GameType")) : info.func_76077_q();
            boolean mapFeatures = nbt.func_150297_b("MapFeatures", 1) ? nbt.func_74767_n("MapFeatures") : info.func_76089_r();
            boolean hardcore = nbt.func_150297_b("hardcore", 1) ? nbt.func_74767_n("hardcore") : info.func_76093_s();
            WorldType worldType = nbt.func_150297_b("generatorName", 8) ? WorldInfoUtils.getWorldType(nbt) : info.func_76067_t();
            WorldSettings settings = new WorldSettings(seed, gameType, mapFeatures, hardcore, worldType);
            String generatorOptions = hasGeneratorOptions ? nbt.func_74779_i("generatorOptions") : info.func_82571_y();
            settings.func_82750_a(generatorOptions);
            JustEnoughDimensions.logInfo("WorldInfoUtils.applyValuesToExistingWorldInfo: Applying seed or generator options in dim {}", dimension);
            boolean allowCommands = info.func_76086_u();
            info.func_176127_a(settings);
            info.func_176121_c(allowCommands);
        }
        if (nbt.func_150297_b("generatorName", 8) && !hasGeneratorOptions && !hasSeed) {
            WorldType worldTypeOld = info.func_76067_t();
            WorldType worldTypeNew = WorldInfoUtils.getWorldType(nbt);
            if (!worldTypeNew.equals(worldTypeOld)) {
                JustEnoughDimensions.logInfo("WorldInfoUtils.applyValuesToExistingWorldInfo: Changing WorldType in dim {} to {}", dimension, worldTypeNew.func_77127_a());
                info.func_76085_a(worldTypeNew);
                generatorChanged = true;
            }
        }
        if (nbt.func_150297_b("GameType", 3)) {
            info.func_76060_a(GameType.func_77146_a((int)nbt.func_74762_e("GameType")));
        }
        if (nbt.func_150297_b("MapFeatures", 1)) {
            info.func_176128_f(nbt.func_74767_n("MapFeatures"));
        }
        if (nbt.func_150297_b("Time", 4)) {
            info.func_82572_b(nbt.func_74763_f("Time"));
        }
        if (nbt.func_150297_b("DayTime", 4)) {
            info.func_76068_b(nbt.func_74763_f("DayTime"));
        }
        if (nbt.func_150297_b("LevelName", 8)) {
            info.func_76062_a(nbt.func_74779_i("LevelName"));
        }
        if (nbt.func_150297_b("clearWeatherTime", 3)) {
            info.func_176142_i(nbt.func_74762_e("clearWeatherTime"));
        }
        if (nbt.func_150297_b("rainTime", 3)) {
            info.func_76080_g(nbt.func_74762_e("rainTime"));
        }
        if (nbt.func_150297_b("raining", 1)) {
            info.func_76084_b(nbt.func_74767_n("raining"));
        }
        if (nbt.func_150297_b("thunderTime", 3)) {
            info.func_76090_f(nbt.func_74762_e("tunherTime"));
        }
        if (nbt.func_150297_b("thundering", 1)) {
            info.func_76069_a(nbt.func_74767_n("tundering"));
        }
        if (nbt.func_150297_b("hardcore", 1)) {
            info.func_176119_g(nbt.func_74767_n("hardcore"));
        }
        if (nbt.func_150297_b("allowCommands", 1)) {
            info.func_176121_c(nbt.func_74767_n("allowCommands"));
        }
        if (nbt.func_150297_b("Difficulty", 1)) {
            info.func_176144_a(EnumDifficulty.func_151523_a((int)nbt.func_74771_c("Difficulty")));
        }
        if (nbt.func_150297_b("DifficultyLocked", 1)) {
            info.func_180783_e(nbt.func_74767_n("DifficultyLocked"));
        }
        if (nbt.func_150297_b("BorderCenterX", 6)) {
            info.func_176124_d(nbt.func_74769_h("BorderCenterX"));
        }
        if (nbt.func_150297_b("BorderCenterZ", 6)) {
            info.func_176141_c(nbt.func_74769_h("BorderCenterZ"));
        }
        if (nbt.func_150297_b("BorderSize", 6)) {
            info.func_176145_a(nbt.func_74769_h("BorderSize"));
        }
        if (nbt.func_150297_b("BorderSizeLerpTime", 4)) {
            info.func_176135_e(nbt.func_74763_f("BorderSizeLerpTime"));
        }
        if (nbt.func_150297_b("BorderSizeLerpTarget", 6)) {
            info.func_176118_b(nbt.func_74769_h("BorderSizeLerpTarget"));
        }
        if (nbt.func_150297_b("BorderSafeZone", 6)) {
            info.func_176129_e(nbt.func_74769_h("BorderSafeZone"));
        }
        if (nbt.func_150297_b("BorderDamagePerBlock", 6)) {
            info.func_176125_f(nbt.func_74769_h("BorderDamagePerBlock"));
        }
        if (nbt.func_150297_b("BorderWarningBlocks", 3)) {
            info.func_176122_j(nbt.func_74762_e("BorderWarningBlocks"));
        }
        if (nbt.func_150297_b("BorderWarningTime", 3)) {
            info.func_176136_k(nbt.func_74762_e("BorderWarningTime"));
        }
        if (nbt.func_150297_b("SpawnX", 3) && nbt.func_150297_b("SpawnY", 3) && nbt.func_150297_b("SpawnZ", 3)) {
            BlockPos spawn = new BlockPos(nbt.func_74762_e("SpawnX"), nbt.func_74762_e("SpawnY"), nbt.func_74762_e("SpawnZ"));
            JustEnoughDimensions.logInfo("WorldInfoUtils.applyValuesToExistingWorldInfo: Setting spawn point of dim {} to {}", dimension, spawn);
            info.func_176143_a(spawn);
        }
        if (nbt.func_150297_b("GameRules", 10)) {
            info.func_82574_x().func_82768_a(nbt.func_74775_l("GameRules"));
        }
        return generatorChanged;
    }

    private static WorldType getWorldType(NBTTagCompound nbt) {
        String name = nbt.func_74779_i("generatorName");
        WorldType worldType = WorldType.func_77130_a((String)name);
        if (worldType == null) {
            worldType = WorldType.field_77137_b;
        } else if (worldType.func_77125_e()) {
            int version = 0;
            if (nbt.func_150297_b("generatorVersion", 99)) {
                version = nbt.func_74762_e("generatorVersion");
            }
            worldType = worldType.func_77132_a(version);
        }
        return worldType;
    }

    static {
        try {
            field_worldInfo = ObfuscationReflectionHelper.findField(World.class, (String)"field_72986_A");
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.error("WorldInfoUtils: Reflection failed!!", (Throwable)e);
        }
    }
}

