/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.command.utils;

import fi.dy.masa.justenoughdimensions.command.CommandJED;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.common.DimensionManager;

public class CommandJEDWorldBorder {
    public static void execute(CommandJED cmd, int dimension, String[] args, MinecraftServer server, ICommandSender sender) throws CommandException {
        WorldServer world;
        if (args.length < 1) {
            CommandJED.throwUsage("worldborder", new Object[0]);
        }
        if ((world = DimensionManager.getWorld((int)dimension)) == null) {
            CommandJED.throwNumber("dimension.notloaded", dimension);
        }
        String cmdName = args[0];
        WorldBorder border = world.func_175723_af();
        if (cmdName.equals("set")) {
            long i;
            if (args.length != 2 && args.length != 3) {
                CommandJED.throwUsage("worldborder.set", new Object[0]);
            }
            double oldSize = border.func_177751_j();
            double newSize = CommandBase.func_175756_a((String)args[1], (double)1.0, (double)6.0E7);
            long l = i = args.length > 2 ? CommandBase.func_175760_a((String)args[2], (long)0L, (long)9223372036854775L) * 1000L : 0L;
            if (i > 0L) {
                border.func_177738_a(oldSize, newSize, i);
                if (oldSize > newSize) {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.set.slowly.shrink.success", (Object[])new Object[]{dimension, String.format("%.1f", newSize), String.format("%.1f", oldSize), Long.toString(i / 1000L)});
                } else {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.set.slowly.grow.success", (Object[])new Object[]{dimension, String.format("%.1f", newSize), String.format("%.1f", oldSize), Long.toString(i / 1000L)});
                }
            } else {
                border.func_177750_a(newSize);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.set.success", (Object[])new Object[]{dimension, String.format("%.1f", newSize), String.format("%.1f", oldSize)});
            }
        } else if (cmdName.equals("add")) {
            if (args.length != 2 && args.length != 3) {
                CommandJED.throwUsage("worldborder.add", new Object[0]);
            }
            double oldSize = border.func_177741_h();
            double newSize = oldSize + CommandBase.func_175756_a((String)args[1], (double)(-oldSize), (double)(6.0E7 - oldSize));
            long time = border.func_177732_i() + (args.length > 2 ? CommandBase.func_175760_a((String)args[2], (long)0L, (long)9223372036854775L) * 1000L : 0L);
            if (time > 0L) {
                border.func_177738_a(oldSize, newSize, time);
                if (oldSize > newSize) {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.set.slowly.shrink.success", (Object[])new Object[]{dimension, String.format("%.1f", newSize), String.format("%.1f", oldSize), Long.toString(time / 1000L)});
                } else {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.set.slowly.grow.success", (Object[])new Object[]{dimension, String.format("%.1f", newSize), String.format("%.1f", oldSize), Long.toString(time / 1000L)});
                }
            } else {
                border.func_177750_a(newSize);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.set.success", (Object[])new Object[]{dimension, String.format("%.1f", newSize), String.format("%.1f", oldSize)});
            }
        } else if (cmdName.equals("center")) {
            if (args.length != 3) {
                CommandJED.throwUsage("worldborder.center", new Object[0]);
            }
            BlockPos blockpos = sender.func_180425_c();
            double centerX = CommandBase.func_175761_b((double)((double)blockpos.func_177958_n() + 0.5), (String)args[1], (boolean)true);
            double centerZ = CommandBase.func_175761_b((double)((double)blockpos.func_177952_p() + 0.5), (String)args[2], (boolean)true);
            border.func_177739_c(centerX, centerZ);
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.center.success", (Object[])new Object[]{dimension, centerX, centerZ});
        } else if (cmdName.equals("damage")) {
            if (args.length >= 2 && args[1].equals("buffer")) {
                if (args.length != 3) {
                    CommandJED.throwUsage("worldborder.damage.buffer", new Object[0]);
                }
                double bufferSize = CommandBase.func_180526_a((String)args[2], (double)0.0);
                double oldSize = border.func_177742_m();
                border.func_177724_b(bufferSize);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.damage.buffer.success", (Object[])new Object[]{dimension, String.format("%.1f", bufferSize), String.format("%.1f", oldSize)});
            } else if (args.length >= 2 && args[1].equals("amount")) {
                if (args.length != 3) {
                    CommandJED.throwUsage("worldborder.damage.amount", new Object[0]);
                }
                double damage = CommandBase.func_180526_a((String)args[2], (double)0.0);
                double oldDamage = border.func_177727_n();
                border.func_177744_c(damage);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.damage.amount.success", (Object[])new Object[]{dimension, String.format("%.2f", damage), String.format("%.2f", oldDamage)});
            } else {
                CommandJED.throwUsage("worldborder.damage", new Object[0]);
            }
        } else if (cmdName.equals("warning")) {
            if (args.length >= 2 && args[1].equals("time")) {
                if (args.length != 3) {
                    CommandJED.throwUsage("worldborder.warning.time", new Object[0]);
                }
                int time = CommandBase.func_180528_a((String)args[2], (int)0);
                int oldTime = border.func_177740_p();
                border.func_177723_b(time);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.warning.time.success", (Object[])new Object[]{dimension, time, oldTime});
            } else if (args.length >= 2 && args[1].equals("distance")) {
                if (args.length != 3) {
                    CommandJED.throwUsage("worldborder.warning.distance", new Object[0]);
                }
                int distance = CommandBase.func_180528_a((String)args[2], (int)0);
                int oldDistance = border.func_177748_q();
                border.func_177747_c(distance);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.worldborder.warning.distance.success", (Object[])new Object[]{dimension, distance, oldDistance});
            } else {
                CommandJED.throwUsage("worldborder.warning", new Object[0]);
            }
        } else if (cmdName.equals("get")) {
            double diameter = border.func_177741_h();
            double centerX = border.func_177731_f();
            double centerZ = border.func_177721_g();
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, MathHelper.func_76128_c((double)(diameter + 0.5)));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.worldborder.get.success", new Object[]{dimension, String.format("%.2f", diameter), String.format("%.1f", centerX), String.format("%.1f", centerZ)}));
        }
        if (cmdName.equals("get") || cmdName.equals("set") || cmdName.equals("add") || cmdName.equals("center") || cmdName.equals("damage") || cmdName.equals("warning")) {
            if (world.func_72912_H() instanceof DerivedWorldInfo) {
                CommandJED.throwCommand("command_in_derived_world_info_dimension", new Object[0]);
            }
        } else {
            CommandJED.throwUsage("worldborder", new Object[0]);
        }
    }
}

