/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.render;

import com.google.common.base.Throwables;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.GetBlockMapping;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;

public class StructureRenderHandler {
    private static final Map<String, IBlockState> blockMappingMap = new GetBlockMapping().GetBlockMapping();
    private static final Map<String, IBlockState> blockStateMapDoubleSlab = new GetBlockMapping().GetBlockStateMapDoubleSlab();
    private static final ChestRenderer chestRenderer = new ChestRenderer();
    private static final String[] RENDERPOSX = new String[]{"renderPosX", "field_78725_b", "o"};
    private static final String[] RENDERPOSY = new String[]{"renderPosY", "field_78726_c", "p"};
    private static final String[] RENDERPOSZ = new String[]{"renderPosZ", "field_78723_d", "q"};
    private static final MethodHandle renderPosX_getter;
    private static final MethodHandle renderPosY_getter;
    private static final MethodHandle renderPosZ_getter;
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static EnumFacing assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;
    public static boolean shouldRender;

    public static void setStructure(Structure structure, EnumFacing assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        shouldRender = true;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.field_73011_w.getDimension();
        }
    }

    public static void setStructureNoRender(Structure structure, EnumFacing assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        shouldRender = false;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.field_73011_w.getDimension();
        }
    }

    public static void renderPlayerLook(EntityPlayer player, RayTraceResult src, RenderWorldLastEvent event) {
        if (!StructureRenderHandler.isRenderConditionMet(player)) {
            return;
        }
        StructureRenderHandler.prepareRenderingEnvironment();
        boolean anyCollisions = StructureRenderHandler.detectCollisions(player);
        boolean didRender = StructureRenderHandler.renderBlocks(player, anyCollisions, event);
        StructureRenderHandler.finalizeRendering();
        StructureRenderHandler.communicateRenderingResults(player, didRender, event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRenderConditionMet(EntityPlayer player) {
        if (!shouldRender) return false;
        if (currentStructure == null) return false;
        if (dimension != player.field_70170_p.field_73011_w.getDimension()) return false;
        if (currentConfiguration == null) return false;
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) return false;
        return true;
    }

    private static void prepareRenderingEnvironment() {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179140_f();
        rendering = true;
    }

    public static boolean detectCollisions(EntityPlayer player) {
        boolean anyCollisions = false;
        for (BuildBlock buildBlock : currentStructure.getBlocks()) {
            BlockPos pos = StructureRenderHandler.calculatePosition(buildBlock);
            if (player.field_70170_p.func_175623_d(pos) || player.field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)player.field_70170_p, pos)) continue;
            anyCollisions = true;
        }
        return anyCollisions;
    }

    public static boolean detectCollisions(World world) {
        boolean anyCollisions = false;
        for (BuildBlock buildBlock : currentStructure.getBlocks()) {
            BlockPos pos = StructureRenderHandler.calculatePosition(buildBlock);
            if (world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
            anyCollisions = true;
        }
        return anyCollisions;
    }

    public static BlockPos calculatePosition(BuildBlock buildBlock) {
        return buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
    }

    private static boolean renderBlocks(EntityPlayer player, boolean anyCollisions, RenderWorldLastEvent event) {
        boolean didRender = false;
        for (BuildBlock buildBlock : currentStructure.getBlocks()) {
            if (!StructureRenderHandler.processAndRenderBlock(player, buildBlock, anyCollisions, event)) continue;
            didRender = true;
        }
        return didRender;
    }

    private static boolean processAndRenderBlock(EntityPlayer player, BuildBlock buildBlock, boolean anyCollisions, RenderWorldLastEvent event) {
        IBlockState iBlockState = StructureRenderHandler.determineBlockState(buildBlock);
        if (iBlockState != null) {
            Block foundBlock = iBlockState.func_177230_c();
            buildBlock = BuildBlock.SetBlockState(currentConfiguration, player.field_70170_p, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, iBlockState, currentStructure);
            return StructureRenderHandler.renderComponentInWorld(player.field_70170_p, buildBlock, anyCollisions, event);
        }
        return false;
    }

    private static IBlockState determineBlockState(BuildBlock buildBlock) {
        String blockIdentifier = buildBlock.getBlockDomain() + ":" + buildBlock.getBlockName();
        if (blockMappingMap.containsKey(blockIdentifier)) {
            return blockMappingMap.get(blockIdentifier);
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)buildBlock.getResourceLocation());
        return block != null ? block.func_176223_P() : null;
    }

    private static void finalizeRendering() {
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
        rendering = false;
    }

    private static void communicateRenderingResults(EntityPlayer player, boolean didRender, RenderWorldLastEvent event) {
        if (!didRender) {
            StructureRenderHandler.setStructure(null, EnumFacing.NORTH, null);
            player.func_145747_a(new TextComponentTranslation("prefab.gui.preview.complete", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else if (!showedMessage) {
            player.func_145747_a(new TextComponentTranslation("prefab.gui.preview.notice", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            player.func_145747_a(new TextComponentTranslation("prefab.gui.structure.block.clicked", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            showedMessage = true;
        }
    }

    private static boolean renderComponentInWorld(World world, BuildBlock buildBlock, boolean anyCollisions, RenderWorldLastEvent event) {
        double[] renderPos = StructureRenderHandler.getRenderPosition();
        BlockPos pos = StructureRenderHandler.calculateBlockPosition(buildBlock);
        if (StructureRenderHandler.isBlockOccupied(world, pos)) {
            StructureRenderHandler.renderOccupiedBlock(world, pos, event);
            return false;
        }
        if (anyCollisions) {
            return true;
        }
        StructureRenderHandler.renderBuildBlock(world, buildBlock, renderPos, pos);
        return true;
    }

    private static double[] getRenderPosition() {
        try {
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            double renderPosX = renderPosX_getter.invokeExact(renderManager);
            double renderPosY = renderPosY_getter.invokeExact(renderManager);
            double renderPosZ = renderPosZ_getter.invokeExact(renderManager);
            return new double[]{renderPosX, renderPosY, renderPosZ};
        }
        catch (Throwable t) {
            return new double[]{0.0, 0.0, 0.0};
        }
    }

    private static BlockPos calculateBlockPosition(BuildBlock buildBlock) {
        return buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
    }

    private static boolean isBlockOccupied(World world, BlockPos pos) {
        return !world.func_175623_d(pos) && !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    private static void renderOccupiedBlock(World world, BlockPos pos, RenderWorldLastEvent event) {
        GlStateManager.func_179094_E();
        StructureRenderHandler.setupLineRendering();
        StructureRenderHandler.drawRedBoundingBox(world, pos, event);
        StructureRenderHandler.resetLineRendering();
        GlStateManager.func_179121_F();
    }

    private static void setupLineRendering() {
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)5.0f);
    }

    private static void resetLineRendering() {
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179098_w();
    }

    private static void drawRedBoundingBox(World world, BlockPos pos, RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double x = (double)pos.func_177958_n() - (player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks());
        double y = (double)pos.func_177956_o() - (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks());
        double z = (double)pos.func_177952_p() - (player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks());
        AxisAlignedBB box = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72321_a(0.002, 0.002, 0.002);
        RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private static void renderBuildBlock(World world, BuildBlock buildBlock, double[] renderPos, BlockPos pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-renderPos[0]), (double)(-renderPos[1]), (double)(-renderPos[2]));
        StructureRenderHandler.doRenderComponent(buildBlock, pos, null);
        GlStateManager.func_179121_F();
    }

    private static void doRenderComponent(BuildBlock buildBlock, BlockPos pos, IBlockState overrideState) {
        IBlockState state;
        GlStateManager.func_179094_E();
        IBlockState iBlockState = state = overrideState != null ? overrideState : buildBlock.getBlockState();
        if (state == null) {
            GlStateManager.func_179121_F();
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
        StructureRenderHandler.renderBlockBrightness(state, 1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public static void renderBlockBrightness(IBlockState state, float brightness) {
        if (state == null || state.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher brd = mc.func_175602_ab();
        Tessellator tessellator = Tessellator.func_178181_a();
        if (state.func_185901_i() == EnumBlockRenderType.MODEL) {
            StructureRenderHandler.renderSimpleModelBlocks(state, brd, tessellator);
        }
    }

    public static void renderSimpleModelBlocks(IBlockState state, BlockRendererDispatcher brd, Tessellator tessellator) {
        IBakedModel model = brd.func_184389_a(state);
        BlockModelRenderer renderer = brd.func_175019_b();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockPos pos = BlockPos.field_177992_a;
        renderer.func_187493_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, model, state, pos, bufferBuilder, false, MathHelper.func_180186_a((Vec3i)pos));
        tessellator.func_78381_a();
    }

    static {
        rendering = false;
        showedMessage = false;
        shouldRender = true;
        try {
            Field f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSX);
            f.setAccessible(true);
            renderPosX_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSY);
            f.setAccessible(true);
            renderPosY_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSZ);
            f.setAccessible(true);
            renderPosZ_getter = MethodHandles.publicLookup().unreflectGetter(f);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

