/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.render.StructureRenderHandler;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class GuiStructure
extends GuiBase {
    public BlockPos pos;
    protected EntityPlayer player;
    protected EnumFacing structureFacing;
    protected GuiButtonExt btnCancel;
    protected GuiButtonExt btnBuild;
    protected GuiButtonExt btnVisualize;
    protected StructureTagMessage.EnumStructureConfiguration structureConfiguration;
    protected ResourceLocation structureImageLocation;
    protected boolean pauseGame;

    @Override
    protected void Initialize() {
        super.Initialize();
    }

    protected void InitializeStandardButtons() {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnVisualize = this.createAndAddCustomButton(4, grayBoxX + 113, grayBoxY + 165, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 215, grayBoxY + 165, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(2, grayBoxX + 10, grayBoxY + 165, 90, 20, "prefab.gui.button.cancel");
    }

    public void checkVisualizationSetting() {
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) {
            this.btnVisualize.field_146125_m = false;
        }
    }

    @Override
    public void func_73866_w_() {
        this.player = this.field_146297_k.field_71439_g;
        this.structureFacing = this.player.func_174811_aO().func_176734_d();
        this.Initialize();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(x, y, f);
        this.postButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        if (this.btnVisualize != null) {
            this.checkVisualizationSetting();
        }
    }

    @Override
    public boolean func_73868_f() {
        return this.pauseGame;
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawStandardControlBoxAndImage(this.structureImageLocation, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    protected void performCancelOrBuildOrHouseFacing(StructureConfiguration configuration, GuiButton button) throws IOException {
        configuration.houseFacing = this.structureFacing;
        if (button == this.btnCancel) {
            this.closeScreen();
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((IMessage)new StructureTagMessage(configuration.WriteToNBTTagCompound(), this.structureConfiguration));
            this.closeScreen();
        }
    }

    protected void performPreview(Structure structure, StructureConfiguration structureConfiguration) {
        StructureRenderHandler.setStructure(structure, EnumFacing.NORTH, structureConfiguration);
        this.closeScreen();
    }
}

