/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.gui.controls.GuiExtendedButton;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;

public abstract class GuiBase
extends GuiScreen {
    private final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    private final ResourceLocation narrowPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_background.png");
    private final ResourceLocation leftPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_left_panel.png");
    private final ResourceLocation middlePanelTexture = new ResourceLocation("prefab", "textures/gui/custom_middle_panel.png");
    private final ResourceLocation rightPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_right_panel.png");
    protected int textColor = Color.DARK_GRAY.getRGB();
    protected int modifiedInitialXAxis = 0;
    protected int modifiedInitialYAxis = 0;
    protected int imagePanelWidth = 0;
    protected int imagePanelHeight = 0;
    protected int shownImageHeight = 0;
    protected int shownImageWidth = 0;
    private boolean pauseGame = true;

    public void func_73866_w_() {
        this.Initialize();
    }

    protected void Initialize() {
        this.modifiedInitialXAxis = 160;
        this.modifiedInitialYAxis = 120;
        this.imagePanelWidth = 325;
        this.imagePanelHeight = 300;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
    }

    protected int getCenteredXAxis() {
        return this.field_146294_l / 2;
    }

    protected int getCenteredYAxis() {
        return this.field_146295_m / 2;
    }

    public boolean func_73868_f() {
        return this.pauseGame;
    }

    public void func_73863_a(int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(x, y, f);
        this.postButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
    }

    public GuiButtonExt createAndAddButton(int id, int x, int y, int width, int height, String text) {
        return this.createAndAddButton(id, x, y, width, height, text, true);
    }

    public GuiButtonExt createAndAddButton(int id, int x, int y, int width, int height, String text, boolean translate) {
        GuiButtonExt returnValue = new GuiButtonExt(id, x, y, width, height, translate ? GuiLangKeys.translateString(text) : text);
        return (GuiButtonExt)this.func_189646_b((GuiButton)returnValue);
    }

    public GuiExtendedButton createAndAddCustomButton(int id, int x, int y, int width, int height, String text) {
        return this.createAndAddCustomButton(id, x, y, width, height, text, true);
    }

    public GuiExtendedButton createAndAddCustomButton(int id, int x, int y, int width, int height, String text, boolean translate) {
        GuiExtendedButton returnValue = new GuiExtendedButton(id, x, y, width, height, translate ? GuiLangKeys.translateString(text) : text);
        return (GuiExtendedButton)this.func_189646_b((GuiButton)returnValue);
    }

    public GuiButtonExt createAndAddDyeButton(int id, int x, int y, int width, int height, EnumDyeColor color) {
        GuiButtonExt returnValue = new GuiButtonExt(id, x, y, width, height, GuiLangKeys.translateDye(color));
        return (GuiButtonExt)this.func_189646_b((GuiButton)returnValue);
    }

    public GuiButtonExt createAndAddFullDyeButton(int id, int x, int y, int width, int height, FullDyeColor color) {
        GuiButtonExt returnValue = new GuiButtonExt(id, x, y, width, height, GuiLangKeys.translateFullDye(color));
        this.func_189646_b((GuiButton)returnValue);
        return returnValue;
    }

    public GuiCheckBox createAndAddCheckBox(int id, int xPos, int yPos, String displayString, boolean isChecked) {
        GuiCheckBox checkBox = new GuiCheckBox(id, xPos, yPos, GuiLangKeys.translateString(displayString), isChecked);
        checkBox.setStringColor(this.textColor);
        return (GuiCheckBox)this.func_189646_b(checkBox);
    }

    public GuiSlider createAndAddSlider(int id, int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr) {
        GuiSlider slider = new GuiSlider(id, xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr);
        this.func_189646_b((GuiButton)slider);
        return slider;
    }

    protected void drawControlBackground(int grayBoxX, int grayBoxY) {
        this.drawControlBackground(grayBoxX, grayBoxY, 256, 256);
    }

    protected void drawControlBackground(int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.bindTexture(this.backgroundTextures);
        Gui.func_152125_a((int)grayBoxX, (int)grayBoxY, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height, (float)width, (float)height);
    }

    protected void drawControlPanel(int grayBoxX, int grayBoxY, int width, int height) {
        net.minecraftforge.fml.client.config.GuiUtils.drawContinuousTexturedBox((ResourceLocation)this.narrowPanelTexture, (int)grayBoxX, (int)grayBoxY, (int)0, (int)0, (int)width, (int)height, (int)89, (int)233, (int)2, (int)2, (int)4, (int)4, (float)0.0f);
    }

    protected void drawControlLeftPanel(int grayBoxX, int grayBoxY, int width, int height) {
        net.minecraftforge.fml.client.config.GuiUtils.drawContinuousTexturedBox((ResourceLocation)this.leftPanelTexture, (int)grayBoxX, (int)grayBoxY, (int)0, (int)0, (int)width, (int)height, (int)89, (int)233, (int)2, (int)2, (int)4, (int)4, (float)0.0f);
    }

    protected void drawControlMiddlePanel(int grayBoxX, int grayBoxY, int width, int height) {
        net.minecraftforge.fml.client.config.GuiUtils.drawContinuousTexturedBox((ResourceLocation)this.middlePanelTexture, (int)grayBoxX, (int)grayBoxY, (int)0, (int)0, (int)width, (int)height, (int)89, (int)233, (int)2, (int)2, (int)4, (int)4, (float)0.0f);
    }

    protected void drawControlRightPanel(int grayBoxX, int grayBoxY, int width, int height) {
        net.minecraftforge.fml.client.config.GuiUtils.drawContinuousTexturedBox((ResourceLocation)this.rightPanelTexture, (int)grayBoxX, (int)grayBoxY, (int)0, (int)0, (int)width, (int)height, (int)89, (int)233, (int)2, (int)2, (int)4, (int)4, (float)0.0f);
    }

    protected void drawStandardControlBoxAndImage(ResourceLocation imageLocation, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawControlBackground(x, y, this.imagePanelWidth, this.imagePanelHeight);
        if (imageLocation != null) {
            int imagePanelMiddle = this.imagePanelWidth / 2;
            int middleOfImage = this.shownImageWidth / 2;
            int imagePos = x + (imagePanelMiddle - middleOfImage - 5);
            GuiUtils.bindAndDrawModalRectWithCustomSizedTexture(imageLocation, imagePos, y + 10, 1, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        }
    }

    protected void renderButtons(int mouseX, int mouseY, float partialTicks) {
        for (GuiButton currentButton : this.field_146292_n) {
            if (currentButton == null || !currentButton.field_146125_m) continue;
            currentButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        for (GuiLabel currentLabel : this.field_146293_o) {
            if (currentLabel == null) continue;
            currentLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    public int drawString(String text, int x, int y, int color) {
        return this.getFontRenderer().func_78276_b(text, x, y, color);
    }

    public void drawSplitString(String str, int x, int y, int wrapWidth, int textColor) {
        this.getFontRenderer().func_78279_b(str, x, y, wrapWidth, textColor);
    }

    public void closeScreen() {
        this.getMinecraft().func_147108_a(null);
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    public FontRenderer getFontRenderer() {
        return this.getMinecraft().field_71466_p;
    }

    protected abstract void preButtonRender(int var1, int var2, int var3, int var4, float var5);

    protected abstract void postButtonRender(int var1, int var2, int var3, int var4, float var5);
}

