/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javapatcher.mappings;

import com.google.common.base.Splitter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javassist.CtBehavior;
import javassist.CtClass;
import me.nallar.javapatcher.PatcherLog;

public class MethodDescription {
    public final String clazz;
    public final String returnType;
    public final String parameters;
    public final String name;
    private Integer cachedHashCode = null;

    private MethodDescription(String clazz, String name, String returnType, String parameters) {
        this.clazz = clazz;
        this.returnType = returnType;
        this.parameters = parameters;
        this.name = name;
    }

    private MethodDescription(Method method) {
        this(method.getDeclaringClass().getCanonicalName(), method.getName(), MethodDescription.getJVMName(method.getReturnType()), MethodDescription.getParameterList(method));
    }

    private MethodDescription(CtBehavior ctMethod) {
        this(ctMethod.getDeclaringClass().getName(), ctMethod.getName(), ctMethod.getSignature());
    }

    public MethodDescription(String clazz, String name, String MCPDescription) {
        this(clazz, name, MCPDescription.substring(MCPDescription.lastIndexOf(41) + 1), MCPDescription.substring(1, MCPDescription.indexOf(41)));
    }

    private static String getJVMName(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (clazz.equals(Short.TYPE)) {
                return "S";
            }
            if (clazz.equals(Long.TYPE)) {
                return "J";
            }
            if (clazz.equals(Integer.TYPE)) {
                return "I";
            }
            if (clazz.equals(Float.TYPE)) {
                return "F";
            }
            if (clazz.equals(Double.TYPE)) {
                return "D";
            }
            if (clazz.equals(Character.TYPE)) {
                return "C";
            }
        }
        return 'L' + clazz.getCanonicalName() + ';';
    }

    private static String getParameterList(Method method) {
        ArrayList parameterClasses = new ArrayList(Arrays.asList(method.getParameterTypes()));
        StringBuilder parameters = new StringBuilder();
        for (Class clazz : parameterClasses) {
            parameters.append(MethodDescription.getJVMName(clazz));
        }
        return parameters.toString();
    }

    public static MethodDescription fromString(String clazz, String methodString) {
        if (methodString.contains("(")) {
            try {
                String methodName = methodString.substring(0, methodString.indexOf(40));
                methodString = methodString.replace('.', '/');
                return new MethodDescription(clazz, methodName, methodString.substring(methodString.indexOf(40)));
            }
            catch (Exception e) {
                PatcherLog.error("Failed to parse " + methodString, e);
            }
        }
        return new MethodDescription(clazz, methodString, "", "");
    }

    public static List<MethodDescription> fromListString(String clazz, String methodList) {
        ArrayList<MethodDescription> methodDescriptions = new ArrayList<MethodDescription>();
        for (String methodString : Splitter.on((String)",").trimResults().split((CharSequence)methodList)) {
            methodDescriptions.add(MethodDescription.fromString(clazz, methodString));
        }
        return methodDescriptions;
    }

    public static String toListString(List<MethodDescription> methodDescriptions) {
        if (methodDescriptions.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(methodDescriptions.remove(0));
        for (MethodDescription methodDescription : methodDescriptions) {
            stringBuilder.append(',').append(methodDescription);
        }
        return stringBuilder.toString();
    }

    public String getShortName() {
        return this.clazz + '/' + this.name;
    }

    String getMCPName() {
        return '(' + this.parameters + ')' + this.returnType;
    }

    public String toString() {
        if (!this.name.isEmpty() && this.name.charAt(this.name.length() - 1) == '^') {
            return this.name;
        }
        return this.name + this.getMCPName();
    }

    public int hashCode() {
        if (this.cachedHashCode != null) {
            return this.cachedHashCode;
        }
        int hashCode = this.returnType.hashCode();
        hashCode = 31 * hashCode + this.parameters.hashCode();
        hashCode = 31 * hashCode + this.name.hashCode();
        hashCode = 31 * hashCode + this.clazz.hashCode();
        this.cachedHashCode = hashCode;
        return this.cachedHashCode;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof MethodDescription && ((MethodDescription)other).clazz.equals(this.clazz) && ((MethodDescription)other).returnType.equals(this.returnType) && ((MethodDescription)other).parameters.equals(this.parameters) && ((MethodDescription)other).name.equals(this.name) || other instanceof Method && new MethodDescription((Method)other).equals(this);
    }

    boolean similar(MethodDescription other) {
        return this == other || this.getShortName().equals(other.getShortName());
    }

    public boolean isExact() {
        return !this.parameters.isEmpty() || !this.returnType.isEmpty();
    }

    public CtBehavior inClass(CtClass ctClass) {
        CtBehavior possible = null;
        for (CtBehavior ctMethod : ctClass.getDeclaredBehaviors()) {
            MethodDescription methodDescription = new MethodDescription(ctMethod);
            if (methodDescription.equals(this)) {
                return ctMethod;
            }
            if (!methodDescription.name.equals(this.name) || this.parameters.isEmpty() || methodDescription.getParameterList().size() != this.getParameterList().size()) continue;
            possible = ctMethod;
        }
        if (this.isExact()) {
            PatcherLog.warn("Failed to find exact match for " + this.getMCPName() + ", trying to find similar methods.");
        }
        if (possible != null) {
            return possible;
        }
        for (CtBehavior ctMethod : ctClass.getDeclaredBehaviors()) {
            if (!new MethodDescription(ctMethod).similar(this)) continue;
            return ctMethod;
        }
        throw new RuntimeException("Method not found: " + this + " was not found in " + ctClass.getName());
    }

    public void obfuscateClasses() {
    }

    public String getParameters() {
        return this.parameters;
    }

    public List<String> getParameterList() {
        String parameters = this.parameters;
        ArrayList<String> parameterList = new ArrayList<String>();
        while (!parameters.isEmpty()) {
            String p = parameters.substring(0, 1);
            parameters = parameters.substring(1);
            if ("L".equals(p)) {
                int cIndex = parameters.indexOf(59);
                p = parameters.substring(0, cIndex).replace('/', '.');
                parameters = parameters.substring(cIndex + 1);
            }
            parameterList.add(p);
        }
        return parameterList;
    }
}

