/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.util.NullHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class ByteBufAdapterRegistry {
    private static final Map<String, Integer> NAME2ID = new HashMap<String, Integer>();
    private static List<IByteBufAdapter<?>> ID2ADAPTER = new ArrayList();

    public static void register(IByteBufAdapter<?> adapter) {
        NAME2ID.put(adapter.getName(), ID2ADAPTER.size());
        ID2ADAPTER.add(adapter);
    }

    public static int getID(IByteBufAdapter<?> adapter) {
        return NAME2ID.get(adapter.getName());
    }

    public static IByteBufAdapter<?> get(int id) {
        return NullHelper.notnull(ID2ADAPTER.get(id), "Bad mapping " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMapping(ByteBuf buf) {
        Map<String, Integer> map = NAME2ID;
        synchronized (map) {
            buf.writeByte(ID2ADAPTER.size());
            for (IByteBufAdapter<?> adapter : ID2ADAPTER) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)adapter.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMapping(ByteBuf buf) {
        Map<String, Integer> map = NAME2ID;
        synchronized (map) {
            int count = buf.readByte();
            if (count != ID2ADAPTER.size()) {
                throw new RuntimeException("Server and client ByteBufAdapter lists are out of sync. Server has " + count + ", client has " + ID2ADAPTER.size());
            }
            ArrayList synced = new ArrayList();
            for (int i = 0; i < count; ++i) {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                Integer oldID = NAME2ID.get(name);
                if (oldID == null) {
                    throw new RuntimeException("Server and client ByteBufAdapter lists are out of sync. Server has " + name + ", client doesn't know that one");
                }
                IByteBufAdapter<?> adapter = ID2ADAPTER.get(oldID);
                synced.add(adapter);
                NAME2ID.put(name, i);
            }
            ID2ADAPTER = synced;
        }
    }
}

