/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.commands;

import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import silly511.backups.BackupManager;
import silly511.backups.commands.RestoreCommand;
import silly511.backups.helpers.BackupHelper;
import silly511.backups.helpers.FormatHelper;

public class ListBackupsCommand
extends CommandBase {
    public String func_71517_b() {
        return "listbackups";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.backups.listbackups.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        List<BackupHelper.Backup> backups = BackupHelper.listAllBackups(BackupManager.getCurrentBackupsDir());
        if (backups.isEmpty()) {
            throw new CommandException("commands.backups.lastbackup.noBackups", new Object[0]);
        }
        for (BackupHelper.Backup backup : Lists.reverse(backups)) {
            String formattedTime = backup.time.atZone(ZoneId.systemDefault()).format(RestoreCommand.dateFormat);
            TextComponentString msg = new TextComponentString(formattedTime + " (" + FormatHelper.relativeTimeAgo(backup.time) + " ago)");
            sender.func_145747_a((ITextComponent)msg);
        }
    }
}

