/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups;

import net.minecraftforge.common.config.Config;

@net.minecraftforge.common.config.Config(modid="backups")
public class Config {
    @Config.Comment(value={"Path to the backups directory"})
    public static String backupsDir = "backupsmod";
    @Config.Comment(value={"Number of minutes between automatic backups. Setting to zero will disable automatic backups"})
    @Config.RangeInt(min=0)
    public static int backupInterval = 15;
    @Config.Comment(value={"If a world is deleted but still has backups, then an entry for the world will still be shown in the world selection list"})
    public static boolean showDeletedWorlds = true;
    @Config.Comment(value={"If you need to be an op to use /backup. If this is false then any player can use /backup"})
    public static boolean needOpToBackup = true;
    @Config.Comment(value={"If backups should still happen when there are no player online"})
    public static boolean backupWhenServerEmpty = false;
    @Config.Comment(value={"Which players can see the Started Backup and Finished Backup messages"})
    public static AnnounceBackupsMode announceBackups = AnnounceBackupsMode.ALL_PLAYERS;
    @Config.Name(value="backupTrimming")
    public static BackupTrimming trimming = new BackupTrimming();

    public static enum AnnounceBackupsMode {
        OFF,
        ALL_PLAYERS,
        OPS_ONLY;

    }

    public static class BackupTrimming {
        @Config.Comment(value={"Whether backup trimming is enabled"})
        public boolean trimmingEnabled = true;
        @Config.Comment(value={"Number of hours old a backup has to be before it's trimmed to the hour"})
        @Config.RangeInt(min=1, max=24)
        public int perHour = 1;
        @Config.Comment(value={"Number of days old a backup has to be before it's trimmed to the day"})
        @Config.RangeInt(min=1, max=7)
        public int perDay = 3;
        @Config.Comment(value={"Number of days old a backup has to be before it's trimmed to the week"})
        @Config.RangeInt(min=8, max=90)
        public int perWeek = 30;
        @Config.Comment(value={"Number of days old a backup has to be before it's deleted. Set to zero to keep backups forever"})
        @Config.RangeInt(min=0)
        public int maxAge = 0;
        @Config.Comment(value={"Maximum number of backups to keep. Once the number of backups exceeds this number the oldest ones are deleted. Set to zero to disable."})
        @Config.RangeInt(min=0)
        public int maxNumber = 0;
    }
}

