/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.AccessFlags;
import org.minimallycorrect.javatransformer.api.ClassMember;
import org.minimallycorrect.javatransformer.api.FieldInfo;
import org.minimallycorrect.javatransformer.api.MethodInfo;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.internal.util.CollectionUtil;

public interface ClassInfo
extends ClassMember {
    default public void add(ClassMember member) {
        if (member instanceof MethodInfo) {
            this.add((MethodInfo)member);
        } else if (member instanceof FieldInfo) {
            this.add((FieldInfo)member);
        } else {
            throw new TransformationException("Can't add member of type " + member.getClass().getCanonicalName() + " to " + this);
        }
    }

    public void add(MethodInfo var1);

    public void add(FieldInfo var1);

    default public void remove(ClassMember member) {
        if (member instanceof MethodInfo) {
            this.remove((MethodInfo)member);
        } else if (member instanceof FieldInfo) {
            this.remove((FieldInfo)member);
        } else {
            throw new TransformationException("Can't remove member of type " + member.getClass().getCanonicalName() + " to " + this);
        }
    }

    public void remove(MethodInfo var1);

    public void remove(FieldInfo var1);

    @Nullable
    public Type getSuperType();

    public List<Type> getInterfaceTypes();

    @Nullable
    default public ClassMember get(ClassMember member) {
        if (member instanceof MethodInfo) {
            return this.get((MethodInfo)member);
        }
        if (member instanceof FieldInfo) {
            return this.get((FieldInfo)member);
        }
        throw new TransformationException("Can't get member of type " + member.getClass().getCanonicalName() + " in " + this);
    }

    @Nullable
    default public MethodInfo get(MethodInfo like) {
        for (MethodInfo methodInfo : CollectionUtil.iterable(this.getMethods())) {
            if (!like.similar(methodInfo)) continue;
            return methodInfo;
        }
        return null;
    }

    @Nullable
    default public FieldInfo get(FieldInfo like) {
        for (FieldInfo fieldInfo : CollectionUtil.iterable(this.getFields())) {
            if (!like.similar(fieldInfo)) continue;
            return fieldInfo;
        }
        return null;
    }

    default public Type getType() {
        return Type.of(this.getName());
    }

    public Stream<MethodInfo> getMethods();

    public Stream<FieldInfo> getFields();

    default public Stream<MethodInfo> getConstructors() {
        return this.getMethods().filter(MethodInfo::isConstructor);
    }

    default public Stream<ClassMember> getMembers() {
        return Stream.concat(this.getFields(), this.getMethods());
    }

    @Override
    default public void accessFlags(Function<AccessFlags, AccessFlags> c) {
        this.setAccessFlags(c.apply(this.getAccessFlags()));
    }
}

