/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import java.util.List;
import java.util.stream.Collectors;
import org.minimallycorrect.javatransformer.api.Annotation;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;

public interface Annotated {
    public List<Annotation> getAnnotations();

    default public List<Annotation> getAnnotations(Type t) {
        if (!t.isClassType()) {
            throw new TransformationException("Type must be a class type: " + t);
        }
        return this.getAnnotations(t.getClassName());
    }

    default public List<Annotation> getAnnotations(String fullAnnotationName) {
        return this.getAnnotations().stream().filter(it -> it.getType().getClassName().equals(fullAnnotationName)).collect(Collectors.toList());
    }
}

