/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.color.ColorGetter;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;

    public ItemStackHelper(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    @Override
    public List<ItemStack> expandSubtypes(List<ItemStack> contained) {
        return this.stackHelper.getAllSubtypes(contained);
    }

    @Override
    public IFocus<?> translateFocus(IFocus<ItemStack> focus, IIngredientHelper.IFocusFactory focusFactory) {
        Block block;
        Fluid fluid;
        ItemStack itemStack = focus.getValue();
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = ((ItemBlock)item).func_179223_d()))) != null) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            return focusFactory.createFocus(focus.getMode(), fluidStack);
        }
        return focus;
    }

    @Override
    @Nullable
    public ItemStack getMatch(Iterable<ItemStack> ingredients, ItemStack toMatch) {
        return this.stackHelper.containsStack(ingredients, toMatch);
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        return ErrorUtil.checkNotNull(ingredient.func_82833_r(), "itemStack.getDisplayName()");
    }

    @Override
    public String getUniqueId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, StackHelper.UidMode.WILDCARD);
    }

    @Override
    public String getModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110624_b();
    }

    @Override
    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        String modId = item.getCreatorModId(ingredient);
        if (modId == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getCreatorModId() returned null for: " + stackInfo);
        }
        return modId;
    }

    @Override
    public Iterable<Color> getColors(ItemStack ingredient) {
        return ColorGetter.getColors(ingredient, 2);
    }

    @Override
    public String getResourceId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110623_a();
    }

    @Override
    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    @Override
    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.func_77946_l();
    }

    @Override
    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.func_190926_b();
    }

    @Override
    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        return ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item);
    }

    @Override
    public Collection<String> getOreDictNames(ItemStack ingredient) {
        ArrayList<String> names = new ArrayList<String>();
        for (int oreId : OreDictionary.getOreIDs((ItemStack)ingredient)) {
            String oreNameLowercase = OreDictionary.getOreName((int)oreId).toLowerCase(Locale.ENGLISH);
            names.add(oreNameLowercase);
        }
        return names;
    }

    @Override
    public Collection<String> getCreativeTabNames(ItemStack ingredient) {
        ArrayList<String> creativeTabsStrings = new ArrayList<String>();
        Item item = ingredient.func_77973_b();
        for (CreativeTabs creativeTab : item.getCreativeTabs()) {
            if (creativeTab == null) continue;
            String creativeTabName = I18n.func_135052_a((String)creativeTab.func_78024_c(), (Object[])new Object[0]);
            creativeTabsStrings.add(creativeTabName);
        }
        return creativeTabsStrings;
    }

    @Override
    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }

    @Override
    public String getErrorInfoMinimal(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfoMinimal(ingredient);
    }
}

