/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.IMCHandler;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.world.feature.TFGenerator;

public class TFGenCaveStalactite
extends TFGenerator {
    private static final List<StalactiteEntry> largeHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> mediumHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> smallHillStalactites = new ArrayList<StalactiteEntry>();
    public IBlockState blockState;
    public boolean hang;
    public float sizeFactor;
    public int maxLength;
    public int minHeight;

    public TFGenCaveStalactite(Block block, float size, boolean down) {
        this(block.func_176223_P(), size, down);
    }

    public TFGenCaveStalactite(IBlockState blockState, float size, boolean down) {
        this.blockState = blockState;
        this.sizeFactor = size;
        this.maxLength = -1;
        this.minHeight = -1;
        this.hang = down;
    }

    public TFGenCaveStalactite(IBlockState blockState, float size, int maxLength, int minHeight) {
        this.blockState = blockState;
        this.sizeFactor = size;
        this.maxLength = maxLength;
        this.minHeight = minHeight;
        this.hang = true;
    }

    public static TFGenCaveStalactite makeRandomOreStalactite(Random rand, int hillSize) {
        if (hillSize >= 3 || hillSize >= 2 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)WeightedRandom.func_76271_a((Random)rand, TFGenCaveStalactite.largeHillStalactites)).stalactite;
        }
        if (hillSize >= 2 || hillSize >= 1 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)WeightedRandom.func_76271_a((Random)rand, TFGenCaveStalactite.mediumHillStalactites)).stalactite;
        }
        return ((StalactiteEntry)WeightedRandom.func_76271_a((Random)rand, TFGenCaveStalactite.smallHillStalactites)).stalactite;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Material m;
        int ty;
        int ceiling = Integer.MAX_VALUE;
        int floor = -1;
        BlockPos.MutableBlockPos iterPos = new BlockPos.MutableBlockPos(pos);
        for (ty = pos.func_177956_o(); ty < 256; ++ty) {
            iterPos.func_185336_p(ty);
            m = world.func_180495_p((BlockPos)iterPos).func_185904_a();
            if (m == Material.field_151579_a) continue;
            if (m != Material.field_151578_c && m != Material.field_151576_e) {
                return false;
            }
            ceiling = ty;
            break;
        }
        if (ceiling == Integer.MAX_VALUE) {
            return false;
        }
        for (ty = pos.func_177956_o(); ty > 4; --ty) {
            iterPos.func_185336_p(ty);
            m = world.func_180495_p((BlockPos)iterPos).func_185904_a();
            if (m == Material.field_151579_a) continue;
            if (m != Material.field_151578_c && m != Material.field_151576_e && !this.hang && m != Material.field_151586_h && !this.hang && m != Material.field_151587_i) {
                return false;
            }
            floor = ty;
            break;
        }
        int length = (int)((float)(ceiling - floor) * this.sizeFactor * random.nextFloat());
        if (this.maxLength > -1 && length > this.maxLength) {
            length = this.maxLength;
        }
        if (this.minHeight > -1 && ceiling - floor - length < this.minHeight) {
            return false;
        }
        return this.makeSpike(world, random, new BlockPos(pos.func_177958_n(), this.hang ? ceiling : floor, pos.func_177952_p()), length);
    }

    public boolean makeSpike(World world, Random random, BlockPos pos, int maxLength) {
        int diameter = (int)((double)maxLength / 4.5);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int dir;
                int absx = Math.abs(dx);
                int absz = Math.abs(dz);
                int dist = (int)((double)Math.max(absx, absz) + (double)Math.min(absx, absz) * 0.5);
                int spikeLength = 0;
                if (dist == 0) {
                    spikeLength = maxLength;
                }
                if (dist > 0) {
                    spikeLength = random.nextInt((int)((double)maxLength / ((double)dist + 0.25)));
                }
                int n = dir = this.hang ? -1 : 1;
                if (!world.func_180495_p(pos.func_177982_a(dx, -dir, dz)).func_185904_a().func_76220_a()) {
                    spikeLength = 0;
                }
                for (int dy = 0; dy != spikeLength * dir; dy += dir) {
                    this.func_175903_a(world, pos.func_177982_a(dx, dy, dz), this.blockState);
                }
            }
        }
        return true;
    }

    public static void addStalactite(int hillSize, IBlockState blockState, float size, int maxLength, int minHeight, int itemWeight) {
        if (itemWeight > 0) {
            TFGenCaveStalactite.addStalactite(hillSize, new StalactiteEntry(blockState, size, maxLength, minHeight, itemWeight));
        }
    }

    private static void addStalactite(int hillSize, StalactiteEntry entry) {
        if (hillSize <= 1) {
            smallHillStalactites.add(entry);
        }
        if (hillSize <= 2) {
            mediumHillStalactites.add(entry);
        }
        largeHillStalactites.add(entry);
    }

    private static void addDefaultStalactites() {
        TFGenCaveStalactite.addStalactite(3, Blocks.field_150482_ag.func_176223_P(), 0.5f, 4, 16, 30);
        TFGenCaveStalactite.addStalactite(3, Blocks.field_150369_x.func_176223_P(), 0.8f, 8, 1, 30);
        TFGenCaveStalactite.addStalactite(3, Blocks.field_150412_bA.func_176223_P(), 0.5f, 3, 12, 15);
        TFGenCaveStalactite.addStalactite(2, Blocks.field_150352_o.func_176223_P(), 0.6f, 6, 1, 20);
        TFGenCaveStalactite.addStalactite(2, Blocks.field_150450_ax.func_176223_P(), 0.8f, 8, 1, 40);
        TFGenCaveStalactite.addStalactite(1, Blocks.field_150366_p.func_176223_P(), 0.7f, 8, 1, 24);
        TFGenCaveStalactite.addStalactite(1, Blocks.field_150365_q.func_176223_P(), 0.8f, 12, 1, 24);
        TFGenCaveStalactite.addStalactite(1, Blocks.field_150426_aN.func_176223_P(), 0.5f, 8, 1, 12);
    }

    public static void loadStalactites() {
        smallHillStalactites.clear();
        mediumHillStalactites.clear();
        largeHillStalactites.clear();
        TFConfig.dimension.hollowHillStalactites.load();
        if (TFConfig.dimension.hollowHillStalactites.useConfigOnly) {
            if (smallHillStalactites.isEmpty()) {
                TwilightForestMod.LOGGER.info("Not all hollow hills are populated with the config, adding fallback");
                TFGenCaveStalactite.addStalactite(1, Blocks.field_150348_b.func_176223_P(), 0.7f, 8, 1, 1);
            }
            return;
        }
        TFGenCaveStalactite.addDefaultStalactites();
        IMCHandler.getStalactites().forEach(TFGenCaveStalactite::addStalactite);
    }

    public static class StalactiteEntry
    extends WeightedRandom.Item {
        final TFGenCaveStalactite stalactite;

        StalactiteEntry(TFGenCaveStalactite stalactite, int itemWeight) {
            super(itemWeight);
            this.stalactite = stalactite;
        }

        public StalactiteEntry(IBlockState blockState, float size, int maxLength, int minHeight, int itemWeight) {
            this(new TFGenCaveStalactite(blockState, size, maxLength, minHeight), itemWeight);
        }
    }
}

