/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.start;

import java.util.Random;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomes;
import twilightforest.structures.StructureTFComponentTemplate;
import twilightforest.structures.darktower.ComponentTFDarkTowerMain;
import twilightforest.structures.lichtower.ComponentTFTowerMain;

public abstract class StructureStartTFAbstract
extends StructureStart {
    public StructureStartTFAbstract() {
    }

    public StructureStartTFAbstract(World world, TFFeature feature, Random rand, int chunkX, int chunkZ) {
        super(chunkX, chunkZ);
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        int y = 32;
        StructureComponent firstComponent = this.makeFirstComponent(world, feature, rand, x, y, z);
        this.field_75075_a.add(firstComponent);
        firstComponent.func_74861_a(firstComponent, this.field_75075_a, rand);
        this.func_75072_c();
        if (firstComponent instanceof ComponentTFTowerMain || firstComponent instanceof ComponentTFDarkTowerMain) {
            this.moveToAvgGroundLevel(world, x, z);
        }
        this.setupComponents(world);
    }

    protected abstract StructureComponent makeFirstComponent(World var1, TFFeature var2, Random var3, int var4, int var5, int var6);

    protected void moveToAvgGroundLevel(World world, int x, int z) {
        Biome biomeAt = world.func_180494_b(new BlockPos(x, 0, z));
        int offY = (int)((biomeAt.func_185355_j() + biomeAt.func_185360_m()) * 8.0f);
        if (biomeAt == TFBiomes.darkForest) {
            offY += 4;
        }
        if (offY > 0) {
            this.field_75074_b.func_78886_a(0, offY, 0);
            for (StructureComponent com : this.func_186161_c()) {
                com.func_74874_b().func_78886_a(0, offY, 0);
            }
        }
    }

    protected void setupComponents(World world) {
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        MinecraftServer server = world.func_73046_m();
        for (StructureComponent component : this.field_75075_a) {
            if (!(component instanceof StructureTFComponentTemplate)) continue;
            ((StructureTFComponentTemplate)component).setup(templateManager, server);
        }
    }
}

