/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import twilightforest.TwilightForestMod;

public class Baubles {
    public static boolean consumeInventoryItem(EntityPlayer player, Predicate<ItemStack> matcher, int count) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        boolean consumedSome = false;
        int slots = baubles.getSlots();
        for (int i = 0; i < slots && count > 0; ++i) {
            ItemStack stack = baubles.getStackInSlot(i);
            if (!matcher.test(stack)) continue;
            ItemStack consumed = baubles.extractItem(i, count, false);
            count -= consumed.func_190916_E();
            consumedSome = true;
        }
        return consumedSome;
    }

    public static NonNullList<ItemStack> keepBaubles(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        NonNullList kept = NonNullList.func_191197_a((int)baubles.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            kept.set(i, (Object)baubles.getStackInSlot(i).func_77946_l());
            baubles.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return kept;
    }

    public static void returnBaubles(EntityPlayer player, NonNullList<ItemStack> items) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        if (items.size() != baubles.getSlots()) {
            TwilightForestMod.LOGGER.warn("The list size doesn't equal amount of bauble slots, wtf did you do?");
            Baubles.giveItems(player, items);
            return;
        }
        NonNullList displaced = NonNullList.func_191196_a();
        for (int i = 0; i < baubles.getSlots(); ++i) {
            ItemStack kept = (ItemStack)items.get(i);
            if (kept.func_190926_b()) continue;
            ItemStack existing = baubles.getStackInSlot(i);
            baubles.setStackInSlot(i, kept);
            if (existing.func_190926_b()) continue;
            displaced.add((Object)existing);
        }
        Baubles.giveItems(player, (NonNullList<ItemStack>)displaced);
    }

    private static void giveItems(EntityPlayer player, NonNullList<ItemStack> items) {
        for (ItemStack stack : items) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
        }
    }

    public static final class BasicBaubleProvider
    implements ICapabilityProvider {
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? itemStack -> BaubleType.TRINKET : null);
        }
    }
}

