/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.BlockTFCritter;
import twilightforest.block.BlockTFGiantBlock;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.TFBlocks;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.compat.Baubles;
import twilightforest.compat.TFCompat;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.EntityTFCharmEffect;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.ITFProjectile;
import twilightforest.item.ItemTFPhantomArmor;
import twilightforest.item.TFItems;
import twilightforest.network.PacketAreaProtection;
import twilightforest.network.PacketEnforceProgressionStatus;
import twilightforest.network.PacketSetSkylightEnabled;
import twilightforest.network.PacketUpdateShield;
import twilightforest.network.TFPacketHandler;
import twilightforest.potions.TFPotions;
import twilightforest.util.TFItemStackUtils;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.TFWorld;
import twilightforest.world.WorldProviderTwilightForest;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFEventListener {
    private static final ImmutableSet<String> SHIELD_DAMAGE_BLACKLIST = ImmutableSet.of((Object)"inWall", (Object)"cramming", (Object)"drown", (Object)"starve", (Object)"fall", (Object)"flyIntoWall", (Object[])new String[]{"outOfWorld", "fallingBlock"});
    private static final Map<UUID, InventoryPlayer> playerKeepsMap = new HashMap<UUID, InventoryPlayer>();
    private static final Map<UUID, NonNullList<ItemStack>> playerKeepsMapBaubles = new HashMap<UUID, NonNullList<ItemStack>>();
    private static boolean isBreakingWithGiantPick = false;
    private static boolean shouldMakeGiantCobble = false;
    private static int amountOfCobbleToReplace = 0;
    private static Map<String, Integer> adv_to_copy = new HashMap<String, Integer>(){
        {
            this.put("triumph:hidden/magic_map", 32);
            this.put("triumph:hidden/maze_map", 32);
            this.put("triumph:hidden/progress_lich", 64);
            this.put("triumph:hidden/progress_hydra", 64);
            this.put("triumph:hidden/progress_knights", 32);
            this.put("triumph:hidden/progress_labyrinth", 64);
            this.put("triumph:hidden/progress_naga", 128);
            this.put("triumph:hidden/progress_pickaxe", 64);
            this.put("triumph:hidden/progress_trophy_pedestal", 64);
            this.put("triumph:hidden/progress_ur_ghast", 64);
            this.put("triumph:hidden/progress_yeti", 64);
            this.put("triumph:hidden/progress_beans", 64);
            this.put("triumph:hidden/progress_glacier", 64);
            this.put("triumph:hidden/progress_troll", 64);
            this.put("triumph:hidden/quest_ram", 64);
            this.put("triumph:hidden/ender_dragon", 192);
            this.put("triumph:hidden/wither", 64);
            this.put("triumph:hidden/kill@adherent", 32);
            this.put("triumph:hidden/kill@armored_giant", 32);
            this.put("triumph:hidden/kill@bat", 32);
            this.put("triumph:hidden/kill@bighorn_sheep", 32);
            this.put("triumph:hidden/kill@blaze", 32);
            this.put("triumph:hidden/kill@blockchain_goblin", 32);
            this.put("triumph:hidden/kill@cave_spider", 32);
            this.put("triumph:hidden/kill@chaos_dragon", 1024);
            this.put("triumph:hidden/kill@chicken", 32);
            this.put("triumph:hidden/kill@cow", 32);
            this.put("triumph:hidden/kill@creeper_boss", 32);
            this.put("triumph:hidden/kill@creeper", 32);
            this.put("triumph:hidden/kill@death_tome", 32);
            this.put("triumph:hidden/kill@deer", 32);
            this.put("triumph:hidden/kill@donkey", 32);
            this.put("triumph:hidden/kill@elder_guardian", 32);
            this.put("triumph:hidden/kill@ender_dragon", 192);
            this.put("triumph:hidden/kill@enderman", 32);
            this.put("triumph:hidden/kill@evolved_creeper", 32);
            this.put("triumph:hidden/kill@evolved_enderman", 32);
            this.put("triumph:hidden/kill@evolved_skeleton_boss", 32);
            this.put("triumph:hidden/kill@evolved_skeleton", 32);
            this.put("triumph:hidden/kill@evolved_spider", 32);
            this.put("triumph:hidden/kill@evolved_zombie", 32);
            this.put("triumph:hidden/kill@fire_beetle", 32);
            this.put("triumph:hidden/kill@ghast", 32);
            this.put("triumph:hidden/kill@giant_miner", 32);
            this.put("triumph:hidden/kill@goblin_knight_lower", 32);
            this.put("triumph:hidden/kill@goblin_knight_upper", 32);
            this.put("triumph:hidden/kill@guardian", 32);
            this.put("triumph:hidden/kill@harbinger_cube", 32);
            this.put("triumph:hidden/kill@hedge_spider", 32);
            this.put("triumph:hidden/kill@helmet_crab", 32);
            this.put("triumph:hidden/kill@horse", 32);
            this.put("triumph:hidden/kill@hostile_wolf", 32);
            this.put("triumph:hidden/kill@husk", 32);
            this.put("triumph:hidden/kill@kobold", 32);
            this.put("triumph:hidden/kill@llama", 32);
            this.put("triumph:hidden/kill@magma_cube", 32);
            this.put("triumph:hidden/kill@maze_slime", 32);
            this.put("triumph:hidden/kill@mini_ghast", 32);
            this.put("triumph:hidden/kill@minotaur", 32);
            this.put("triumph:hidden/kill@mist_wolf", 32);
            this.put("triumph:hidden/kill@mooshroom", 32);
            this.put("triumph:hidden/kill@mosquito_swarm", 32);
            this.put("triumph:hidden/kill@mule", 32);
            this.put("triumph:hidden/kill@ocelot", 32);
            this.put("triumph:hidden/kill@parrot", 32);
            this.put("triumph:hidden/kill@penguin", 32);
            this.put("triumph:hidden/kill@pig", 32);
            this.put("triumph:hidden/kill@pinch_beetle", 32);
            this.put("triumph:hidden/kill@pink_slime", 32);
            this.put("triumph:hidden/kill@polar_bear", 32);
            this.put("triumph:hidden/kill@quest_ram", 32);
            this.put("triumph:hidden/kill@rabbit", 32);
            this.put("triumph:hidden/kill@raven", 32);
            this.put("triumph:hidden/kill@redcap", 32);
            this.put("triumph:hidden/kill@sheep", 32);
            this.put("triumph:hidden/kill@shulker", 32);
            this.put("triumph:hidden/kill@silverfish", 32);
            this.put("triumph:hidden/kill@skeleton_druid", 32);
            this.put("triumph:hidden/kill@skeleton", 32);
            this.put("triumph:hidden/kill@slime_beetle", 32);
            this.put("triumph:hidden/kill@slime", 32);
            this.put("triumph:hidden/kill@snow_guardian", 32);
            this.put("triumph:hidden/kill@snowman", 32);
            this.put("triumph:hidden/kill@spider_queen", 32);
            this.put("triumph:hidden/kill@spider", 32);
            this.put("triumph:hidden/kill@squid", 32);
            this.put("triumph:hidden/kill@squirrel", 32);
            this.put("triumph:hidden/kill@stable_ice_core", 32);
            this.put("triumph:hidden/kill@stray", 32);
            this.put("triumph:hidden/kill@swarm_spider", 32);
            this.put("triumph:hidden/kill@tiny_bird", 32);
            this.put("triumph:hidden/kill@tower_broodling", 32);
            this.put("triumph:hidden/kill@troll", 32);
            this.put("triumph:hidden/kill@unstable_ice_core", 32);
            this.put("triumph:hidden/kill@villager_golem", 32);
            this.put("triumph:hidden/kill@villager", 32);
            this.put("triumph:hidden/kill@wild_boar", 32);
            this.put("triumph:hidden/kill@winter_wolf", 32);
            this.put("triumph:hidden/kill@witch", 32);
            this.put("triumph:hidden/kill@wither_skeleton", 32);
            this.put("triumph:hidden/kill@wither", 64);
            this.put("triumph:hidden/kill@wolf", 32);
            this.put("triumph:hidden/kill@yeti", 32);
            this.put("triumph:hidden/kill@zombie_pigman", 32);
            this.put("triumph:hidden/kill@zombie", 32);
            this.put("triumph:hidden/kill@zombie_villager", 32);
            this.put("triumph:hidden/kill@mm_alternative_maelstrom_gauntlet_stage_1", 32);
            this.put("triumph:hidden/kill@mm_alternative_maelstrom_gauntlet_stage_2", 32);
            this.put("triumph:hidden/kill@mm_azure_bullet", 32);
            this.put("triumph:hidden/kill@mm_beast_attack", 32);
            this.put("triumph:hidden/kill@mm_beast_fireball", 32);
            this.put("triumph:hidden/kill@mm_beast_quake", 32);
            this.put("triumph:hidden/kill@mm_black_fireball", 32);
            this.put("triumph:hidden/kill@mm_black_gold_sword_particle", 32);
            this.put("triumph:hidden/kill@mm_bone", 32);
            this.put("triumph:hidden/kill@mm_bone_quake", 32);
            this.put("triumph:hidden/kill@mm_brownstone_cannon", 32);
            this.put("triumph:hidden/kill@mm_chaos_fireball", 32);
            this.put("triumph:hidden/kill@mm_chaos_knight", 32);
            this.put("triumph:hidden/kill@mm_crimson_crystal", 32);
            this.put("triumph:hidden/kill@mm_crimson_wanderer", 32);
            this.put("triumph:hidden/kill@mm_explosion_particle", 32);
            this.put("triumph:hidden/kill@mm_explosive_drill", 32);
            this.put("triumph:hidden/kill@mm_fireball", 32);
            this.put("triumph:hidden/kill@mm_geyser", 32);
            this.put("triumph:hidden/kill@mm_golden_fireball", 32);
            this.put("triumph:hidden/kill@mm_golden_mage_attack", 32);
            this.put("triumph:hidden/kill@mm_golden_rune", 32);
            this.put("triumph:hidden/kill@mm_healer_orb", 32);
            this.put("triumph:hidden/kill@mm_herobrine_slash", 32);
            this.put("triumph:hidden/kill@mm_homing_flame", 32);
            this.put("triumph:hidden/kill@mm_horror_attack", 32);
            this.put("triumph:hidden/kill@mm_iron_shade", 32);
            this.put("triumph:hidden/kill@mm_large_golden_rune", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_beast", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_crawler", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_gauntlet", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_lancer", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_mage", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_meteor", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_missile", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_quake", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_rune", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_statue_of_nirvana", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_wisp", 32);
            this.put("triumph:hidden/kill@mm_maelstrom_witch", 32);
            this.put("triumph:hidden/kill@mm_mega_fireball", 32);
            this.put("triumph:hidden/kill@mm_meteor", 32);
            this.put("triumph:hidden/kill@mm_meteor_spawner", 32);
            this.put("triumph:hidden/kill@mm_monolith_fireball", 32);
            this.put("triumph:hidden/kill@mm_nexus_particle", 32);
            this.put("triumph:hidden/kill@mm_pillar_flames", 32);
            this.put("triumph:hidden/kill@mm_pumpkin", 32);
            this.put("triumph:hidden/kill@mm_rainbow_particle", 32);
            this.put("triumph:hidden/kill@mm_repeater", 32);
            this.put("triumph:hidden/kill@mm_rune_wisp", 32);
            this.put("triumph:hidden/kill@mm_shade", 32);
            this.put("triumph:hidden/kill@mm_skull_attack", 32);
            this.put("triumph:hidden/kill@mm_statue_maelstrom_missile", 32);
            this.put("triumph:hidden/kill@mm_swamp_spittle", 32);
            this.put("triumph:hidden/kill@mm_sword_slash", 32);
            this.put("triumph:hidden/kill@mm_tuning_fork_lazer_renderer", 32);
            this.put("triumph:hidden/kill@aether_legacy_aechor_plant", 16);
            this.put("triumph:hidden/kill@aether_legacy_cockatrice", 16);
            this.put("triumph:hidden/kill@aether_legacy_mimic", 16);
            this.put("triumph:hidden/kill@aether_legacy_sentry", 16);
            this.put("triumph:hidden/kill@aether_legacy_zephyr", 16);
            this.put("triumph:hidden/kill@aether_legacy_aerwhale", 16);
            this.put("triumph:hidden/kill@aether_legacy_aerbunny", 16);
            this.put("triumph:hidden/kill@aether_legacy_sheepuff", 16);
            this.put("triumph:hidden/kill@aether_legacy_valkyrie", 16);
            this.put("triumph:hidden/kill@aether_legacy_valkyrie_queen", 16);
            this.put("triumph:hidden/kill@aether_legacy_slider", 16);
            this.put("triumph:hidden/kill@aether_legacy_sun_spirit", 16);
            this.put("triumph:hidden/kill@aether_legacy_fire_minion", 16);
            this.put("triumph:hidden/kill@aether_legacy_mini_cloud", 16);
            this.put("triumph:hidden/kill@aether_legacy_tnt_present", 16);
            this.put("triumph:hidden/kill@aether_legacy_lightning_knife", 16);
            this.put("triumph:hidden/kill@aether_legacy_thunder_ball", 16);
            this.put("triumph:hidden/kill@aether_legacy_zephyr_snowball", 16);
            this.put("triumph:hidden/kill@aether_legacy_floating_block", 16);
            this.put("triumph:hidden/kill@aether_legacy_parachute", 16);
            this.put("triumph:hidden/kill@aether_legacy_golden_dart", 16);
            this.put("triumph:hidden/kill@aether_legacy_poison_dart", 16);
            this.put("triumph:hidden/kill@aether_legacy_enchanted_dart", 16);
            this.put("triumph:hidden/kill@aether_legacy_fire_ball", 16);
            this.put("triumph:hidden/kill@aether_legacy_ice_ball", 16);
            this.put("triumph:hidden/kill@aether_legacy_flying_cow", 16);
            this.put("triumph:hidden/kill@aether_legacy_phyg", 16);
            this.put("triumph:hidden/kill@aether_legacy_swet", 16);
            this.put("triumph:hidden/kill@aether_legacy_moa", 16);
            this.put("triumph:hidden/kill@aether_legacy_whirlwind", 16);
            this.put("triumph:hidden/kill@biomesoplentywasp", 32);
            this.put("triumph:hidden/kill@minecraftevocation_illager", 32);
            this.put("triumph:hidden/kill@minecraftskeleton_horse", 32);
            this.put("triumph:hidden/kill@minecraftvex", 32);
            this.put("triumph:hidden/kill@minecraftvindication_illager", 32);
            this.put("triumph:hidden/kill@minecraftzombie_horse", 32);
            this.put("triumph:hidden/kill@thermalfoundationbasalz", 32);
            this.put("triumph:hidden/kill@thermalfoundationblitz", 32);
            this.put("triumph:hidden/kill@thermalfoundationblizz", 32);
            this.put("triumph:hidden/kill@twilightforestking_spider", 32);
            this.put("triumph:hidden/kill@twilightforestredcap_sapper", 32);
            this.put("triumph:hidden/kill@twilightforesttower_ghast", 32);
            this.put("triumph:hidden/kill@twilightforesttower_golem", 32);
            this.put("triumph:hidden/kill@twilightforesttower_termite", 32);
            this.put("triumph:hidden/kill@twilightforestwraith", 32);
        }
    };
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";
    private static boolean globalParry = !Loader.isModLoaded((String)"parry");

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.crafting;
        EntityPlayer player = event.player;
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f) && itemStack.func_190916_E() == 64 && TFEventListener.doesCraftMatrixHaveGiantLog(event.craftMatrix)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
        }
    }

    private static boolean doesCraftMatrixHaveGiantLog(IInventory inv) {
        Item giantLogItem = Item.func_150898_a((Block)TFBlocks.giant_log);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_77973_b() != giantLogItem) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (shouldMakeGiantCobble && event.getDrops().size() > 0 && ((ItemStack)event.getDrops().get(0)).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e)) {
            event.getDrops().remove(0);
            if (amountOfCobbleToReplace == 64) {
                event.getDrops().add(new ItemStack(TFBlocks.giant_cobblestone));
            }
            if (--amountOfCobbleToReplace <= 0) {
                shouldMakeGiantCobble = false;
            }
        }
    }

    @SubscribeEvent
    public static void entityHurts(LivingHurtEvent event) {
        ItemStack stack;
        Block block;
        EntityPlayer player;
        EntityLivingBase living = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        String damageType = damageSource.func_76355_l();
        Entity trueSource = damageSource.func_76346_g();
        if (living instanceof EntityPlayer && damageType.equals("mob") && trueSource != null) {
            player = (EntityPlayer)living;
            int fireLevel = TFEnchantment.getFieryAuraLevel(player.field_71071_by, damageSource);
            if (fireLevel > 0 && player.func_70681_au().nextInt(25) < fireLevel) {
                trueSource.func_70015_d(fireLevel / 2);
            }
        }
        if (living instanceof EntityPlayer && damageType.equals("mob") && trueSource instanceof EntityLivingBase) {
            player = (EntityPlayer)living;
            int chillLevel = TFEnchantment.getChillAuraLevel(player.field_71071_by, damageSource);
            if (chillLevel > 0) {
                ((EntityLivingBase)trueSource).func_70690_d(new PotionEffect(TFPotions.frosty, chillLevel * 5 + 5, chillLevel));
            }
        }
        if (damageType.equals("arrow") && trueSource instanceof EntityPlayer && ((player = (EntityPlayer)trueSource).func_184614_ca().func_77973_b() == TFItems.triple_bow || player.func_184592_cb().func_77973_b() == TFItems.triple_bow)) {
            living.field_70172_ad = 0;
        }
        if (damageType.equals("arrow") && trueSource instanceof EntityPlayer && ((player = (EntityPlayer)trueSource).func_184614_ca().func_77973_b() == TFItems.ender_bow || player.func_184592_cb().func_77973_b() == TFItems.ender_bow)) {
            double sourceX = player.field_70165_t;
            double sourceY = player.field_70163_u;
            double sourceZ = player.field_70161_v;
            float sourceYaw = player.field_70177_z;
            float sourcePitch = player.field_70125_A;
            player.field_70177_z = living.field_70177_z;
            player.field_70125_A = living.field_70125_A;
            player.func_70634_a(living.field_70165_t, living.field_70163_u, living.field_70161_v);
            player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            living.func_70080_a(sourceX, sourceY, sourceZ, sourceYaw, sourcePitch);
            living.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        if ((block = Block.func_149634_a((Item)(stack = living.func_184582_a(EntityEquipmentSlot.HEAD)).func_77973_b())) instanceof BlockTFCritter) {
            BlockTFCritter poorBug = (BlockTFCritter)block;
            living.func_184201_a(EntityEquipmentSlot.HEAD, poorBug.getSquishResult());
            living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, poorBug.func_185467_w().func_185845_c(), living.func_184176_by(), 1.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void charmOfLife(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        boolean charm1 = false;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(living, s -> s.func_77973_b() == TFItems.charm_of_life_2, 1);
        if (!charm2) {
            charm1 = TFItemStackUtils.consumeInventoryItem(living, s -> s.func_77973_b() == TFItems.charm_of_life_1, 1);
        }
        if (charm2 || charm1) {
            if (charm1) {
                living.func_70606_j(8.0f);
                living.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 0));
            }
            if (charm2) {
                living.func_70606_j((float)living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                living.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 3));
                living.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 600, 0));
                living.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 600, 0));
            }
            EntityTFCharmEffect effect = new EntityTFCharmEffect(living.field_70170_p, living, charm1 ? TFItems.charm_of_life_1 : TFItems.charm_of_life_2);
            living.field_70170_p.func_72838_d((Entity)effect);
            EntityTFCharmEffect effect2 = new EntityTFCharmEffect(living.field_70170_p, living, charm1 ? TFItems.charm_of_life_1 : TFItems.charm_of_life_2);
            effect2.offset = (float)Math.PI;
            living.field_70170_p.func_72838_d((Entity)effect2);
            living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_191263_gW, living.func_184176_by(), 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void charmOfKeeping(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        if (living instanceof EntityPlayer && !living.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            TFEventListener.keepItems((EntityPlayer)living);
        }
    }

    private static void keepItems(EntityPlayer player) {
        int i;
        TFEventListener.dropStoredItems(player);
        boolean tier3 = TFItemStackUtils.consumeInventoryItem((EntityLivingBase)player, s -> s.func_77973_b() == TFItems.charm_of_keeping_3, 1);
        boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem((EntityLivingBase)player, s -> s.func_77973_b() == TFItems.charm_of_keeping_2, 1);
        boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem((EntityLivingBase)player, s -> s.func_77973_b() == TFItems.charm_of_keeping_1, 1);
        InventoryPlayer keepInventory = new InventoryPlayer(null);
        UUID playerUUID = player.func_110124_au();
        if (tier1) {
            TFEventListener.keepAllArmor(player, keepInventory);
            TFEventListener.keepOffHand(player, keepInventory);
        }
        if (tier3) {
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            keepInventory.func_70437_b(new ItemStack(TFItems.charm_of_keeping_3));
        } else if (tier2) {
            for (i = 0; i < 9; ++i) {
                keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            keepInventory.func_70437_b(new ItemStack(TFItems.charm_of_keeping_2));
        } else if (tier1) {
            i = player.field_71071_by.field_70461_c;
            if (InventoryPlayer.func_184435_e((int)i)) {
                keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            keepInventory.func_70437_b(new ItemStack(TFItems.charm_of_keeping_1));
        }
        for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_77973_b() != TFItems.tower_key) continue;
            keepInventory.field_70462_a.set(i, (Object)stack.func_77946_l());
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        if (tier1 && TFCompat.BAUBLES.isActivated()) {
            playerKeepsMapBaubles.put(playerUUID, Baubles.keepBaubles(player));
        }
        for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (!(armor.func_77973_b() instanceof ItemTFPhantomArmor)) continue;
            keepInventory.field_70460_b.set(i, (Object)armor.func_77946_l());
            player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
        playerKeepsMap.put(playerUUID, keepInventory);
    }

    private static void keepAllArmor(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            keepInventory.field_70460_b.set(i, (Object)((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77946_l());
            player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    private static void keepOffHand(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
            keepInventory.field_184439_c.set(i, (Object)((ItemStack)player.field_71071_by.field_184439_c.get(i)).func_77946_l());
            player.field_71071_by.field_184439_c.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            TFEventListener.updateCapabilities((EntityPlayerMP)event.player, (Entity)event.player);
        } else {
            TFEventListener.returnStoredItems(event.player);
        }
    }

    private static void returnStoredItems(EntityPlayer player) {
        NonNullList<ItemStack> baubles;
        InventoryPlayer keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            ItemStack existing;
            ItemStack kept;
            int i;
            TwilightForestMod.LOGGER.debug("Player {} respawned and received items held in storage", (Object)player.func_70005_c_());
            NonNullList displaced = NonNullList.func_191196_a();
            for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                kept = (ItemStack)keepInventory.field_70460_b.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_70460_b.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
                kept = (ItemStack)keepInventory.field_184439_c.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_184439_c.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                kept = (ItemStack)keepInventory.field_70462_a.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_70462_a.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (ItemStack extra : displaced) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)extra);
            }
            if (!keepInventory.func_70445_o().func_190926_b()) {
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187941_ho, player.func_184176_by(), 1.5f, 1.0f);
            }
        }
        if (TFCompat.BAUBLES.isActivated() && (baubles = playerKeepsMapBaubles.remove(player.func_110124_au())) != null) {
            TwilightForestMod.LOGGER.debug("Player {} respawned and received baubles held in storage", (Object)player.func_70005_c_());
            Baubles.returnBaubles(player, baubles);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        TFEventListener.dropStoredItems(event.player);
    }

    private static void dropStoredItems(EntityPlayer player) {
        NonNullList<ItemStack> baubles;
        InventoryPlayer keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            TwilightForestMod.LOGGER.warn("Dropping inventory items previously held in reserve for player {}", (Object)player.func_70005_c_());
            keepInventory.field_70458_d = player;
            keepInventory.func_70436_m();
        }
        if (TFCompat.BAUBLES.isActivated() && (baubles = playerKeepsMapBaubles.remove(player.func_110124_au())) != null) {
            TwilightForestMod.LOGGER.warn("Dropping baubles previously held in reserve for player {}", (Object)player.func_70005_c_());
            for (ItemStack itemStack : baubles) {
                if (itemStack.func_190926_b()) continue;
                player.func_146097_a(itemStack, true, false);
            }
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        IShieldCapability cap = (IShieldCapability)living.getCapability(CapabilityList.SHIELDS, null);
        if (cap != null) {
            cap.update();
        }
        if (living instanceof EntityPlayer && living.func_70093_af() && TFEventListener.isRidingUnfriendly(living)) {
            living.func_70095_a(false);
        }
    }

    public static boolean isRidingUnfriendly(EntityLivingBase entity) {
        return entity.func_184218_aH() && entity.func_184187_bx() instanceof IHostileMount;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        if (world.field_72995_K) {
            return;
        }
        if (TFEventListener.isBlockProtectedFromBreaking(world, pos) && TFEventListener.isAreaProtected(world, player, pos)) {
            event.setCanceled(true);
        } else if (!isBreakingWithGiantPick && TFEventListener.canHarvestWithGiantPick(player, state)) {
            boolean allCobble;
            isBreakingWithGiantPick = true;
            Item cobbleItem = Item.func_150898_a((Block)Blocks.field_150347_e);
            boolean bl = allCobble = state.func_177230_c().func_180660_a(state, world.field_73012_v, 0) == cobbleItem;
            if (allCobble) {
                for (BlockPos dPos : BlockTFGiantBlock.getVolume(pos)) {
                    IBlockState stateThere;
                    if (dPos.equals((Object)pos) || (stateThere = world.func_180495_p(dPos)).func_177230_c().func_180660_a(stateThere, world.field_73012_v, 0) == cobbleItem) continue;
                    allCobble = false;
                    break;
                }
            }
            if (allCobble && !player.field_71075_bZ.field_75098_d) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                for (BlockPos dPos : BlockTFGiantBlock.getVolume(pos)) {
                    if (dPos.equals((Object)pos) || state != world.func_180495_p(dPos)) continue;
                    playerMP.field_71134_c.func_180237_b(dPos);
                }
            }
            isBreakingWithGiantPick = false;
        }
    }

    private static boolean canHarvestWithGiantPick(EntityPlayer player, IBlockState state) {
        ItemStack heldStack = player.func_184614_ca();
        Item heldItem = heldStack.func_77973_b();
        return heldItem == TFItems.giant_pickaxe && heldItem.canHarvestBlock(state, heldStack);
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && TFEventListener.isBlockProtectedFromInteraction(world, event.getPos()) && TFEventListener.isAreaProtected(world, player, event.getPos())) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    private static boolean isBlockProtectedFromInteraction(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == TFBlocks.tower_device || block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_150430_aB || block == Blocks.field_150471_bO || block == Blocks.field_150442_at;
    }

    private static boolean isBlockProtectedFromBreaking(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_177230_c().getRegistryName().func_110623_a().contains("grave");
    }

    private static boolean isAreaProtected(World world, EntityPlayer player, BlockPos pos) {
        TFFeature nearbyFeature;
        if (player.field_71075_bZ.field_75098_d || !TFWorld.isProgressionEnforced(world)) {
            return false;
        }
        ChunkGeneratorTFBase chunkGenerator = TFWorld.getChunkGenerator(world);
        if (chunkGenerator != null && chunkGenerator.isBlockInStructureBB(pos) && !(nearbyFeature = TFFeature.getFeatureAt(pos.func_177958_n(), pos.func_177952_p(), world)).doesPlayerHaveRequiredAdvancements(player) && chunkGenerator.isBlockProtected(pos)) {
            TFEventListener.sendAreaProtectionPacket(world, pos, chunkGenerator.getSBBAt(pos));
            nearbyFeature.trySpawnHintMonster(world, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(World world, BlockPos pos, StructureBoundingBox sbb) {
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
        TFPacketHandler.CHANNEL.sendToAllAround((IMessage)new PacketAreaProtection(sbb, pos), targetPoint);
    }

    @SubscribeEvent
    public static void livingAttack(LivingAttackEvent event) {
        IShieldCapability cap;
        EntityLivingBase living = event.getEntityLiving();
        if (!living.field_70170_p.field_72995_K && living instanceof IMob && event.getSource().func_76346_g() instanceof EntityPlayer && TFEventListener.isAreaProtected(living.field_70170_p, (EntityPlayer)event.getSource().func_76346_g(), new BlockPos((Entity)living))) {
            event.setCanceled(true);
            return;
        }
        if (!living.field_70170_p.field_72995_K && !SHIELD_DAMAGE_BLACKLIST.contains((Object)event.getSource().field_76373_n) && (cap = (IShieldCapability)living.getCapability(CapabilityList.SHIELDS, null)) != null && cap.shieldsLeft() > 0) {
            cap.breakShield();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            TFEventListener.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, TFWorld.isProgressionEnforced(event.player.field_70170_p));
            TFEventListener.updateCapabilities((EntityPlayerMP)event.player, (Entity)event.player);
            TFEventListener.banishNewbieToTwilightZone(event.player);
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            if (event.toDim == TFConfig.dimension.dimensionID) {
                TFEventListener.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, TFWorld.isProgressionEnforced(event.player.field_70170_p));
            }
            TFEventListener.updateCapabilities((EntityPlayerMP)event.player, (Entity)event.player);
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        TFEventListener.updateCapabilities((EntityPlayerMP)event.getEntityPlayer(), event.getTarget());
    }

    private static void updateCapabilities(EntityPlayerMP player, Entity entity) {
        IShieldCapability cap = (IShieldCapability)entity.getCapability(CapabilityList.SHIELDS, null);
        if (cap != null && cap.shieldsLeft() > 0) {
            TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketUpdateShield(entity, cap), player);
        }
    }

    private static void sendEnforcedProgressionStatus(EntityPlayerMP player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketEnforceProgressionStatus(isEnforced), player);
    }

    private static void sendSkylightEnabled(EntityPlayerMP player, boolean skylightEnabled) {
        TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketSetSkylightEnabled(skylightEnabled), player);
    }

    @SubscribeEvent
    public static void onClientConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        INetHandlerPlayServer handler = (INetHandlerPlayServer)event.getHandler();
        if (handler instanceof NetHandlerPlayServer) {
            EntityPlayerMP player = ((NetHandlerPlayServer)handler).field_147369_b;
            TFEventListener.sendSkylightEnabled(player, WorldProviderTwilightForest.isSkylightEnabled(TFWorld.getDimensionData(player.field_70170_p)));
        }
    }

    @SubscribeEvent
    public static void onServerDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        WorldProviderTwilightForest.syncFromConfig();
    }

    @SubscribeEvent
    public static void worldLoaded(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && !event.getWorld().func_82736_K().func_82765_e("tfEnforcedProgression")) {
            TwilightForestMod.LOGGER.info("Loaded a world with the {} game rule not defined. Defining it.", (Object)"tfEnforcedProgression");
            event.getWorld().func_82736_K().func_180262_a("tfEnforcedProgression", String.valueOf(TFConfig.progressionRuleDefault), GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    @SubscribeEvent
    public static void gameRuleChanged(GameRuleChangeEvent event) {
        if (event.getRuleName().equals("tfEnforcedProgression")) {
            boolean isEnforced = event.getRules().func_82766_b("tfEnforcedProgression");
            TFPacketHandler.CHANNEL.sendToAll((IMessage)new PacketEnforceProgressionStatus(isEnforced));
        }
    }

    private static void banishNewbieToTwilightZone(EntityPlayer player) {
        NBTTagCompound tagCompound = player.getEntityData();
        NBTTagCompound playerData = tagCompound.func_74775_l("PlayerPersisted");
        boolean shouldBanishPlayer = TFConfig.dimension.newPlayersSpawnInTF && !playerData.func_74767_n(NBT_TAG_TWILIGHT);
        playerData.func_74757_a(NBT_TAG_TWILIGHT, true);
        tagCompound.func_74782_a("PlayerPersisted", (NBTBase)playerData);
        if (shouldBanishPlayer) {
            BlockTFPortal.attemptSendPlayer((Entity)player, true);
        }
    }

    public static ResourceLocation getKey(String key) {
        return new ResourceLocation("twilightforest", key);
    }

    public static void grantCriterion(EntityPlayer entityPlayer, Advancement advancement) {
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        for (String string : player.func_192039_O().func_192747_a(advancement).func_192107_d()) {
            player.func_192039_O().func_192750_a(advancement, string);
        }
    }

    @SubscribeEvent
    public static void onAdvancementGet(AdvancementEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof EntityPlayerMP) {
            World world = player.func_130014_f_();
            String advancementid = event.getAdvancement().func_192067_g().toString();
            if (adv_to_copy.containsKey(advancementid)) {
                for (EntityPlayer mpplayer : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(player.func_180425_c()).func_186662_g((double)adv_to_copy.get(advancementid).intValue()))) {
                    TFEventListener.grantCriterion(mpplayer, event.getAdvancement());
                }
            }
            TFAdvancements.ADVANCEMENT_UNLOCKED.trigger((EntityPlayerMP)player, event.getAdvancement());
        }
    }

    @SubscribeEvent
    public static void armorChanged(LivingEquipmentChangeEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (!living.field_70170_p.field_72995_K && living instanceof EntityPlayerMP) {
            TFAdvancements.ARMOR_CHANGED.trigger((EntityPlayerMP)living, event.getFrom(), event.getTo());
        }
    }

    @SubscribeEvent
    public static void arrowParry(ProjectileImpactEvent.Arrow event) {
        final EntityArrow projectile = event.getArrow();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (TFConfig.shieldInteractions.parryNonTwilightAttacks || projectile instanceof ITFProjectile)) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= TFConfig.shieldInteractions.shieldParryTicksArrow) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.field_70250_c = entityBlocking;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void fireballParry(ProjectileImpactEvent.Fireball event) {
        final EntityFireball projectile = event.getFireball();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (TFConfig.shieldInteractions.parryNonTwilightAttacks || projectile instanceof ITFProjectile)) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= TFConfig.shieldInteractions.shieldParryTicksFireball) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.field_70159_w = playerVec3.field_72450_a;
                projectile.field_70181_x = playerVec3.field_72448_b;
                projectile.field_70179_y = playerVec3.field_72449_c;
                projectile.field_70232_b = projectile.field_70159_w * 0.1;
                projectile.field_70233_c = projectile.field_70181_x * 0.1;
                projectile.field_70230_d = projectile.field_70179_y * 0.1;
                projectile.field_70235_a = entityBlocking;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void throwableParry(ProjectileImpactEvent.Throwable event) {
        final EntityThrowable projectile = event.getThrowable();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (TFConfig.shieldInteractions.parryNonTwilightAttacks || projectile instanceof ITFProjectile)) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= TFConfig.shieldInteractions.shieldParryTicksThrowable) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.field_70192_c = entityBlocking;
                event.setCanceled(true);
            }
        }
    }
}

