/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.integration.hwyla;

import com.kotori316.fluidtank.Utils;
import com.kotori316.fluidtank.integration.hwyla.TankWailaPlugin;
import com.kotori316.fluidtank.tiles.Tiers;
import com.kotori316.fluidtank.tiles.TileTankNoDisplay;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaDataProvider", modid="waila")
public class TankDataProvider
implements IWailaDataProvider {
    private static final Predicate<Object> NOT_EMPTY = Predicate.isEqual("None").negate();
    private static final String NBT_LockedFluidType = "LockedFluidType";

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity t = accessor.getTileEntity();
        if (t instanceof TileTankNoDisplay && config.getConfig("fluidtank.waila.tankinfo")) {
            List<Object> list;
            TileTankNoDisplay tank = (TileTankNoDisplay)t;
            TankDataProvider.removeTag(tooltip, "IFluidHandler");
            NBTTagCompound nbtData = accessor.getNBTData();
            String reactorTime = "";
            if (!config.getConfig("fluidtank.waila.shortinfo")) {
                Tiers tier = tank.tier();
                if (nbtData.func_74767_n("Normal")) {
                    list = Arrays.asList(I18n.func_135052_a((String)"fluidtank.waila.tier", (Object[])new Object[]{tier.toString()}), I18n.func_135052_a((String)"fluidtank.waila.content", (Object[])new Object[]{nbtData.func_74779_i("FluidName")}), I18n.func_135052_a((String)"fluidtank.waila.amount", (Object[])new Object[]{nbtData.func_74763_f("ConnectionAmount")}), I18n.func_135052_a((String)"fluidtank.waila.capacity", (Object[])new Object[]{nbtData.func_74763_f("ConnectionCapacity")}), I18n.func_135052_a((String)"fluidtank.waila.comparator", (Object[])new Object[]{nbtData.func_74762_e("Comparator")}));
                } else {
                    String fluidName = TankDataProvider.getCreativeFluidName(tank);
                    list = Arrays.asList(I18n.func_135052_a((String)"fluidtank.waila.tier", (Object[])new Object[]{tier.toString()}), I18n.func_135052_a((String)"fluidtank.waila.content", (Object[])new Object[]{fluidName}));
                }
            } else if (nbtData.func_74767_n("Normal")) {
                list = Arrays.asList(I18n.func_135052_a((String)"fluidtank.waila.short", (Object[])new Object[]{nbtData.func_74779_i("FluidName"), nbtData.func_74763_f("ConnectionAmount"), nbtData.func_74763_f("ConnectionCapacity")}));
                if (nbtData.func_74779_i("FluidName").equals("Liquid Soul") || nbtData.func_74779_i("FluidName").equals("Reactor Fuel")) {
                    reactorTime = "Reactor Time: " + this.printTime(nbtData.func_74763_f("ConnectionAmount"));
                }
            } else {
                String fluidName = TankDataProvider.getCreativeFluidName(tank);
                list = Optional.of(fluidName).filter(NOT_EMPTY).map(Collections::singletonList).orElse(Collections.emptyList());
            }
            if (nbtData.func_74779_i("FluidName").equals("Liquid XP")) {
                tooltip.add("Player Levels: " + TankDataProvider.getLevelsFromXP(nbtData.func_74763_f("ConnectionAmount")));
            }
            tooltip.addAll(list);
            if (!reactorTime.isEmpty()) {
                tooltip.add(reactorTime);
            }
            if (!nbtData.func_74764_b(NBT_LockedFluidType) || nbtData.func_74779_i(NBT_LockedFluidType).isEmpty()) {
                tooltip.add("shift+right click to lock to current fluid");
            } else {
                tooltip.add("Fluid locked to: " + TextFormatting.AQUA + nbtData.func_74779_i(NBT_LockedFluidType));
                tooltip.add("shift+right click to unlock");
            }
        }
        return tooltip;
    }

    public static String getLevelsFromXP(long xp) {
        int level = 0;
        float progressTowardsNext = 0.0f;
        xp /= 20L;
        while (xp > 0L) {
            int xpToNext = TankDataProvider.xpToNext(level);
            if (xp >= (long)xpToNext) {
                ++level;
                xp -= (long)xpToNext;
                continue;
            }
            progressTowardsNext = (float)xp / (float)xpToNext;
            break;
        }
        float totalLevels = (float)level + progressTowardsNext;
        return String.format("%.1f", Float.valueOf(totalLevels));
    }

    private static int xpToNext(int level) {
        if (level <= 16) {
            return 2 * level + 7;
        }
        if (level <= 31) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    private String printTime(long seconds) {
        int day = (int)TimeUnit.SECONDS.toDays(seconds /= 20L);
        long hours = TimeUnit.SECONDS.toHours(seconds) - (long)(day * 24);
        long minute = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        return day + "D " + String.format("%02d", hours) + ":" + String.format("%02d", minute) + ":" + String.format("%02d", second);
    }

    @Nonnull
    private static String getCreativeFluidName(TileTankNoDisplay tank) {
        return Optional.ofNullable(tank.tank().getFluid()).map(FluidStack::getLocalizedName).orElse("None");
    }

    @Nonnull
    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof TileTankNoDisplay) {
            TileTankNoDisplay tank = (TileTankNoDisplay)te;
            tag.func_74778_a(TankWailaPlugin.NBT_Tier, tank.tier().toString());
            tag.func_74778_a("FluidName", Utils.toJava(tank.connection().getFluidStack()).map(FluidStack::getLocalizedName).orElse("None"));
            if (!tank.connection().hasCreative()) {
                tag.func_74757_a("Normal", true);
                tag.func_74772_a("ConnectionAmount", tank.connection().amount());
                tag.func_74772_a("ConnectionCapacity", tank.connection().capacity());
                tag.func_74768_a("Comparator", tank.getComparatorLevel());
                tag.func_74778_a(NBT_LockedFluidType, tank.getLockedFluidType());
            }
        }
        return tag;
    }

    private static void removeTag(List<?> list, String tag) {
        if (list instanceof ITaggedList) {
            ITaggedList taggedList = (ITaggedList)list;
            taggedList.removeEntries((Object)tag);
        }
    }
}

