/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class AdvancementWorldData {
    private static String FILE_NAME;
    private static ConcurrentHashMap<String, String> advancementMap;

    public static void loadAdvancementWorldData() {
        File file = new File(FILE_NAME);
        if (!file.exists()) {
            try {
                file.createNewFile();
                AdvancementWorldData.saveToFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            FileReader reader = new FileReader(FILE_NAME);
            Type type = new TypeToken<ConcurrentHashMap<String, String>>(){}.getType();
            advancementMap = (ConcurrentHashMap)new Gson().fromJson((Reader)reader, type);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkAdvancement(String key) {
        return advancementMap.containsKey(key);
    }

    public static void update(String key) {
        advancementMap.put(key, key);
        AdvancementWorldData.saveToFile();
    }

    private static void saveToFile() {
        try {
            FileWriter writer = new FileWriter(FILE_NAME);
            new Gson().toJson(advancementMap, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            File worldDir = server.func_71218_a(0).func_72860_G().func_75765_b();
            FILE_NAME = new File(worldDir, "torgoAdvancements.json").getAbsolutePath();
        }
        advancementMap = new ConcurrentHashMap();
    }
}

