/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo.genoil;

import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import org.torgy.torgo.genoil.Box;
import org.torgy.torgo.genoil.OilGenerator;
import org.torgy.torgo.genoil.VecUtil;

public abstract class OilGenStructure {
    public final Box box;
    public final ReplaceType replaceType;

    public OilGenStructure(Box containingBox, ReplaceType replaceType) {
        this.box = containingBox;
        this.replaceType = replaceType;
    }

    public static void setOil(World world, BlockPos pos) {
        world.func_180501_a(pos, FluidRegistry.getFluid((String)"bacterialsludge").getBlock().func_176223_P(), 2);
    }

    public final void generate(World world, Box within) {
        Box intersect2 = this.box.getIntersect(within);
        if (intersect2 != null) {
            this.generateWithin(world, intersect2);
        }
    }

    protected abstract void generateWithin(World var1, Box var2);

    protected abstract int countOilBlocks();

    public void setOilIfCanReplace(World world, BlockPos pos) {
        if (this.canReplaceForOil(world, pos)) {
            OilGenStructure.setOil(world, pos);
        }
    }

    public boolean canReplaceForOil(World world, BlockPos pos) {
        return this.replaceType.canReplace(world, pos);
    }

    public static class Spring
    extends OilGenStructure {
        public final BlockPos pos;

        public Spring(BlockPos pos) {
            super(new Box(pos, pos), ReplaceType.ALWAYS);
            this.pos = pos;
        }

        @Override
        protected void generateWithin(World world, Box intersect2) {
        }

        @Override
        protected int countOilBlocks() {
            return 0;
        }
    }

    public static class Spout
    extends OilGenStructure {
        public final BlockPos start;
        public final int radius;
        public final int height;
        private int count = 0;

        public Spout(BlockPos start, ReplaceType replaceType, int radius, int height) {
            super(Spout.createBox(start), replaceType);
            this.start = start;
            this.radius = radius;
            this.height = height;
        }

        private static Box createBox(BlockPos start) {
            return new Box(start, VecUtil.replaceValue((Vec3i)start, EnumFacing.Axis.Y, 256));
        }

        @Override
        protected void generateWithin(World world, Box intersect2) {
            IBlockState state;
            this.count = 0;
            int segment = world.func_175726_f(this.start).func_76625_h();
            BlockPos worldTop = new BlockPos(this.start.func_177958_n(), segment + 16, this.start.func_177952_p());
            for (int y = segment; y >= this.start.func_177956_o() && ((state = world.func_180495_p(worldTop = worldTop.func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, worldTop) || !state.func_185904_a().func_76230_c()); --y) {
            }
            OilGenStructure tubeY = OilGenerator.createTube(this.start, worldTop.func_177956_o() - this.start.func_177956_o(), this.radius, EnumFacing.Axis.Y);
            tubeY.generate(world, tubeY.box);
            this.count += tubeY.countOilBlocks();
            BlockPos base = worldTop;
            for (int r = this.radius; r >= 0; --r) {
                OilGenStructure struct = OilGenerator.createTube(base, this.height, r, EnumFacing.Axis.Y);
                struct.generate(world, struct.box);
                base = base.func_177982_a(0, this.height, 0);
                this.count += struct.countOilBlocks();
            }
        }

        @Override
        protected int countOilBlocks() {
            if (this.count == 0) {
                throw new IllegalStateException("Called countOilBlocks before calling generateWithin!");
            }
            return this.count;
        }
    }

    public static class PatternTerrainHeight
    extends OilGenStructure {
        private final boolean[][] pattern;
        private final int depth;

        private PatternTerrainHeight(Box containingBox, ReplaceType replaceType, boolean[][] pattern, int depth) {
            super(containingBox, replaceType);
            this.pattern = pattern;
            this.depth = depth;
        }

        public static PatternTerrainHeight create(BlockPos start, ReplaceType replaceType, boolean[][] pattern, int depth) {
            BlockPos min = VecUtil.replaceValue((Vec3i)start, EnumFacing.Axis.Y, 1);
            BlockPos max = min.func_177982_a(pattern.length - 1, 255, pattern.length == 0 ? 0 : pattern[0].length - 1);
            Box box = new Box(min, max);
            return new PatternTerrainHeight(box, replaceType, pattern, depth);
        }

        @Override
        protected void generateWithin(World world, Box intersect2) {
            for (int x = intersect2.min().func_177958_n(); x <= intersect2.max().func_177958_n(); ++x) {
                int px = x - this.box.min().func_177958_n();
                for (int z = intersect2.min().func_177952_p(); z <= intersect2.max().func_177952_p(); ++z) {
                    int y;
                    BlockPos upper;
                    int pz = z - this.box.min().func_177952_p();
                    if (!this.pattern[px][pz] || !this.canReplaceForOil(world, upper = world.func_175645_m(new BlockPos(x, 0, z)).func_177977_b())) continue;
                    for (y = 0; y < 5; ++y) {
                        world.func_175698_g(upper.func_177981_b(y));
                    }
                    for (y = 0; y < this.depth; ++y) {
                        this.setOilIfCanReplace(world, upper.func_177979_c(y));
                    }
                }
            }
        }

        @Override
        protected int countOilBlocks() {
            int count = 0;
            for (int x = 0; x < this.pattern.length; ++x) {
                for (int z = 0; z < this.pattern[x].length; ++z) {
                    if (!this.pattern[x][z]) continue;
                    ++count;
                }
            }
            return count * this.depth;
        }
    }

    public static class FlatPattern
    extends OilGenStructure {
        private final boolean[][] pattern;
        private final int depth;

        private FlatPattern(Box containingBox, ReplaceType replaceType, boolean[][] pattern, int depth) {
            super(containingBox, replaceType);
            this.pattern = pattern;
            this.depth = depth;
        }

        public static FlatPattern create(BlockPos start, ReplaceType replaceType, boolean[][] pattern, int depth) {
            BlockPos min = start.func_177982_a(0, 1 - depth, 0);
            BlockPos max = start.func_177982_a(pattern.length - 1, 0, pattern.length == 0 ? 0 : pattern[0].length - 1);
            Box box = new Box(min, max);
            return new FlatPattern(box, replaceType, pattern, depth);
        }

        @Override
        protected void generateWithin(World world, Box intersect2) {
            BlockPos start = this.box.min();
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)intersect2.min(), (BlockPos)intersect2.max())) {
                int z;
                int x = pos.func_177958_n() - start.func_177958_n();
                if (!this.pattern[x][z = pos.func_177952_p() - start.func_177952_p()]) continue;
                this.setOilIfCanReplace(world, pos);
            }
        }

        @Override
        protected int countOilBlocks() {
            int count = 0;
            for (int x = 0; x < this.pattern.length; ++x) {
                for (int z = 0; z < this.pattern[x].length; ++z) {
                    if (!this.pattern[x][z]) continue;
                    ++count;
                }
            }
            return count * this.depth;
        }
    }

    public static class GenByPredicate
    extends OilGenStructure {
        public final Predicate<BlockPos> predicate;

        public GenByPredicate(Box containingBox, ReplaceType replaceType, Predicate<BlockPos> predicate) {
            super(containingBox, replaceType);
            this.predicate = predicate;
        }

        @Override
        protected void generateWithin(World world, Box intersect2) {
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)intersect2.min(), (BlockPos)intersect2.max())) {
                if (!this.predicate.test(pos)) continue;
                this.setOilIfCanReplace(world, pos);
            }
        }

        @Override
        protected int countOilBlocks() {
            int count = 0;
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.box.min(), (BlockPos)this.box.max())) {
                if (!this.predicate.test(pos)) continue;
                ++count;
            }
            return count;
        }
    }

    public static enum ReplaceType {
        ALWAYS{

            @Override
            public boolean canReplace(World world, BlockPos pos) {
                return true;
            }
        }
        ,
        IS_FOR_LAKE{

            @Override
            public boolean canReplace(World world, BlockPos pos) {
                return ALWAYS.canReplace(world, pos);
            }
        };


        public abstract boolean canReplace(World var1, BlockPos var2);
    }
}

