/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerCape;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.api.IProcess;
import p455w0rdslib.client.render.LayerContribDankNull;
import p455w0rdslib.client.render.LayerContributorWings;
import p455w0rdslib.handlers.ProcessHandler;
import p455w0rdslib.handlers.ProcessHandlerClient;
import p455w0rdslib.util.DateUtils;

@SideOnly(value=Side.CLIENT)
public class ContributorUtils {
    private static List<String> PATRON_LIST = Lists.newArrayList();
    public static Map<UUID, LayerContributorWings.Type> REGISTRY = new LinkedHashMap<UUID, LayerContributorWings.Type>();
    public static List<UUID> SPECIAL_PLAYERS = Lists.newArrayList();
    public static LayerContributorWings layerWings;
    public static LayerContribDankNull layerDankNull;
    private static DLThread thread;

    public static void queuePlayerCosmetics(final AbstractClientPlayer player) {
        if (LibGlobals.CONTRIBUTOR_FILE_DOWNLOADED) {
            Minecraft.func_71410_x().func_152344_a(() -> ContributorUtils.addCosmetic(player));
            return;
        }
        if (!ContributorUtils.isOnlineMode((EntityPlayer)player)) {
            return;
        }
        thread = new DLThread();
        thread.setDaemon(true);
        thread.start();
        IProcess process = new IProcess(){

            @Override
            public void updateProcess() {
                if (thread.isFinished()) {
                    thread = null;
                    Minecraft.func_71410_x().func_152344_a(() -> ContributorUtils.addCosmetic(player));
                } else if (thread.isFailed()) {
                    thread = null;
                }
            }

            @Override
            public boolean isDead() {
                return thread == null;
            }
        };
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ProcessHandlerClient.addProcess(process);
        } else {
            ProcessHandler.addProcess(process);
        }
    }

    private static boolean isOnlineMode(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return !UUID.nameUUIDFromBytes(("OfflinePlayer:" + player.func_70005_c_()).getBytes(Charsets.UTF_8)).equals(player.func_110124_au());
    }

    private static void addCosmetic(AbstractClientPlayer player) {
        if (ContributorUtils.doesPlayerHaveDankNull(player)) {
            ContributorUtils.addDankNull();
        }
        if (ContributorUtils.doesPlayerHaveWings(player)) {
            LayerContributorWings.Type type = ContributorUtils.getWingTypeForPlayer(player);
            ContributorUtils.addWings(type);
            ContributorUtils.registerContributor(player, type);
            LibGlobals.IS_CONTRIBUTOR = true;
        }
        if ((DateUtils.isXmas() || DateUtils.isXmasEve()) && !ContributorUtils.doesPlayerHaveWings(player)) {
            ContributorUtils.addWings(LayerContributorWings.Type.XMAS);
            ContributorUtils.registerContributor(player, LayerContributorWings.Type.XMAS);
            LibGlobals.IS_CONTRIBUTOR = true;
            return;
        }
    }

    public static void registerContributor(AbstractClientPlayer player, LayerContributorWings.Type type) {
        if (player != null && type != null && !REGISTRY.containsKey(player.func_110124_au())) {
            REGISTRY.put(player.func_110124_au(), type);
            ContributorUtils.registerSpecialContributor(player);
        }
    }

    public static void registerSpecialContributor(AbstractClientPlayer player) {
        if (player != null && ContributorUtils.isPlayerSpecial(player.func_110124_au()) && !SPECIAL_PLAYERS.contains(player.func_110124_au())) {
            SPECIAL_PLAYERS.add(player.func_110124_au());
        }
    }

    public static boolean isContributor(AbstractClientPlayer player) {
        return player != null && REGISTRY.containsKey(player.func_110124_au());
    }

    public static LayerContributorWings.Type getWingType(AbstractClientPlayer player) {
        if (player != null && REGISTRY.containsKey(player.func_110124_au())) {
            return REGISTRY.get(player.func_110124_au());
        }
        return null;
    }

    public static LayerContributorWings.Type getWingType(String uuid) {
        for (UUID playerUUID : REGISTRY.keySet()) {
            if (!uuid.contains(playerUUID.toString())) continue;
            return REGISTRY.get(playerUUID);
        }
        return null;
    }

    private static void removeVanillaSpecialLayers(List<LayerRenderer<AbstractClientPlayer>> r) {
        for (int i = 0; i < r.size(); ++i) {
            if (!(r.get(i) instanceof LayerCape)) continue;
            r.remove(i);
        }
    }

    public static void addWings(LayerContributorWings.Type type) {
        for (RenderLivingBase renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            layerWings = new LayerContributorWings();
            renderPlayer.func_177094_a((LayerRenderer)layerWings);
        }
    }

    public static void addDankNull() {
        for (RenderPlayer renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            List r = renderPlayer.field_177097_h;
            ContributorUtils.removeVanillaSpecialLayers(r);
            layerDankNull = new LayerContribDankNull();
            renderPlayer.func_177094_a((LayerRenderer)layerDankNull);
        }
    }

    public static boolean doesPlayerHaveWings(AbstractClientPlayer player) {
        if (PATRON_LIST != null) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                for (LayerContributorWings.Type type : LayerContributorWings.Type.values()) {
                    String uuid = player.func_110124_au().toString() + "" + type.getIdentifier();
                    if (!uuid.contains(PATRON_LIST.get(i)) && !ContributorUtils.isPlayerSpecial(uuid, PATRON_LIST.get(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesPlayerHaveDankNull(AbstractClientPlayer player) {
        return false;
    }

    public static boolean isPlayerSpecial(UUID playerUUID) {
        if (SPECIAL_PLAYERS.contains(playerUUID)) {
            return true;
        }
        for (int i = 0; i < PATRON_LIST.size(); ++i) {
            if (!PATRON_LIST.get(i).split("_")[1].contains("#")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerSuperSpecial(UUID playerUUID) {
        if (ContributorUtils.isPlayerSpecial(playerUUID)) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                if (!PATRON_LIST.get(i).split("_")[1].contains("!")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerSpecial(String uuid, String comparison) {
        return comparison.contains(uuid) && comparison.contains("#");
    }

    public static boolean isPlayerSpecial(String uuid) {
        if (!PATRON_LIST.isEmpty()) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                if (!PATRON_LIST.get(i).split("_")[1].contains("#")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerSuperSpecial(String uuid) {
        if (!PATRON_LIST.isEmpty() && ContributorUtils.isPlayerSpecial(uuid)) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                if (!PATRON_LIST.get(i).contains("!")) continue;
                return true;
            }
        }
        return false;
    }

    public static LayerContributorWings.Type getWingTypeForPlayer(AbstractClientPlayer player) {
        for (int i = 0; i < PATRON_LIST.size(); ++i) {
            for (LayerContributorWings.Type type : LayerContributorWings.Type.values()) {
                String uuid = player.func_110124_au().toString() + "" + type.getIdentifier();
                if (!uuid.equals(PATRON_LIST.get(i)) && !ContributorUtils.isPlayerSpecial(uuid, PATRON_LIST.get(i))) continue;
                return type;
            }
        }
        return null;
    }

    public static class DLThread
    extends Thread {
        private boolean finished = false;
        private boolean failed = false;

        public DLThread() {
            super("TheRealp455w0rd Contributors DL Thread");
        }

        @Override
        public void run() {
            super.run();
            try {
                List entries = new ArrayList();
                HttpURLConnection con = (HttpURLConnection)new URL("https://s3.us-east-2.amazonaws.com/p455w0rd/patrons.txt").openConnection();
                con.setConnectTimeout(1000);
                InputStream in2 = con.getInputStream();
                entries = IOUtils.readLines((InputStream)in2, (Charset)Charset.defaultCharset());
                if (!entries.isEmpty()) {
                    PATRON_LIST = entries;
                    LibGlobals.CONTRIBUTOR_FILE_DOWNLOADED = true;
                }
                in2.close();
                con.disconnect();
                this.finished = true;
                this.failed = PATRON_LIST.isEmpty();
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

