/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class BlockUtils {
    public static IBlockState getAdjacentBlock(World world, BlockPos pos, EnumFacing facing) {
        pos = pos.func_177972_a(facing);
        return world == null || !world.func_175667_e(pos) ? Blocks.field_150350_a.func_176223_P() : world.func_180495_p(pos);
    }

    public static IBlockState getAdjacentBlock(World world, BlockPos pos, int side) {
        return world == null ? Blocks.field_150350_a.func_176223_P() : BlockUtils.getAdjacentBlock(world, pos, EnumFacing.field_82609_l[side]);
    }

    public static List<IBlockState> getAdjacentBlocks(World world, BlockPos pos) {
        ArrayList blockList = Lists.newArrayList();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            blockList.add(BlockUtils.getAdjacentBlock(world, pos, facing));
        }
        return blockList;
    }

    public static List<IBlockState> getAdjacentHorizontalBlocks(World world, BlockPos pos) {
        ArrayList blockList = Lists.newArrayList();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            blockList.add(world == null ? Blocks.field_150350_a.func_176223_P() : BlockUtils.getAdjacentBlock(world, pos, facing));
        }
        return blockList;
    }

    public static IBlockState resolveBlockState(ResourceLocation name, Map<String, String> properties) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(name);
        if (block == null || block == Blocks.field_150350_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        IBlockState state = block.func_176223_P();
        if (properties != null) {
            Collection blockProperties = state.func_177227_a();
            block0: for (Map.Entry<String, String> entry : properties.entrySet()) {
                String serializedKey = entry.getKey();
                String serializedValue = entry.getValue();
                for (IProperty property : blockProperties) {
                    if (!Objects.equals(property.func_177701_a(), serializedKey)) continue;
                    Comparable originalValue = state.func_177229_b(property);
                    while (!Objects.equals(property.func_177702_a(state.func_177229_b(property)), serializedValue)) {
                        if (!Objects.equals((state = state.func_177231_a(property)).func_177229_b(property), originalValue)) continue;
                        LogManager.getLogger((String)"p455w0rdslib").warn("Cannot parse property value '{}' for property '{}' of block {}.", (Object)serializedValue, (Object)serializedKey, (Object)name);
                        return Blocks.field_150350_a.func_176223_P();
                    }
                    continue block0;
                }
                LogManager.getLogger((String)"p455w0rdslib").warn("Block {} has no property '{}'.", (Object)name, (Object)serializedKey);
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        return state;
    }
}

