/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.textures;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.TableBuilder;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.RegisterProfiler;
import net.darkhax.caliper.profiling.profilers.textures.LargeTextureInfo;
import net.darkhax.caliper.profiling.profilers.textures.TextureMapInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@RegisterProfiler(name="Texture Analysis", description="Profiles the texture data loaded by the game.")
public class ProfileTextureMap
extends Profiler {
    private final File imageDir = new File(Caliper.LOG_DIR, "images");
    private final TableBuilder<LargeTextureInfo> largeTextures = LargeTextureInfo.createDataTable();

    @Override
    public void onPreInit() {
        if (!this.imageDir.exists()) {
            this.imageDir.mkdirs();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientLoadComplete() {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        File file = new File(Caliper.LOG_DIR, "texture-maps.md");
        try (FileWriter writer = new FileWriter(file, false);){
            FileHelper.writeInfoBlock(writer, 1, "Texture Map Analysis", "This file contains an analysis on the texture maps in the game, and which mods are adding textures to them. The size value is meant to represent the amount of graphical memory used by the texture and not the file size on your hard drive. Size is based on the assumption that every pixel is four bytes.", true);
            for (Map.Entry entry : textureManager.field_110585_a.entrySet()) {
                ITextureObject textureObject = (ITextureObject)entry.getValue();
                if (!(textureObject instanceof TextureMap)) continue;
                this.logTextureMap(writer, (TextureMap)textureObject, (ResourceLocation)entry.getKey());
            }
            if (!this.largeTextures.getEntries().isEmpty()) {
                Collections.sort(this.largeTextures.getEntries(), Collections.reverseOrder());
                FileHelper.writeInfoBlock(writer, 2, "Large Texture Files", "The following table of textures are ones that are considered very large. While some of these may be justified, it's possible that these are frivolous.");
                writer.append(this.largeTextures.createString());
            }
        }
        catch (IOException e) {
            Caliper.LOG.catching((Throwable)e);
        }
    }

    private void logTextureMap(FileWriter writer, TextureMap map, ResourceLocation name) throws IOException {
        TableBuilder<TextureMapInfo> table = TextureMapInfo.createDataTable();
        HashMap<String, TextureMapInfo> modTextureMapInfo = new HashMap<String, TextureMapInfo>();
        for (TextureAtlasSprite sprite : map.field_94252_e.values()) {
            String owner = sprite.func_94215_i().split(":")[0];
            long pixelCount = sprite.func_94216_b() * sprite.func_94211_a();
            TextureMapInfo info = modTextureMapInfo.computeIfAbsent(owner, TextureMapInfo::new);
            if (pixelCount > 65536L) {
                this.largeTextures.addEntry((Object)new LargeTextureInfo(sprite.func_94215_i(), sprite.func_94211_a(), sprite.func_94216_b()));
            }
            info.addPixels(pixelCount);
            info.addTextureCount(1L);
        }
        for (TextureMapInfo info : modTextureMapInfo.values()) {
            table.addEntry((Object)info);
        }
        Collections.sort(table.getEntries(), Collections.reverseOrder());
        writer.write(FileHelper.NEW_LINE);
        writer.write("## Texture: " + name.toString());
        writer.write(FileHelper.NEW_LINE);
        writer.write(table.createString());
        RenderUtils.saveTextureToFile((int)map.func_110552_b(), (File)new File(this.imageDir, name.toString().replaceAll(":", "_").replaceAll("/", "_") + ".png"));
    }
}

