/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.errors.reporters;

import java.util.StringJoiner;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.profilers.errors.ErrorReporter;
import net.darkhax.caliper.profiling.profilers.errors.Level;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ReportMissingEnchantmentDescriptions
extends ErrorReporter {
    private final StringJoiner joiner = new StringJoiner(FileHelper.NEW_LINE);
    private int errorCount = 0;

    @Override
    public String getErrors() {
        return this.joiner.toString();
    }

    @Override
    public String getDescription() {
        return "Many mods have systems for showing descriptions for enchantments. Adding translations for these can improve mod compatibility.";
    }

    @Override
    public String getName() {
        return "Enchantment Descriptions";
    }

    @Override
    public Level getErrorLevel() {
        return Level.WARNING;
    }

    @Override
    public boolean foundErrors() {
        return this.errorCount > 0;
    }

    @Override
    public void collectErrors() {
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            String translationKey;
            String description;
            if ("minecraft".equals(ench.getRegistryName().func_110624_b()) || !(description = I18n.func_135052_a((String)(translationKey = ReportMissingEnchantmentDescriptions.getTranslationKey(ench)), (Object[])new Object[0])).startsWith("enchantment.")) continue;
            this.joiner.add(String.format("Enchant: %s Translation Key: %s", ench.getRegistryName().toString(), translationKey));
            ++this.errorCount;
        }
    }

    private static String getTranslationKey(Enchantment enchant) {
        if (enchant != null && enchant.getRegistryName() != null) {
            return String.format("enchantment.%s.%s.desc", enchant.getRegistryName().func_110624_b(), enchant.getRegistryName().func_110623_a());
        }
        return "NULL";
    }
}

