/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.errors.reporters;

import java.util.StringJoiner;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.profilers.errors.ErrorReporter;
import net.darkhax.caliper.profiling.profilers.errors.Level;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ReportAirRecipe
extends ErrorReporter {
    private final StringJoiner joiner = new StringJoiner(FileHelper.NEW_LINE);
    private int errorCount = 0;

    @Override
    public String getErrors() {
        return this.joiner.toString();
    }

    @Override
    public String getDescription() {
        return "If a recipe has air in it as an ingredient or output it can cause many issues such as crashes and uncraftable recipes.";
    }

    @Override
    public void collectErrors() {
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (recipe.func_192399_d() || !recipe.func_77571_b().func_190926_b() && !this.containsAir((NonNullList<Ingredient>)recipe.func_192400_c())) continue;
            this.joiner.add(String.format("Recipe: %s Class: %s", recipe.getRegistryName().toString(), recipe.getClass().toGenericString()));
            ++this.errorCount;
        }
    }

    private boolean containsAir(NonNullList<Ingredient> ingredients) {
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (!stack.func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Level getErrorLevel() {
        return Level.FATAL;
    }

    @Override
    public boolean foundErrors() {
        return this.errorCount > 0;
    }

    @Override
    public String getName() {
        return "Recipes with Air";
    }
}

