/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.authors;

import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.RegisterProfiler;
import net.darkhax.caliper.profiling.profilers.authors.AuthorInfo;
import net.minecraftforge.fml.common.Loader;

@RegisterProfiler(name="Authors", description="Profiles author info for mods in the instance.")
public class ProfileAuthors
extends Profiler {
    private final File file = new File(Caliper.LOG_DIR, "authors.md");

    @Override
    public void onLoadComplete() {
        ArrayListMultimap authors = ArrayListMultimap.create();
        for (Object mod : Loader.instance().getIndexedModList().values()) {
            if (mod.getMetadata() == null || mod.getMetadata().authorList == null) continue;
            for (String author : mod.getMetadata().authorList) {
                authors.put((Object)author.toLowerCase(), (Object)mod.getName());
            }
        }
        ArrayList<AuthorInfo> authorInfo = new ArrayList<AuthorInfo>();
        for (String author : authors.keySet()) {
            Collection mods = authors.get((Object)author);
            authorInfo.add(new AuthorInfo(author, mods.size(), mods));
        }
        Collections.sort(authorInfo, Collections.reverseOrder());
        try {
            FileWriter writer = new FileWriter(this.file, false);
            Object object = null;
            try {
                FileHelper.writeInfoBlock(writer, 0, "Author Count", "This is a list of all the authors of the mods in the instance sorted by how many they have.", true);
                for (AuthorInfo author : authorInfo) {
                    writer.write(author.getModCount() + " - " + author.getAuthor() + FileHelper.NEW_LINE);
                    for (String mod : author.getMods()) {
                        writer.write("     - " + mod + FileHelper.NEW_LINE);
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> sortedEntries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(sortedEntries, (e1, e2) -> ((Comparable)e2.getValue()).compareTo(e1.getValue()));
        return sortedEntries;
    }
}

