/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.repackage.blue.endless.jankson.impl;

import com.therandomlabs.randomportals.repackage.blue.endless.jankson.Comment;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.JsonArray;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.JsonElement;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.JsonNull;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.JsonObject;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.JsonPrimitive;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.annotation.SerializedName;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.api.DeserializationException;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.api.DeserializerFunction;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.api.Marshaller;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.impl.POJODeserializer;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.impl.serializer.DeserializerFunctionPool;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.magic.TypeMagic;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@Deprecated
public class MarshallerImpl
implements Marshaller {
    private static MarshallerImpl INSTANCE = new MarshallerImpl();
    private Map<Class<?>, Function<Object, ?>> primitiveMarshallers = new HashMap();
    Map<Class<?>, Function<JsonObject, ?>> typeAdapters = new HashMap();
    private Map<Class<?>, BiFunction<Object, Marshaller, JsonElement>> serializers = new HashMap();
    private Map<Class<?>, DeserializerFunctionPool<?>> deserializers = new HashMap();
    private Map<Class<?>, Supplier<?>> typeFactories = new HashMap();

    public static Marshaller getFallback() {
        return INSTANCE;
    }

    public <T> void register(Class<T> clazz, Function<Object, T> marshaller) {
        this.primitiveMarshallers.put(clazz, marshaller);
    }

    public <T> void registerTypeAdapter(Class<T> clazz, Function<JsonObject, T> adapter) {
        this.typeAdapters.put(clazz, adapter);
    }

    public <T> void registerSerializer(Class<T> clazz, Function<T, JsonElement> serializer) {
        this.serializers.put(clazz, (it, marshaller) -> (JsonElement)serializer.apply(it));
    }

    public <T> void registerSerializer(Class<T> clazz, BiFunction<T, Marshaller, JsonElement> serializer) {
        this.serializers.put(clazz, serializer);
    }

    public <T> void registerTypeFactory(Class<T> clazz, Supplier<T> supplier) {
        this.typeFactories.put(clazz, supplier);
    }

    public <A, B> void registerDeserializer(Class<A> sourceClass, Class<B> targetClass, DeserializerFunction<A, B> function) {
        DeserializerFunctionPool<Object> pool = this.deserializers.get(targetClass);
        if (pool == null) {
            pool = new DeserializerFunctionPool<B>(targetClass);
            this.deserializers.put(targetClass, pool);
        }
        pool.registerUnsafe(sourceClass, function);
    }

    public MarshallerImpl() {
        this.register(Void.class, it -> null);
        this.register(String.class, it -> it instanceof String ? (String)it : it.toString());
        this.register(Byte.class, it -> it instanceof Number ? Byte.valueOf(((Number)it).byteValue()) : null);
        this.register(Character.class, it -> Character.valueOf(it instanceof Number ? (char)((Number)it).shortValue() : it.toString().charAt(0)));
        this.register(Short.class, it -> it instanceof Number ? Short.valueOf(((Number)it).shortValue()) : null);
        this.register(Integer.class, it -> it instanceof Number ? Integer.valueOf(((Number)it).intValue()) : null);
        this.register(Long.class, it -> it instanceof Number ? Long.valueOf(((Number)it).longValue()) : null);
        this.register(Float.class, it -> it instanceof Number ? Float.valueOf(((Number)it).floatValue()) : null);
        this.register(Double.class, it -> it instanceof Number ? Double.valueOf(((Number)it).doubleValue()) : null);
        this.register(Boolean.class, it -> it instanceof Boolean ? (Boolean)it : null);
        this.register(Void.TYPE, it -> null);
        this.register(Byte.TYPE, it -> it instanceof Number ? Byte.valueOf(((Number)it).byteValue()) : null);
        this.register(Character.TYPE, it -> Character.valueOf(it instanceof Number ? (char)((Number)it).shortValue() : it.toString().charAt(0)));
        this.register(Short.TYPE, it -> it instanceof Number ? Short.valueOf(((Number)it).shortValue()) : null);
        this.register(Integer.TYPE, it -> it instanceof Number ? Integer.valueOf(((Number)it).intValue()) : null);
        this.register(Long.TYPE, it -> it instanceof Number ? Long.valueOf(((Number)it).longValue()) : null);
        this.register(Float.TYPE, it -> it instanceof Number ? Float.valueOf(((Number)it).floatValue()) : null);
        this.register(Double.TYPE, it -> it instanceof Number ? Double.valueOf(((Number)it).doubleValue()) : null);
        this.register(Boolean.TYPE, it -> it instanceof Boolean ? (Boolean)it : null);
        this.registerSerializer(Void.class, (T it) -> JsonNull.INSTANCE);
        this.registerSerializer(Character.class, (T it) -> new JsonPrimitive("" + it));
        this.registerSerializer(String.class, JsonPrimitive::new);
        this.registerSerializer(Byte.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Short.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Integer.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Long.class, JsonPrimitive::new);
        this.registerSerializer(Float.class, (T it) -> new JsonPrimitive(it.floatValue()));
        this.registerSerializer(Double.class, JsonPrimitive::new);
        this.registerSerializer(Boolean.class, JsonPrimitive::new);
        this.registerSerializer(Void.TYPE, (T it) -> JsonNull.INSTANCE);
        this.registerSerializer(Character.TYPE, (T it) -> new JsonPrimitive("" + it));
        this.registerSerializer(Byte.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Short.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Integer.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Long.TYPE, JsonPrimitive::new);
        this.registerSerializer(Float.TYPE, (T it) -> new JsonPrimitive(it.floatValue()));
        this.registerSerializer(Double.TYPE, JsonPrimitive::new);
        this.registerSerializer(Boolean.TYPE, JsonPrimitive::new);
    }

    @Nullable
    public <T> T marshall(Type type, JsonElement elem) {
        if (elem == null) {
            return null;
        }
        if (elem == JsonNull.INSTANCE) {
            return null;
        }
        if (type instanceof Class) {
            try {
                return this.marshall((Class<T>)((Class)type), elem);
            }
            catch (ClassCastException t) {
                return null;
            }
        }
        if (type instanceof ParameterizedType) {
            try {
                Class<?> clazz = TypeMagic.classForType(type);
                return (T)this.marshall(clazz, elem);
            }
            catch (ClassCastException t) {
                return null;
            }
        }
        return null;
    }

    public <T> T marshall(Class<T> clazz, JsonElement elem) {
        try {
            return this.marshall(clazz, elem, false);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public <T> T marshallCarefully(Class<T> clazz, JsonElement elem) throws DeserializationException {
        return this.marshall(clazz, elem, true);
    }

    @Nullable
    public <T> T marshall(Class<T> clazz, JsonElement elem, boolean failFast) throws DeserializationException {
        if (elem == null) {
            return null;
        }
        if (elem == JsonNull.INSTANCE) {
            return null;
        }
        if (clazz.isAssignableFrom(elem.getClass())) {
            return (T)elem;
        }
        DeserializerFunctionPool<Object> pool = this.deserializers.get(clazz);
        if (pool != null) {
            try {
                return (T)pool.apply(elem, this);
            }
            catch (DeserializerFunctionPool.FunctionMatchFailedException functionMatchFailedException) {
                // empty catch block
            }
        }
        pool = POJODeserializer.deserializersFor(clazz);
        try {
            Object poolResult = pool.apply(elem, this);
            return (T)poolResult;
        }
        catch (DeserializerFunctionPool.FunctionMatchFailedException functionMatchFailedException) {
            if (Enum.class.isAssignableFrom(clazz)) {
                if (!(elem instanceof JsonPrimitive)) {
                    return null;
                }
                String name = ((JsonPrimitive)elem).getValue().toString();
                T[] constants = clazz.getEnumConstants();
                if (constants == null) {
                    return null;
                }
                for (T t : constants) {
                    if (!((Enum)t).name().equals(name)) continue;
                    return t;
                }
            }
            if (clazz.equals(String.class)) {
                if (elem instanceof JsonObject) {
                    return (T)((JsonObject)elem).toJson(false, false);
                }
                if (elem instanceof JsonArray) {
                    return (T)((JsonArray)elem).toJson(false, false);
                }
                if (elem instanceof JsonPrimitive) {
                    ((JsonPrimitive)elem).getValue();
                    return (T)((JsonPrimitive)elem).asString();
                }
                if (elem instanceof JsonNull) {
                    return (T)"null";
                }
                if (failFast) {
                    throw new DeserializationException("Encountered unexpected JsonElement type while deserializing to string: " + elem.getClass().getCanonicalName());
                }
                return null;
            }
            if (elem instanceof JsonPrimitive) {
                Function<Object, ?> func = this.primitiveMarshallers.get(clazz);
                if (func != null) {
                    return (T)func.apply(((JsonPrimitive)elem).getValue());
                }
                if (failFast) {
                    throw new DeserializationException("Don't know how to unpack value '" + elem.toString() + "' into target type '" + clazz.getCanonicalName() + "'");
                }
                return null;
            }
            if (elem instanceof JsonObject) {
                Object result;
                if (clazz.isPrimitive()) {
                    throw new DeserializationException("Can't marshall json object into primitive type " + clazz.getCanonicalName());
                }
                if (JsonPrimitive.class.isAssignableFrom(clazz)) {
                    if (failFast) {
                        throw new DeserializationException("Can't marshall json object into a json primitive");
                    }
                    return null;
                }
                JsonObject obj = (JsonObject)elem;
                obj.setMarshaller(this);
                if (this.typeAdapters.containsKey(clazz)) {
                    return (T)this.typeAdapters.get(clazz).apply((JsonObject)elem);
                }
                if (this.typeFactories.containsKey(clazz)) {
                    result = this.typeFactories.get(clazz).get();
                    try {
                        POJODeserializer.unpackObject(result, obj, failFast);
                        return result;
                    }
                    catch (Throwable t) {
                        if (failFast) {
                            throw t;
                        }
                        return null;
                    }
                }
                try {
                    result = TypeMagic.createAndCast(clazz, failFast);
                    POJODeserializer.unpackObject(result, obj, failFast);
                    return result;
                }
                catch (Throwable t) {
                    if (failFast) {
                        throw t;
                    }
                    return null;
                }
            }
            if (elem instanceof JsonArray) {
                if (clazz.isPrimitive()) {
                    return null;
                }
                if (clazz.isArray()) {
                    Class<?> componentType = clazz.getComponentType();
                    JsonArray array = (JsonArray)elem;
                    Object result = Array.newInstance(componentType, array.size());
                    for (int i = 0; i < array.size(); ++i) {
                        Array.set(result, i, this.marshall(componentType, array.get(i)));
                    }
                    return (T)result;
                }
            }
            return null;
        }
    }

    @Override
    public JsonElement serialize(Object obj) {
        Comment comment;
        SerializedName nameAnnotation;
        String name;
        JsonObject result;
        JsonArray array;
        if (obj == null) {
            return JsonNull.INSTANCE;
        }
        BiFunction<Object, Marshaller, JsonElement> serializer = this.serializers.get(obj.getClass());
        if (serializer != null) {
            JsonElement result2 = serializer.apply(obj, this);
            if (result2 instanceof JsonObject) {
                ((JsonObject)result2).setMarshaller(this);
            }
            if (result2 instanceof JsonArray) {
                ((JsonArray)result2).setMarshaller(this);
            }
            return result2;
        }
        for (Map.Entry<Class<?>, BiFunction<Object, Marshaller, JsonElement>> entry : this.serializers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(obj.getClass())) continue;
            JsonElement jsonElement = entry.getValue().apply(obj, this);
            if (jsonElement instanceof JsonObject) {
                ((JsonObject)jsonElement).setMarshaller(this);
            }
            if (jsonElement instanceof JsonArray) {
                ((JsonArray)jsonElement).setMarshaller(this);
            }
            return jsonElement;
        }
        if (obj instanceof Enum) {
            return new JsonPrimitive(((Enum)obj).name());
        }
        if (obj.getClass().isArray()) {
            array = new JsonArray();
            array.setMarshaller(this);
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object object = Array.get(obj, i);
                JsonElement parsed = this.serialize(object);
                array.add(parsed);
            }
            return array;
        }
        if (obj instanceof Collection) {
            array = new JsonArray();
            array.setMarshaller(this);
            for (Object e : (Collection)obj) {
                JsonElement parsed = this.serialize(e);
                array.add(parsed);
            }
            return array;
        }
        if (obj instanceof Map) {
            result = new JsonObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                result.put(k, this.serialize(v));
            }
            return result;
        }
        result = new JsonObject();
        for (Field field : obj.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object child2 = field.get(obj);
                name = field.getName();
                nameAnnotation = field.getAnnotation(SerializedName.class);
                if (nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if ((comment = field.getAnnotation(Comment.class)) == null) {
                    result.put(name, this.serialize(child2));
                    continue;
                }
                result.put(name, this.serialize(child2), comment.value());
            }
            catch (IllegalAccessException | IllegalArgumentException child2) {
                // empty catch block
            }
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object child = field.get(obj);
                name = field.getName();
                nameAnnotation = field.getAnnotation(SerializedName.class);
                if (nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if ((comment = field.getAnnotation(Comment.class)) == null) {
                    result.put(name, this.serialize(child));
                    continue;
                }
                result.put(name, this.serialize(child), comment.value());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return result;
    }
}

