/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.client;

import com.therandomlabs.randomportals.block.BlockLateralNetherPortal;
import com.therandomlabs.randomportals.block.BlockNetherPortal;
import com.therandomlabs.randomportals.config.RPOConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="randomportals")
public final class RPOPortalRenderer {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static BlockPos pos;
    private static Block block;
    private static float minU;
    private static float minV;
    private static float maxU;
    private static float maxV;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (RPOConfig.NetherPortals.enabled && event.getType() == RenderGameOverlayEvent.ElementType.PORTAL) {
            float timeInPortal = RPOPortalRenderer.mc.field_71439_g.field_71080_cy + (RPOPortalRenderer.mc.field_71439_g.field_71086_bY - RPOPortalRenderer.mc.field_71439_g.field_71080_cy) * event.getPartialTicks();
            if (timeInPortal > 0.0f) {
                RPOPortalRenderer.render(timeInPortal, event.getResolution());
            }
            event.setCanceled(true);
        }
    }

    public static void render(float timeInPortal, ScaledResolution resolution) {
        if (timeInPortal < 1.0f) {
            timeInPortal *= timeInPortal * timeInPortal * 0.8f;
            timeInPortal += 0.2f;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, (double)height, -90.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, -90.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)width, 0.0, -90.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void resetSprite(BlockPos pos, Block block) {
        if (RPOPortalRenderer.pos == null || pos.func_177951_i((Vec3i)RPOPortalRenderer.pos) > 2.0 || RPOPortalRenderer.isPlayerCloser(pos) || pos.equals((Object)RPOPortalRenderer.pos) && block != RPOPortalRenderer.block) {
            Block block2;
            RPOPortalRenderer.pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            RPOPortalRenderer.block = block;
            IBlockState stateToRender = block instanceof BlockNetherPortal ? (block instanceof BlockLateralNetherPortal ? block.func_176223_P() : ((block2 = RPOPortalRenderer.mc.field_71441_e.func_180495_p(pos.func_177984_a()).func_177230_c()) instanceof BlockNetherPortal ? block2.func_176223_P() : block.func_176223_P())) : Blocks.field_150427_aO.func_176223_P();
            TextureAtlasSprite sprite = mc.func_175602_ab().func_175023_a().func_178122_a(stateToRender);
            minU = sprite.func_94209_e();
            minV = sprite.func_94206_g();
            maxU = sprite.func_94212_f();
            maxV = sprite.func_94210_h();
        }
    }

    private static boolean isPlayerCloser(BlockPos pos) {
        BlockPos playerPos = RPOPortalRenderer.mc.field_71439_g.func_180425_c();
        return pos.func_177951_i((Vec3i)playerPos) < RPOPortalRenderer.pos.func_177951_i((Vec3i)playerPos);
    }
}

