/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.therandomlabs.randomportals.RandomPortals;
import com.therandomlabs.randomportals.advancements.RPOCriteriaTriggers;
import com.therandomlabs.randomportals.api.config.ColorData;
import com.therandomlabs.randomportals.api.config.EntitySpawns;
import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.config.SpawnRate;
import com.therandomlabs.randomportals.api.event.NetherPortalEvent;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameDetector;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.netherportal.NetherPortal;
import com.therandomlabs.randomportals.api.netherportal.PortalBlockRegistry;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import com.therandomlabs.randomportals.block.BlockLateralNetherPortal;
import com.therandomlabs.randomportals.client.RPOPortalRenderer;
import com.therandomlabs.randomportals.client.particle.ParticleRPOPortal;
import com.therandomlabs.randomportals.config.RPOConfig;
import com.therandomlabs.randomportals.frame.NetherPortalFrames;
import com.therandomlabs.randomportals.handler.NetherPortalTeleportHandler;
import com.therandomlabs.randomportals.world.storage.RPOSavedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="randomportals")
public class BlockNetherPortal
extends BlockPortal {
    public static final PropertyBool USER_PLACED = PropertyBool.func_177716_a((String)"user_placed");
    public static final AxisAlignedBB AABB_X = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    public static final AxisAlignedBB AABB_Y = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);
    public static final AxisAlignedBB AABB_Z = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final EnumFacing[] xRelevantFacings = new EnumFacing[]{EnumFacing.UP, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.WEST};
    private static final EnumFacing[] yRelevantFacings = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    private static final EnumFacing[] zRelevantFacings = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.SOUTH};
    private static final List<BlockPos> removing = new ArrayList<BlockPos>();
    private static final Map<EnumDyeColor, BlockNetherPortal> colors = new EnumMap<EnumDyeColor, BlockNetherPortal>(EnumDyeColor.class);
    private final EnumDyeColor color;
    private final Class<?> clazz;

    public BlockNetherPortal(EnumDyeColor color) {
        this(color == EnumDyeColor.PURPLE ? "minecraft:portal" : color.func_176610_l() + "_vertical_nether_portal", color);
        String translationKey = color.func_176762_d();
        this.func_149663_c("netherPortalVertical" + Character.toUpperCase(translationKey.charAt(0)) + translationKey.substring(1));
        if (!colors.containsKey(color)) {
            colors.put(color, this);
        }
    }

    protected BlockNetherPortal(String registryName, EnumDyeColor color) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176550_a, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)USER_PLACED, (Comparable)Boolean.valueOf(true)));
        this.func_149675_a(true);
        this.func_149711_c(-1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.setRegistryName(registryName);
        PortalBlockRegistry.register((Block)this);
        this.color = color;
        this.clazz = ((Object)((Object)this)).getClass();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch (this.getEffectiveAxis(state)) {
            case X: {
                return AABB_X;
            }
            case Y: {
                return AABB_Y;
            }
        }
        return AABB_Z;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        EntityLiving living;
        if (!world.func_82736_K().func_82766_b("doMobSpawning")) {
            return;
        }
        NetherPortal portal = RPOSavedData.get(world).getNetherPortalByInner(pos);
        PortalType portalType = portal == null ? PortalTypes.getDefault(world) : portal.getType();
        EntitySpawns spawns = portalType.group.entitySpawns.get(world.field_73011_w.getDimension());
        if (spawns == null || spawns.entities.isEmpty() || random.nextInt(spawns.rate) >= world.func_175659_aa().func_151525_a()) {
            return;
        }
        int minY = RandomPortals.CUBIC_CHUNKS_INSTALLED ? pos.func_177956_o() - 256 : 0;
        boolean found = false;
        while (pos.func_177956_o() > minY) {
            if (!world.func_180495_p(pos = pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) continue;
            found = true;
            break;
        }
        if (!found || world.func_180495_p(pos.func_177984_a()).func_185915_l()) {
            return;
        }
        SpawnRate spawnRate = spawns.getRandom(random);
        NBTTagCompound compound = null;
        try {
            compound = JsonToNBT.func_180713_a((String)spawnRate.nbt);
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
        compound.func_74778_a("id", spawnRate.key);
        float x = (float)pos.func_177958_n() + 0.5f;
        float y = (float)pos.func_177956_o() + 1.1f;
        float z = (float)pos.func_177952_p() + 0.5f;
        Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)compound, (World)world, (double)x, (double)y, (double)z, (boolean)true);
        if (entity == null) {
            return;
        }
        EntityLiving entityLiving = living = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        if (living != null && ForgeEventFactory.doSpecialSpawn((EntityLiving)living, (World)world, (float)x, (float)y, (float)z, null)) {
            world.func_72900_e(entity);
            return;
        }
        entity.func_70012_b((double)x, (double)y, (double)z, MathHelper.func_76142_g((float)(random.nextFloat() * 360.0f)), 0.0f);
        if (living != null) {
            living.field_70759_as = entity.field_70177_z;
            living.field_70761_aq = entity.field_70177_z;
            living.func_180482_a(world.func_175649_E(new BlockPos((Entity)living)), null);
            living.func_70642_aH();
        }
        entity.field_71088_bW = entity.func_82147_ab();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (removing.contains(fromPos)) {
            return;
        }
        RPOSavedData savedData = RPOSavedData.get(world);
        NetherPortal portal = savedData.getNetherPortalByInner(pos);
        if (((Boolean)state.func_177229_b((IProperty)USER_PLACED)).booleanValue() && portal == null) {
            return;
        }
        EnumFacing.Axis axis = this.getEffectiveAxis(state);
        IBlockState fromState = world.func_180495_p(fromPos);
        if (fromState.func_177230_c() == this && !((Boolean)fromState.func_177229_b((IProperty)USER_PLACED)).booleanValue() && this.getEffectiveAxis(fromState) == axis) {
            return;
        }
        EnumFacing irrelevantFacing = BlockNetherPortal.getIrrelevantFacing(axis);
        if (pos.func_177972_a(irrelevantFacing).equals((Object)fromPos) || pos.func_177972_a(irrelevantFacing.func_176734_d()).equals((Object)fromPos)) {
            return;
        }
        Tuple tuple = portal == null ? BlockNetherPortal.findFrame(world, pos) : new Tuple((Object)true, (Object)portal);
        if (tuple != null) {
            Block innerBlock;
            IBlockState innerState;
            boolean shouldBreak;
            portal = (NetherPortal)tuple.func_76340_b();
            Frame frame = portal.getFrame();
            boolean bl = shouldBreak = (Boolean)tuple.func_76341_a() != false && !portal.getType().test(frame);
            if (!shouldBreak) {
                for (BlockPos innerPos : frame.getInnerBlockPositions()) {
                    innerState = world.func_180495_p(innerPos);
                    innerBlock = innerState.func_177230_c();
                    if (innerBlock.getClass() == this.clazz && ((BlockNetherPortal)innerBlock).getEffectiveAxis(innerState) == axis) continue;
                    shouldBreak = true;
                    break;
                }
            }
            if (!shouldBreak) {
                return;
            }
            for (BlockPos innerPos : frame.getInnerBlockPositions()) {
                innerState = world.func_180495_p(innerPos);
                innerBlock = innerState.func_177230_c();
                if (innerBlock.getClass() != this.clazz || ((BlockNetherPortal)innerBlock).getEffectiveAxis(innerState) != axis) continue;
                removing.add(innerPos);
            }
            savedData.removeNetherPortalByTopLeft(frame.getTopLeft());
        } else {
            removing.addAll((Collection<BlockPos>)BlockNetherPortal.getConnectedPortals(world, pos, this, axis, (Boolean)state.func_177229_b((IProperty)USER_PLACED)));
        }
        for (BlockPos removePos : removing) {
            world.func_175698_g(removePos);
        }
        removing.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean z;
        pos = pos.func_177972_a(side);
        EnumFacing.Axis axis = null;
        if (state.func_177230_c() == this) {
            axis = this.getEffectiveAxis(state);
            if (axis == null) {
                return false;
            }
            if (axis == EnumFacing.Axis.Z && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return false;
            }
            if (axis == EnumFacing.Axis.X && side != EnumFacing.SOUTH && side != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this && world.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this && world.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this && world.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this && world.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean x = west || east || axis == EnumFacing.Axis.X;
        boolean bl = z = north || south || axis == EnumFacing.Axis.Z;
        if (x) {
            return side == EnumFacing.WEST || side == EnumFacing.EAST;
        }
        return z && (side == EnumFacing.NORTH || side == EnumFacing.SOUTH);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        PortalType portalType;
        ItemStack stack;
        if (entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU()) {
            return;
        }
        AxisAlignedBB aabb = entity.func_174813_aQ();
        if (!aabb.func_72326_a(state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos))) {
            return;
        }
        EnumDyeColor newColor = null;
        EntityItem dyeEntity = null;
        if (RPOConfig.NetherPortals.coloredPortals && RPOConfig.NetherPortals.dyeablePortals && entity instanceof EntityItem && (stack = (dyeEntity = (EntityItem)entity).func_92059_d()).func_77973_b() == Items.field_151100_aR) {
            newColor = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
        }
        if (this.color == newColor) {
            if (RPOConfig.NetherPortals.consumeDyesEvenIfSameColor) {
                world.func_72900_e((Entity)dyeEntity);
                return;
            }
            newColor = null;
        }
        if (world.field_72995_K) {
            if (newColor == null) {
                entity.func_181015_d(pos);
                if (entity == Minecraft.func_71410_x().field_71439_g) {
                    RPOPortalRenderer.resetSprite(pos, (Block)this);
                }
            }
            return;
        }
        NetherPortal portal = RPOSavedData.get(world).getNetherPortalByInner(pos);
        PortalType portalType2 = portalType = portal == null ? PortalTypes.getDefault(world) : portal.getType();
        if (newColor != null) {
            if (portalType.color.dyeBehavior == ColorData.DyeBehavior.DISABLE) {
                newColor = null;
            } else if (portalType.color.dyeBehavior == ColorData.DyeBehavior.ONLY_DEFINED_COLORS && !ArrayUtils.contains((Object[])portalType.color.colors, (Object)newColor)) {
                if (RPOConfig.NetherPortals.consumeDyesEvenIfInvalidColor) {
                    world.func_72900_e((Entity)dyeEntity);
                    return;
                }
                newColor = null;
            }
        }
        if (newColor == null) {
            NetherPortalTeleportHandler.setPortal(entity, portal, pos);
            return;
        }
        ImmutableList<BlockPos> relevantPositions = BlockNetherPortal.getRelevantPortalBlockPositions(world, pos, portal == null ? null : portal.getFrame());
        ArrayList<BlockPos> dyedPortalPositions = new ArrayList<BlockPos>(relevantPositions.size());
        for (BlockPos portalPos : relevantPositions) {
            if (world.func_180495_p(portalPos).func_177230_c() != this) continue;
            dyedPortalPositions.add(portalPos);
        }
        NetherPortalEvent.Dye.Pre event = new NetherPortalEvent.Dye.Pre(world, portal, dyedPortalPositions, this.color, newColor, dyeEntity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        IBlockState newState = this.getByColor(newColor).func_176223_P().func_177226_a((IProperty)field_176550_a, state.func_177229_b((IProperty)field_176550_a)).func_177226_a((IProperty)USER_PLACED, state.func_177229_b((IProperty)USER_PLACED));
        for (BlockPos portalPos : dyedPortalPositions) {
            world.func_180501_a(portalPos, newState, 2);
        }
        world.func_72900_e(entity);
        MinecraftForge.EVENT_BUS.post((Event)new NetherPortalEvent.Dye.Post(world, portal, dyedPortalPositions, this.color, newColor, false));
        String thrower = dyeEntity.func_145800_j();
        if (RPOConfig.Misc.advancements && portalType.group.toString().equals("vanilla_nether_portal") && thrower != null) {
            EntityPlayerMP player = world.func_73046_m().func_184103_al().func_152612_a(thrower);
            RPOCriteriaTriggers.DYED_NETHER_PORTAL.trigger(player, newColor, false);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        boolean userPlaced;
        if (meta > 2) {
            userPlaced = true;
            meta %= 3;
        } else {
            userPlaced = false;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176550_a, (Comparable)(meta == 1 ? EnumFacing.Axis.X : EnumFacing.Axis.Z)).func_177226_a((IProperty)USER_PLACED, (Comparable)Boolean.valueOf(userPlaced));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (random.nextInt(100) == 0) {
            world.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double zSpeed;
            double xSpeed;
            double particleZ;
            double particleX;
            double particleY = (double)y + random.nextDouble();
            double ySpeed = (random.nextDouble() - 0.5) * 0.5;
            int offset = random.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c().getClass() != this.clazz && world.func_180495_p(pos.func_177974_f()).func_177230_c().getClass() != this.clazz) {
                particleX = (double)x + 0.5 + 0.25 * (double)offset;
                particleZ = (double)z + random.nextDouble();
                xSpeed = random.nextDouble() * 2.0 * (double)offset;
                zSpeed = (random.nextDouble() - 0.5) * 0.5;
            } else {
                particleX = (double)x + random.nextDouble();
                particleZ = (double)z + 0.5 + 0.25 * (double)offset;
                xSpeed = (random.nextDouble() - 0.5) * 0.5;
                zSpeed = random.nextDouble() * 2.0 * (double)offset;
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleRPOPortal(world, particleX, particleY, particleZ, xSpeed, ySpeed, zSpeed, this.color));
        }
    }

    public int func_176201_c(IBlockState state) {
        int toAdd = (Boolean)state.func_177229_b((IProperty)USER_PLACED) != false ? 3 : 0;
        return super.func_176201_c(state) + toAdd;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176550_a, USER_PLACED});
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)this.color);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (RPOConfig.NetherPortals.portalsContributeToBeaconColors && !world.field_72995_K) {
            BlockBeacon.func_176450_d((World)world, (BlockPos)pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (RPOConfig.NetherPortals.portalsContributeToBeaconColors && !world.field_72995_K) {
            BlockBeacon.func_176450_d((World)world, (BlockPos)pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        PortalType portalType;
        if (world.field_72995_K || !RPOConfig.NetherPortals.coloredPortals || !RPOConfig.NetherPortals.dyeableSinglePortalBlocks) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() != Items.field_151100_aR) {
            return false;
        }
        EnumDyeColor newColor = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
        if (this.color == newColor) {
            if (RPOConfig.NetherPortals.consumeDyesEvenIfInvalidColor && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return false;
        }
        Tuple<Boolean, NetherPortal> tuple = BlockNetherPortal.findFrame(world, pos);
        NetherPortal portal = tuple == null ? null : (NetherPortal)tuple.func_76340_b();
        PortalType portalType2 = portalType = portal == null ? PortalTypes.getDefault(world) : portal.getType();
        if (portalType.color.dyeBehavior == ColorData.DyeBehavior.DISABLE) {
            return false;
        }
        if (portalType.color.dyeBehavior == ColorData.DyeBehavior.ONLY_DEFINED_COLORS && !ArrayUtils.contains((Object[])portalType.color.colors, (Object)newColor)) {
            if (RPOConfig.NetherPortals.consumeDyesEvenIfInvalidColor && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return false;
        }
        ArrayList dyedPortalPositions = Lists.newArrayList((Object[])new BlockPos[]{pos});
        NetherPortalEvent.Dye.Pre event = new NetherPortalEvent.Dye.Pre(world, portal, dyedPortalPositions, this.color, newColor, null);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        IBlockState newState = this.getByColor(newColor).func_176223_P().func_177226_a((IProperty)field_176550_a, state.func_177229_b((IProperty)field_176550_a)).func_177226_a((IProperty)USER_PLACED, state.func_177229_b((IProperty)USER_PLACED));
        world.func_180501_a(pos, newState, 2);
        if (RPOConfig.NetherPortals.consumeDyesEvenIfInvalidColor && !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        MinecraftForge.EVENT_BUS.post((Event)new NetherPortalEvent.Dye.Post(world, portal, dyedPortalPositions, this.color, newColor, true));
        if (RPOConfig.Misc.advancements && portalType.group.toString().equals("vanilla_nether_portal")) {
            RPOCriteriaTriggers.DYED_NETHER_PORTAL.trigger((EntityPlayerMP)player, newColor, true);
        }
        return true;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing.Axis axis = placer.func_174811_aO().func_176740_k();
        return this.func_176223_P().func_177226_a((IProperty)field_176550_a, (Comparable)(axis == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        boolean actuallyRemoved = super.removedByPlayer(state, world, pos, player, willHarvest);
        if (actuallyRemoved && !world.field_72995_K) {
            RPOSavedData.get(world).removeNetherPortalByInner(pos);
        }
        return actuallyRemoved;
    }

    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return RPOConfig.NetherPortals.portalsContributeToBeaconColors ? this.color.func_193349_f() : null;
    }

    public EnumFacing.Axis getEffectiveAxis(IBlockState state) {
        return (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
    }

    public final EnumDyeColor getColor() {
        return this.color;
    }

    public BlockNetherPortal getByColor(EnumDyeColor color) {
        return BlockNetherPortal.get(color);
    }

    public static BlockNetherPortal get(EnumDyeColor color) {
        BlockNetherPortal block = colors.get(color);
        return block == null ? (BlockNetherPortal)Blocks.field_150427_aO : block;
    }

    public static ImmutableList<BlockPos> getRelevantPortalBlockPositions(World world, BlockPos portalPos) {
        return BlockNetherPortal.getRelevantPortalBlockPositions(world, portalPos, null);
    }

    public static ImmutableList<BlockPos> getRelevantPortalBlockPositions(World world, BlockPos portalPos, Frame frame) {
        IBlockState state = world.func_180495_p(portalPos);
        BlockNetherPortal block = (BlockNetherPortal)state.func_177230_c();
        EnumFacing.Axis axis = block.getEffectiveAxis(state);
        if (frame == null) {
            Tuple<Boolean, NetherPortal> tuple = BlockNetherPortal.findFrame(world, portalPos);
            if (tuple != null) {
                return ((NetherPortal)tuple.func_76340_b()).getFrame().getInnerBlockPositions();
            }
        } else {
            return frame.getInnerBlockPositions();
        }
        return BlockNetherPortal.getConnectedPortals(world, portalPos, block, axis, (Boolean)state.func_177229_b((IProperty)USER_PLACED));
    }

    public static Tuple<Boolean, NetherPortal> findFrame(World world, BlockPos portalPos) {
        return BlockNetherPortal.findFrame(NetherPortalFrames.FRAMES, world, portalPos);
    }

    public static Tuple<Boolean, NetherPortal> findFrame(FrameDetector detector, World world, BlockPos portalPos) {
        RPOSavedData savedData = RPOSavedData.get(world);
        NetherPortal portal = savedData.getNetherPortalByInner(portalPos);
        if (portal != null) {
            return new Tuple((Object)true, (Object)portal);
        }
        IBlockState state = world.func_180495_p(portalPos);
        Block block = state.func_177230_c();
        if (!(state instanceof BlockNetherPortal)) {
            return null;
        }
        EnumFacing.Axis axis = ((BlockNetherPortal)block).getEffectiveAxis(state);
        EnumFacing frameDirection = axis == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.DOWN;
        FrameType type = FrameType.fromAxis(axis);
        FrameSize size = PortalTypes.getMaximumSize(type);
        int maxSize = size.getMaxSize(frameDirection == EnumFacing.DOWN);
        FrameStatePredicate portalMatcher = Matcher.ofType(type);
        BlockPos framePos = null;
        BlockPos checkPos = portalPos;
        for (int offset = 1; offset < maxSize - 1; ++offset) {
            checkPos = checkPos.func_177972_a(frameDirection);
            IBlockState checkState = world.func_180495_p(checkPos);
            Block checkBlock = checkState.func_177230_c();
            if (PortalTypes.getValidBlocks().test(world, checkPos, checkState) && (!(checkBlock instanceof BlockNetherPortal) || ((Boolean)checkState.func_177229_b((IProperty)USER_PLACED)).booleanValue())) {
                framePos = checkPos;
                break;
            }
            if (!portalMatcher.test(world, checkPos, checkState)) break;
        }
        if (framePos == null) {
            return null;
        }
        Frame frame = detector.detectWithCondition(world, framePos, type, potentialFrame -> potentialFrame.isInnerBlock(portalPos));
        if (frame == null) {
            return null;
        }
        portal = new NetherPortal(frame, null, PortalTypes.get(frame));
        savedData.addNetherPortal(portal, true);
        return new Tuple((Object)false, (Object)portal);
    }

    private static ImmutableList<BlockPos> getConnectedPortals(World world, BlockPos portalPos, BlockNetherPortal block, EnumFacing.Axis axis, boolean userPlaced) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        EnumFacing[] relevantFacings = BlockNetherPortal.getRelevantFacings(axis);
        positions.add(portalPos);
        int previousSize = 0;
        for (int i = 0; i < positions.size() || positions.size() != previousSize; ++i) {
            previousSize = positions.size();
            BlockPos removingPos = (BlockPos)positions.get(i);
            for (EnumFacing facing : relevantFacings) {
                IBlockState neighborState;
                BlockPos neighbor = removingPos.func_177972_a(facing);
                if (positions.contains(neighbor) || (neighborState = world.func_180495_p(neighbor)).func_177230_c() != block || block.getEffectiveAxis(neighborState) != axis || (Boolean)neighborState.func_177229_b((IProperty)USER_PLACED) != userPlaced) continue;
                positions.add(neighbor);
            }
        }
        return ImmutableList.copyOf(positions);
    }

    private static EnumFacing getIrrelevantFacing(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return EnumFacing.NORTH;
        }
        if (axis == EnumFacing.Axis.Y) {
            return EnumFacing.UP;
        }
        return EnumFacing.EAST;
    }

    private static EnumFacing[] getRelevantFacings(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return xRelevantFacings;
        }
        if (axis == EnumFacing.Axis.Y) {
            return yRelevantFacings;
        }
        return zRelevantFacings;
    }

    public static final class Matcher {
        public static final FrameStatePredicate LATERAL = FrameStatePredicate.ofBlock(block -> block.getClass() == BlockLateralNetherPortal.class);
        public static final FrameStatePredicate VERTICAL_X = FrameStatePredicate.ofBlock(block -> block.getClass() == BlockNetherPortal.class).where(field_176550_a, axis -> axis == EnumFacing.Axis.X);
        public static final FrameStatePredicate VERTICAL_Z = FrameStatePredicate.ofBlock(block -> block.getClass() == BlockNetherPortal.class).where(field_176550_a, axis -> axis == EnumFacing.Axis.Z);

        private Matcher() {
        }

        public static FrameStatePredicate ofType(FrameType type) {
            return type.get(LATERAL, VERTICAL_X, VERTICAL_Z);
        }
    }
}

