/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.frame.detector;

import com.therandomlabs.randomportals.api.frame.FrameDetector;
import com.therandomlabs.randomportals.api.frame.FrameSide;
import com.therandomlabs.randomportals.api.frame.FrameType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SidedFrameDetector
extends FrameDetector {
    private final FrameType defaultType;

    protected SidedFrameDetector(FrameType defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public FrameType getDefaultType() {
        return this.defaultType;
    }

    @Override
    protected final boolean test(World world, FrameType type, BlockPos pos, IBlockState state, FrameSide side, int position) {
        if (position == 1) {
            switch (side) {
                case TOP: {
                    return this.testTopLeftCorner(type, pos, state);
                }
                case RIGHT: {
                    return this.testTopRightCorner(type, pos, state);
                }
                case BOTTOM: {
                    return this.testBottomRightCorner(type, pos, state);
                }
            }
            return this.testBottomLeftCorner(type, pos, state);
        }
        switch (side) {
            case TOP: {
                return this.testTop(type, pos, state, position);
            }
            case RIGHT: {
                return this.testRight(type, pos, state, position);
            }
            case BOTTOM: {
                return this.testBottom(type, pos, state, position);
            }
        }
        return this.testLeft(type, pos, state, position);
    }

    protected boolean testTopRightCorner(FrameType type, BlockPos pos, IBlockState state) {
        return true;
    }

    protected boolean testTopLeftCorner(FrameType type, BlockPos pos, IBlockState state) {
        return true;
    }

    protected boolean testBottomRightCorner(FrameType type, BlockPos pos, IBlockState state) {
        return true;
    }

    protected boolean testBottomLeftCorner(FrameType type, BlockPos pos, IBlockState state) {
        return true;
    }

    protected abstract boolean testTop(FrameType var1, BlockPos var2, IBlockState var3, int var4);

    protected abstract boolean testRight(FrameType var1, BlockPos var2, IBlockState var3, int var4);

    protected abstract boolean testBottom(FrameType var1, BlockPos var2, IBlockState var3, int var4);

    protected abstract boolean testLeft(FrameType var1, BlockPos var2, IBlockState var3, int var4);
}

