/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randomportals.api.config.FrameSizes;
import com.therandomlabs.randomportals.api.frame.FrameType;
import java.util.Locale;
import java.util.function.Function;

public final class FrameSize {
    public int minWidth;
    public int maxWidth;
    public int minHeight;
    public int maxHeight;

    public FrameSize() {
        if (RandomPatches.IS_DEOBFUSCATED) {
            this.minWidth = 3;
            this.maxWidth = Integer.MAX_VALUE;
            this.minHeight = 3;
            this.maxHeight = Integer.MAX_VALUE;
        } else {
            this.minWidth = 3;
            this.maxWidth = 30;
            this.minHeight = 3;
            this.maxHeight = 30;
        }
    }

    public FrameSize(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public void ensureCorrect() {
        if (this.minWidth < 3) {
            this.minWidth = 3;
        }
        if (this.minHeight < 3) {
            this.minHeight = 3;
        }
        if (this.maxWidth < this.minWidth) {
            this.maxWidth = this.minWidth;
        }
        if (this.maxHeight < this.minHeight) {
            this.maxHeight = this.minHeight;
        }
    }

    public boolean test(int width, int height) {
        return width >= this.minWidth && width <= this.maxWidth && height >= this.minHeight && height <= this.maxHeight;
    }

    public int getMaxSize(boolean vertical) {
        return vertical ? this.maxHeight : Math.max(this.maxWidth, this.maxHeight);
    }

    public static Function<FrameType, FrameSize> fromJSONs(String species) {
        return type -> FrameSizes.get(species, type.toString().toLowerCase(Locale.ENGLISH));
    }
}

