/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.config.FrameSizeData;
import com.therandomlabs.randomportals.api.config.PosData;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import javax.annotation.Nullable;

public final class DestinationData {
    public int dimensionID = -1;
    public LocationDetectionBehavior locationDetectionBehavior = LocationDetectionBehavior.IGNORE_INITIAL;
    public PosData initialLocation = new PosData();
    public double coordinateMultiplier = 1.0;
    public boolean teleportToPortal = true;
    public boolean oneWay;
    public boolean ensureReturnToSameDimension;
    public boolean generatePortalIfNotFound = true;
    public PortalGenerationBehavior portalGenerationBehavior = PortalGenerationBehavior.CLONE;
    public FrameType generatedFrameType = FrameType.SAME;
    public FrameSizeData generatedFrameSize = new FrameSizeData();

    public DestinationData() {
        this.generatedFrameSize.lateral = new FrameSize(0, 0, 0, 0);
        this.generatedFrameSize.verticalX = new FrameSize(0, 0, 0, 0);
        this.generatedFrameSize.verticalZ = new FrameSize(0, 0, 0, 0);
    }

    public void ensureCorrect() {
        this.initialLocation.ensureCorrect();
        this.ensureCorrect(this.generatedFrameSize.lateral);
        this.ensureCorrect(this.generatedFrameSize.verticalX);
        this.ensureCorrect(this.generatedFrameSize.verticalZ);
    }

    public FrameSizeData getGeneratedFrameSize(@Nullable Frame frame) {
        int height;
        int width;
        if (frame == null) {
            width = 4;
            height = 5;
        } else {
            width = frame.getWidth();
            height = frame.getHeight();
        }
        FrameSizeData newGeneratedFrameSize = new FrameSizeData();
        newGeneratedFrameSize.lateral = this.getSize(this.generatedFrameSize.lateral, width, height);
        newGeneratedFrameSize.verticalX = this.getSize(this.generatedFrameSize.verticalX, width, height);
        newGeneratedFrameSize.verticalZ = this.getSize(this.generatedFrameSize.verticalZ, width, height);
        return newGeneratedFrameSize;
    }

    private void ensureCorrect(FrameSize size) {
        if (size.minWidth < 3 && size.minWidth != 0) {
            size.minWidth = 3;
        }
        if (size.maxWidth < 3) {
            size.maxWidth = 3;
        }
        if (size.minHeight < 3 && size.minHeight != 0) {
            size.minHeight = 3;
        }
        if (size.maxHeight < 3) {
            size.maxHeight = 3;
        }
        if (size.minWidth != 0 && size.maxWidth != 0 && size.maxWidth < size.minWidth) {
            size.maxWidth = size.minWidth;
        }
        if (size.minHeight != 0 && size.maxHeight != 0 && size.maxHeight < size.minHeight) {
            size.maxHeight = size.minHeight;
        }
    }

    private FrameSize getSize(FrameSize size, int width, int height) {
        FrameSize newSize = new FrameSize(size.minWidth, size.maxWidth, size.minHeight, size.maxHeight);
        if (size.minWidth == 0) {
            newSize.minWidth = width;
        }
        if (size.maxWidth == 0) {
            newSize.maxWidth = width;
        }
        if (size.minHeight == 0) {
            newSize.minHeight = height;
        }
        if (size.maxHeight == 0) {
            newSize.maxHeight = height;
        }
        newSize.ensureCorrect();
        return newSize;
    }

    public static enum LocationDetectionBehavior {
        IGNORE_INITIAL,
        USE_INITIAL,
        FORCE_INITIAL;

    }

    public static enum PortalGenerationBehavior {
        RANDOMIZE,
        CLONE,
        USE_RECEIVING_DIMENSION_PORTAL_TYPE;

    }
}

