/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.therandomlabs.randomportals.api.config.PortalActivator;
import com.therandomlabs.randomportals.util.RegistryNameAndMeta;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public final class ActivationData {
    public boolean canBeActivatedByFire = true;
    public List<PortalActivator> activators = new ArrayList<PortalActivator>();
    public ConsumeBehavior activatorConsumeBehavior = ConsumeBehavior.CONSUME;
    public boolean spawnFireBeforeActivating = true;
    public String[] activationSounds = new String[]{"minecraft:creativetab.flintandsteel.use"};
    private transient SoundEvent[] activationSoundEvents;

    public void ensureCorrect() {
        ArrayList<RegistryNameAndMeta> checkedItems = new ArrayList<RegistryNameAndMeta>();
        for (int i = 0; i < this.activators.size(); ++i) {
            PortalActivator activator = this.activators.get(i);
            RegistryNameAndMeta registryNameAndMeta = new RegistryNameAndMeta(activator.registryName, activator.meta);
            if (!activator.isValid() || checkedItems.contains(registryNameAndMeta)) {
                this.activators.remove(i--);
                continue;
            }
            checkedItems.add(registryNameAndMeta);
        }
        this.getActivationSoundEvents();
    }

    public SoundEvent[] getActivationSoundEvents() {
        if (this.activationSoundEvents != null) {
            return this.activationSoundEvents;
        }
        ArrayList<String> sounds = new ArrayList<String>(this.activationSounds.length);
        ArrayList<SoundEvent> soundEvents = new ArrayList<SoundEvent>(this.activationSounds.length);
        for (String activationSound : this.activationSounds) {
            String registryName;
            SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(activationSound));
            if (soundEvent == null || sounds.contains(registryName = soundEvent.getRegistryName().toString())) continue;
            sounds.add(registryName);
            soundEvents.add(soundEvent);
        }
        this.activationSounds = sounds.toArray(new String[0]);
        this.activationSoundEvents = soundEvents.toArray(new SoundEvent[0]);
        return this.activationSoundEvents;
    }

    public boolean test(ItemStack stack) {
        for (PortalActivator activator : this.activators) {
            if (!activator.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static enum ConsumeBehavior {
        CONSUME,
        DAMAGE,
        DO_NOTHING;

    }
}

