/*
 * Decompiled with CFR 0.152.
 */
package net.yseven.findyourway;

import net.minecraftforge.common.config.Configuration;
import net.yseven.findyourway.CommonProxy;

public class Config {
    private static final String CATEGORY_GENERAL = "ggeneral";
    public static boolean useEnderCompass = true;
    public static boolean useFortressCompass = true;
    public static boolean useMansionCompass = true;
    public static boolean useMonumentCompass = true;
    public static boolean useVillageCompass = true;

    public static void readConfig() {
        Configuration cfg = CommonProxy.config;
        try {
            cfg.load();
            Config.initGeneralConfig(cfg);
        }
        catch (Exception e) {
            System.out.println("Could not load config for Find Your Way");
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL, "General configuration");
        useEnderCompass = cfg.getBoolean("enderCompass", CATEGORY_GENERAL, useEnderCompass, "Leave as true to enable Ender Compass");
        useFortressCompass = cfg.getBoolean("fortressCompass", CATEGORY_GENERAL, useEnderCompass, "Leave as true to enable Fortress Compass");
        useMansionCompass = cfg.getBoolean("mansionCompass", CATEGORY_GENERAL, useEnderCompass, "Leave as true to enable Mansion Compass");
        useMonumentCompass = cfg.getBoolean("monumentCompass", CATEGORY_GENERAL, useEnderCompass, "Leave as true to enable Monument Compass");
        useVillageCompass = cfg.getBoolean("villageCompass", CATEGORY_GENERAL, useEnderCompass, "Leave as true to enable Village Compass");
    }
}

