/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.net;

import com.feed_the_beast.ftblib.FTBLibCommon;
import com.feed_the_beast.ftblib.lib.data.Action;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftblib.net.FTBLibNetHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MessageMyTeamAction
extends MessageToServer {
    private ResourceLocation action;
    private NBTTagCompound nbt;

    public MessageMyTeamAction() {
    }

    public MessageMyTeamAction(ResourceLocation id, NBTTagCompound data) {
        this.action = id;
        this.nbt = data;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.MY_TEAM;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeResourceLocation(this.action);
        data.writeNBT(this.nbt);
    }

    @Override
    public void readData(DataIn data) {
        this.action = data.readResourceLocation();
        this.nbt = data.readNBT();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        ForgePlayer p;
        Action a = FTBLibCommon.TEAM_GUI_ACTIONS.get(this.action);
        if (a != null && (p = Universe.get().getPlayer((ICommandSender)player)).hasTeam() && a.getType(p, this.nbt).isEnabled()) {
            a.onAction(p, this.nbt);
        }
    }
}

