/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import me.superckl.api.biometweaker.property.BiomePropertyManager;
import me.superckl.api.superscript.util.WarningHelper;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.integration.IntegrationManager;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BiomeHelper {
    private static Field biomeInfoMap;
    private static Field typeSet;
    private static Field biomes;
    private static Field isModded;
    private static boolean hasModded;
    private static int nextBiomeId;

    public static JsonObject fillJsonObject(Biome biome, int ... coords) {
        JsonObject object;
        String topBlock;
        BiomeHelper.checkFields();
        JsonObject obj = new JsonObject();
        obj.addProperty("ID", (Number)Biome.func_185362_a((Biome)biome));
        obj.addProperty("Name", biome.field_76791_y);
        obj.addProperty("Resource Location", ((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome)).toString());
        obj.addProperty("Class", biome.getClass().getName());
        obj.addProperty("Root Height", (Number)Float.valueOf(biome.func_185355_j()));
        obj.addProperty("Height Variation", (Number)Float.valueOf(biome.func_185360_m()));
        boolean topNull = biome.field_76752_A == null || biome.field_76752_A.func_177230_c() == null || biome.field_76752_A.func_177230_c().delegate == null;
        boolean bottomNull = biome.field_76752_A == null || biome.field_76752_A.func_177230_c() == null || biome.field_76752_A.func_177230_c().delegate == null;
        obj.addProperty("Top Block", topNull ? "ERROR" : biome.field_76752_A.toString());
        obj.addProperty("Filler Block", bottomNull ? "ERROR" : biome.field_76753_B.toString());
        if (!BiomeTweaker.getInstance().isTweakEnabled("oceanTopBlock")) {
            obj.addProperty("Ocean Top Block", "Disabled. Activate in BiomeTweakerCore.");
        } else {
            topBlock = BiomePropertyManager.OCEAN_TOP_BLOCK.get(biome).toString();
            obj.addProperty("Ocean Top Block", topBlock);
        }
        if (!BiomeTweaker.getInstance().isTweakEnabled("oceanFillerBlock")) {
            obj.addProperty("Ocean Filler Block", "Disabled. Activate in BiomeTweakerCore.");
        } else {
            topBlock = BiomePropertyManager.OCEAN_FILLER_BLOCK.get(biome).toString();
            obj.addProperty("Ocean Filler Block", topBlock);
        }
        if (!BiomeTweaker.getInstance().isTweakEnabled("actualFillerBlocks")) {
            obj.addProperty("Actual Filler Blocks", "Disabled. Activate in BiomeTweakerCore.");
        } else {
            IBlockState[] states;
            JsonArray array = new JsonArray();
            for (IBlockState state : states = BiomePropertyManager.ACTUAL_FILLER_BLOCKS.get(biome)) {
                array.add((JsonElement)new JsonPrimitive(state.toString()));
            }
            obj.add("Actual Filler Blocks", (JsonElement)array);
        }
        try {
            int i = -1;
            boolean hasCoords = coords != null && coords.length == 3;
            int x = 0;
            int y = 0;
            int z = 0;
            if (hasCoords) {
                x = coords[0];
                y = coords[1];
                z = coords[2];
            }
            if (!BiomeTweaker.getInstance().isTweakEnabled("grassColor")) {
                obj.addProperty("Grass Color", "Disabled. Activate in BiomeTweakerCore.");
            } else {
                obj.addProperty("Grass Color", "" + (hasCoords && FMLCommonHandler.instance().getSide().isClient() ? Integer.valueOf(biome.func_180627_b(new BlockPos(x, y, z))) : ((i = BiomePropertyManager.GRASS_COLOR.get(biome).intValue()) == -1 ? "Not set. Check in-game." : Integer.valueOf(i))));
            }
            if (!BiomeTweaker.getInstance().isTweakEnabled("foliageColor")) {
                obj.addProperty("Foliage Color", "Disabled. Activate in BiomeTweakerCore.");
            } else {
                obj.addProperty("Foliage Color", "" + (hasCoords && FMLCommonHandler.instance().getSide().isClient() ? Integer.valueOf(biome.func_180625_c(new BlockPos(x, y, z))) : ((i = BiomePropertyManager.FOLIAGE_COLOR.get(biome).intValue()) == -1 ? "Not set. Check in-game." : Integer.valueOf(i))));
            }
            obj.addProperty("Water Color", "" + biome.getWaterColorMultiplier());
        }
        catch (Exception e) {
            LogHelper.error("Failed to retrieve inserted fields!");
            e.printStackTrace();
        }
        obj.addProperty("Temperature", (Number)Float.valueOf(biome.func_185353_n()));
        obj.addProperty("Humidity", (Number)Float.valueOf(biome.func_76727_i()));
        obj.addProperty("Water Tint", (Number)biome.getWaterColorMultiplier());
        obj.addProperty("Enable Rain", Boolean.valueOf(biome.field_76765_S));
        obj.addProperty("Enable Snow", Boolean.valueOf(biome.func_76746_c()));
        JsonArray array = new JsonArray();
        if (BiomeDictionary.hasAnyType((Biome)biome)) {
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                array.add((JsonElement)new JsonPrimitive(type.toString()));
            }
        }
        obj.add("Dictionary Types", (JsonElement)array);
        JsonObject managerWeights = new JsonObject();
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            JsonArray subArray = new JsonArray();
            ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            for (BiomeManager.BiomeEntry entry : entries) {
                if (Biome.func_185362_a((Biome)entry.biome) != Biome.func_185362_a((Biome)biome)) continue;
                subArray.add((JsonElement)new JsonPrimitive((Number)entry.field_76292_a));
            }
            if (subArray.size() <= 0) continue;
            managerWeights.add(type.name() + " Weights", (JsonElement)subArray);
        }
        obj.add("BiomeManager Entries", (JsonElement)managerWeights);
        array = new JsonArray();
        for (Object entity : biome.field_76762_K) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Creatures", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : biome.field_76761_J) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Monsters", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : biome.field_76755_L) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Water Creatures", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : biome.field_82914_M) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Cave Creatures", (JsonElement)array);
        obj.add("Spawn Biome", (JsonElement)new JsonPrimitive(Boolean.valueOf(BiomeProvider.allowedBiomes.contains(biome))));
        obj.addProperty("Tweaked", Boolean.valueOf(BiomeTweaker.getInstance().getTweakedBiomes().contains(-1) || BiomeTweaker.getInstance().getTweakedBiomes().contains(Biome.func_185362_a((Biome)biome))));
        IntegrationManager.INSTANCE.addBiomeInfo(biome, obj);
        return obj;
    }

    private static void checkFields() {
        try {
            if (biomeInfoMap == null) {
                biomeInfoMap = BiomeDictionary.class.getDeclaredField("biomeInfoMap");
                biomeInfoMap.setAccessible(true);
            }
            if (biomes == null) {
                biomes = BiomeManager.class.getDeclaredField("biomes");
                biomes.setAccessible(true);
            }
        }
        catch (Exception e) {
            LogHelper.error("Failed to find inserted fields!");
            e.printStackTrace();
        }
    }

    public static void modifyBiomeDicType(Biome gen, BiomeDictionary.Type type, boolean remove) throws Exception {
        if (gen == null) {
            return;
        }
        if (!remove) {
            BiomeDictionary.addTypes((Biome)gen, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{type});
            return;
        }
        BiomeHelper.checkFields();
        Map map = (Map)WarningHelper.uncheckedCast(biomeInfoMap.get(null));
        Object biomeInfo = map.get(gen.getRegistryName());
        if (biomeInfo == null) {
            return;
        }
        if (typeSet == null) {
            typeSet = biomeInfo.getClass().getDeclaredField("types");
            typeSet.setAccessible(true);
        }
        Set set = (Set)WarningHelper.uncheckedCast(typeSet.get(biomeInfo));
        set.remove(type);
    }

    public static void removeAllBiomeDicType(Biome gen) throws Exception {
        BiomeHelper.checkFields();
        if (gen == null) {
            return;
        }
        Map map = (Map)WarningHelper.uncheckedCast(biomeInfoMap.get(null));
        Object biomeInfo = map.get(gen.getRegistryName());
        if (typeSet == null) {
            typeSet = biomeInfo.getClass().getDeclaredField("typeList");
            typeSet.setAccessible(true);
        }
        Set set = (Set)WarningHelper.uncheckedCast(typeSet.get(biomeInfo));
        set.clear();
    }

    public static void modTypeLists() throws Exception {
        BiomeHelper.checkFields();
        if (hasModded) {
            return;
        }
        Object array = biomes.get(null);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object list = Array.get(array, i);
            if (isModded == null) {
                isModded = list.getClass().getDeclaredField("isModded");
                isModded.setAccessible(true);
            }
            isModded.setBoolean(list, true);
        }
        hasModded = true;
    }

    public static int getNextFreeBiomeId() {
        for (int i = nextBiomeId; i < 256; ++i) {
            if (Biome.func_150568_d((int)i) != null) {
                if (i != 255) continue;
                throw new IllegalArgumentException("There are no more biome ids avaliable!");
            }
            nextBiomeId = i + 1;
            return i;
        }
        return -1;
    }

    static {
        nextBiomeId = 40;
    }
}

