/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.integration.bop;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerationManager;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.biome.vanilla.ExtendedBiomeWrapper;
import biomesoplenty.common.init.ModBiomes;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.biometweaker.script.wrapper.BTParameterTypes;
import me.superckl.api.superscript.script.ParameterTypes;
import me.superckl.api.superscript.script.ParameterWrapper;
import me.superckl.api.superscript.script.command.ScriptCommandListing;
import me.superckl.api.superscript.script.command.ScriptCommandRegistry;
import me.superckl.api.superscript.util.WarningHelper;
import me.superckl.biometweaker.integration.IntegrationModule;
import me.superckl.biometweaker.integration.bop.BOPBiomeProperties;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandAddBOPWorldType;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandAddIslandBiomeBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandAddSubBiomeBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandAddToGenerationBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveBOPWorldType;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveGeneratorBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveIslandBiomeBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveSubBiomeBOP;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.world.biome.Biome;

public class BOPIntegrationModule
extends IntegrationModule {
    @Override
    public void preInit() {
        try {
            LogHelper.info("Registering BOP script commands...");
            ScriptCommandListing listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandRemoveBOPWorldType.class.getDeclaredConstructor(String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeExcludedBOPWorldType", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("removeExcludedBOPWorldType", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandAddBOPWorldType.class.getDeclaredConstructor(String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("addExcludedBOPWorldType", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("addExcludedBOPWorldType", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), ParameterTypes.STRING.getSimpleWrapper(), ParameterTypes.NON_NEG_INTEGER.getSimpleWrapper()}), ScriptCommandAddToGenerationBOP.class.getDeclaredConstructor(BiomePackage.class, String.class, Integer.TYPE));
            ScriptCommandRegistry.INSTANCE.registerListing("addToGenerationBOP", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("addToGenerationBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandRemoveBOP.class.getDeclaredConstructor(BiomePackage.class));
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), ParameterTypes.STRING_ARRAY.getSpecialWrapper()}), ScriptCommandRemoveBOP.class.getDeclaredConstructor(BiomePackage.class, String[].class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeBOP", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("removeBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), ParameterTypes.STRING_ARRAY.getSpecialWrapper()}), ScriptCommandRemoveGeneratorBOP.class.getDeclaredConstructor(BiomePackage.class, String[].class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeGeneratorBOP", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("removeGeneratorBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandAddSubBiomeBOP.class.getDeclaredConstructor(BiomePackage.class, BiomePackage.class));
            ScriptCommandRegistry.INSTANCE.registerListing("addSubBiomeBOP", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("addSubBiomeBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandRemoveSubBiomeBOP.class.getDeclaredConstructor(BiomePackage.class, BiomePackage.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeSubBiomeBOP", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("removeSubBiomeBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), ParameterTypes.NON_NEG_INTEGER.getSimpleWrapper()}), ScriptCommandAddIslandBiomeBOP.class.getDeclaredConstructor(BiomePackage.class, Integer.TYPE));
            ScriptCommandRegistry.INSTANCE.registerListing("addToIslandBOP", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("addToIslandBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandRemoveIslandBiomeBOP.class.getDeclaredConstructor(BiomePackage.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeIslandBOP", listing, TweakerScriptObject.class);
            ScriptCommandRegistry.INSTANCE.registerListing("removeIslandBOP", listing, BiomesScriptObject.class);
        }
        catch (Exception e) {
            LogHelper.error("Failed to register BOP script commands! Some commands may not work properly!");
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public String getName() {
        return "Biomes O' Plenty Integration";
    }

    public static IExtendedBiome getExtendedBiome(Biome biome) {
        IExtendedBiome eBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
        if (eBiome == null) {
            eBiome = new ExtendedBiomeWrapper(biome);
            BOPBiomes.REG_INSTANCE.registerBiome(eBiome, eBiome.getBaseBiome().field_76791_y.toLowerCase());
        }
        return eBiome;
    }

    @Override
    public void addBiomeInfo(Biome biome, JsonObject obj) {
        IExtendedBiome eBiome = BOPIntegrationModule.getExtendedBiome(biome);
        biome = eBiome.getBaseBiome();
        IGenerationManager gManager = eBiome.getGenerationManager();
        JsonObject genNames = new JsonObject();
        for (GeneratorStage stage : GeneratorStage.values()) {
            ImmutableCollection gens = gManager.getGeneratorsForStage(stage);
            if (gens.isEmpty()) continue;
            JsonArray subArray = new JsonArray();
            Iterator it = gens.iterator();
            while (it.hasNext()) {
                JsonObject subSubObj = new JsonObject();
                IGenerator gen = (IGenerator)it.next();
                subSubObj.addProperty("ID", gen.getIdentifier());
                subSubObj.addProperty("Name", gen.getName());
                subArray.add((JsonElement)subSubObj);
            }
            genNames.add(stage.name() + " Generators", (JsonElement)subArray);
        }
        obj.add("BOP Generators", (JsonElement)genNames);
        obj.addProperty("BOP Owner", eBiome.getBiomeOwner().name());
        Gson gson = new Gson();
        obj.add("BOP Weight Map", gson.toJsonTree((Object)eBiome.getWeightMap()));
        try {
            JsonObject weights = new JsonObject();
            for (BOPClimates climate : BOPClimates.values()) {
                List entries = (List)WarningHelper.uncheckedCast(BOPBiomeProperties.LAND_BIOMES.get(climate));
                JsonArray subArray = new JsonArray();
                for (BOPClimates.WeightedBiomeEntry entry : entries) {
                    if (Biome.func_185362_a((Biome)entry.biome) != Biome.func_185362_a((Biome)biome)) continue;
                    subArray.add((JsonElement)new JsonPrimitive((Number)entry.weight));
                }
                if (subArray.size() <= 0) continue;
                weights.add(climate.name(), (JsonElement)subArray);
            }
            obj.add("BOP Climate Weights", (JsonElement)weights);
            if (ModBiomes.islandBiomesMap.containsKey(Biome.func_185362_a((Biome)biome))) {
                obj.add("BOP Island Weight", (JsonElement)new JsonPrimitive((Number)ModBiomes.islandBiomesMap.get(Biome.func_185362_a((Biome)biome))));
            } else {
                obj.add("BOP Island Weight", (JsonElement)new JsonPrimitive((Number)0));
            }
        }
        catch (Exception e) {
            LogHelper.error("Failed to retrieve all BOP biome info!");
            e.printStackTrace();
        }
    }
}

