/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;

public class Config {
    private final Configuration configFile;
    private String[] includes;
    private boolean disableOutput;
    private boolean outputSeperateFiles;
    private final File btConfigFolder;

    public Config(File config) {
        this.configFile = new Configuration(new File(config, "BiomeTweaker.cfg"));
        this.btConfigFolder = config;
        this.configFile.load();
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public void loadValues() {
        this.includes = this.configFile.getStringList("Script Files", "Scripting", new String[0], "A list of script files to include that are not in the scripts folder. An example script file is created along with this configuration file.");
        this.disableOutput = this.configFile.getBoolean("Disable Output Files", "Output Files", false, "If true, BiomeTweaker will not generate any output files.");
        this.outputSeperateFiles = this.configFile.getBoolean("Output Seperate Files", "Output Files", true, "If true, BiomeTweaker will generate separate files for each item when creating the status report.");
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("biometweaker")) {
            this.loadValues();
        }
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public boolean isDisableOutput() {
        return this.disableOutput;
    }

    public boolean isOutputSeperateFiles() {
        return this.outputSeperateFiles;
    }

    public File getBtConfigFolder() {
        return this.btConfigFolder;
    }
}

