/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen.feature;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import me.superckl.api.biometweaker.world.gen.feature.WorldGeneratorBuilder;
import me.superckl.biometweaker.common.world.gen.feature.WorldGenSplotch;
import me.superckl.biometweaker.common.world.gen.feature.WorldGenSplotchWrapper;
import net.minecraft.block.state.IBlockState;

public class WorldGenSplotchBuilder
extends WorldGeneratorBuilder<WorldGenSplotchWrapper<WorldGenSplotch>> {
    private int size = 4;
    private boolean requiresBase = true;
    private Predicate<IBlockState> basePredicate = Predicates.alwaysFalse();
    private Predicate<IBlockState> replacementPredicate = Predicates.alwaysFalse();

    @Override
    public WorldGenSplotchWrapper<WorldGenSplotch> build() {
        WorldGenSplotch gen = new WorldGenSplotch(this.mainBlock, this.size, this.requiresBase, this.basePredicate, this.replacementPredicate);
        return new WorldGenSplotchWrapper<WorldGenSplotch>(gen, this.count);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean requiresBase() {
        return this.requiresBase;
    }

    public void setRequiresBase(boolean requiresBase) {
        this.requiresBase = requiresBase;
    }

    public Predicate<IBlockState> getBasePredicate() {
        return this.basePredicate;
    }

    public Predicate<IBlockState> getReplacementPredicate() {
        return this.replacementPredicate;
    }

    public void addBasePredicate(Predicate<IBlockState> predicate) {
        this.basePredicate = this.basePredicate == null ? predicate : Predicates.or(predicate, this.basePredicate);
    }

    public void addReplacementPredicate(Predicate<IBlockState> predicate) {
        this.replacementPredicate = this.replacementPredicate == null ? predicate : Predicates.or(predicate, this.replacementPredicate);
    }
}

