/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.biome.property;

import me.superckl.api.biometweaker.property.Property;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.common.BiomeManager;

public class PropertySpawnBiome
extends Property<Boolean> {
    private static boolean loggedSpawn;

    public PropertySpawnBiome() {
        super(Boolean.class);
    }

    @Override
    public void set(Object obj, Boolean val) throws IllegalStateException, IllegalArgumentException {
        if (!(obj instanceof Biome)) {
            throw new IllegalArgumentException("Passed object is not an instance of Biome!");
        }
        if (val.booleanValue()) {
            BiomeManager.addSpawnBiome((Biome)((Biome)obj));
        } else {
            BiomeManager.removeSpawnBiome((Biome)((Biome)obj));
            if (!loggedSpawn && BiomeProvider.allowedBiomes.size() == 0) {
                LogHelper.warn("Upon removal of biome " + Biome.func_185362_a((Biome)((Biome)obj)) + " the allowed spawn list appears to be empty. If you aren't adding one later, this will cause a crash.");
                loggedSpawn = true;
            }
        }
    }

    @Override
    public Boolean get(Object obj) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (!(obj instanceof Biome)) {
            throw new IllegalArgumentException("Passed object is not an instance of Biome!");
        }
        return BiomeProvider.allowedBiomes.contains(obj);
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isSettable() {
        return true;
    }

    @Override
    public Class<?> getTargetClass() {
        return Biome.class;
    }
}

