/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.handler;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import me.superckl.api.superscript.util.BlockEquivalencePredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityEventHandler {
    private static int globalPackSize = -1;
    private static TIntObjectMap<TObjectIntMap<String>> packSizes = new TIntObjectHashMap();
    private static TIntObjectMap<List<IBlockState>> noBonemeals = new TIntObjectHashMap();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGetMaxPackSize(LivingPackSizeEvent e) {
        int size;
        TObjectIntMap sizes;
        if (globalPackSize > -1) {
            e.setResult(Event.Result.ALLOW);
            e.setMaxPackSize(globalPackSize);
            return;
        }
        if (packSizes.isEmpty()) {
            return;
        }
        Biome biome = e.getEntityLiving().field_70170_p.func_180494_b(e.getEntityLiving().func_180425_c());
        String clazz = e.getEntityLiving().getClass().getName();
        if (packSizes.containsKey(Biome.func_185362_a((Biome)biome)) && (sizes = (TObjectIntMap)packSizes.get(Biome.func_185362_a((Biome)biome))).containsKey((Object)clazz) && (size = sizes.get((Object)clazz)) > -1) {
            e.setResult(Event.Result.ALLOW);
            e.setMaxPackSize(size);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBonemealUse(BonemealEvent e) {
        if (noBonemeals.isEmpty()) {
            return;
        }
        Biome biome = e.getWorld().func_180494_b(e.getPos());
        if (noBonemeals.containsKey(Biome.func_185362_a((Biome)biome))) {
            List list = (List)noBonemeals.get(Biome.func_185362_a((Biome)biome));
            if (list == null) {
                e.setCanceled(true);
                return;
            }
            for (IBlockState block : list) {
                if (!new BlockEquivalencePredicate(block).apply(e.getBlock())) continue;
                e.setCanceled(true);
                break;
            }
        }
    }

    public static int getGlobalPackSize() {
        return globalPackSize;
    }

    public static void setGlobalPackSize(int globalPackSize) {
        EntityEventHandler.globalPackSize = globalPackSize;
    }

    public static TIntObjectMap<TObjectIntMap<String>> getPackSizes() {
        return packSizes;
    }

    public static TIntObjectMap<List<IBlockState>> getNoBonemeals() {
        return noBonemeals;
    }
}

