/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.client.gui;

import com.google.common.base.Predicates;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.client.gui.GuiGeneratingBiomeLayoutImage;
import me.superckl.biometweaker.common.world.biome.BiomePainter;
import me.superckl.biometweaker.util.PredicateHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.common.StartupQuery;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class GuiBiomeLayoutImage
extends GuiScreen {
    private final GuiScreen parentScreen;
    private GuiTextField worldNameField;
    private GuiTextField worldSeedField;
    private GuiTextField radiusField;
    private GuiTextField xField;
    private GuiTextField yField;
    private GuiButton btnMapType;
    private GuiButton btnBypassProvider;
    private int selectedIndex;
    private String worldSeed;
    private String worldName;
    private int radius;
    private int xCoord;
    private int yCoord;
    private String saveDirName;

    public GuiBiomeLayoutImage(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        this.worldSeed = "";
        this.worldName = I18n.func_135052_a((String)"selectWorld.newWorld", (Object[])new Object[0]);
    }

    public void func_73876_c() {
        this.worldNameField.func_146178_a();
        this.worldSeedField.func_146178_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, "Generate Image"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.btnBypassProvider = this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 - 155, 151, 150, 20, "Bypass Biome Provider: NO"));
        this.btnBypassProvider.field_146124_l = false;
        this.btnMapType = this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 + 5, 151, 150, 20, I18n.func_135052_a((String)"selectWorld.mapType", (Object[])new Object[0])));
        this.worldNameField = new GuiTextField(4, this.field_146289_q, this.field_146294_l / 2 - 100, 60, 200, 20);
        this.worldNameField.func_146195_b(true);
        this.worldNameField.func_146180_a(this.worldName);
        this.worldSeedField = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 2 - 100, 111, 200, 20);
        this.worldSeedField.func_146180_a(this.worldSeed);
        int y = 173 + this.field_146289_q.field_78288_b + (this.field_146295_m - 28 - (173 + this.field_146289_q.field_78288_b)) / 2 - 10;
        int width = (150 - this.field_146289_q.func_78256_a("X:") - this.field_146289_q.func_78256_a("Y:") - 30) / 2;
        this.radiusField = new GuiTextField(6, this.field_146289_q, this.field_146294_l / 2 - 155 + this.field_146289_q.func_78256_a("Radius (chunks):") + 10, y, 150 - this.field_146289_q.func_78256_a("Radius (chunks):") - 10, 20);
        this.radiusField.func_175205_a(Predicates.or(PredicateHelper.EMPTY_STRING, PredicateHelper.NONNEG_INT));
        this.radiusField.func_146180_a(String.valueOf(this.radius));
        this.xField = new GuiTextField(7, this.field_146289_q, this.field_146294_l / 2 + 5 + this.field_146289_q.func_78256_a("X:") + 10, y, width, 20);
        this.xField.func_175205_a(Predicates.or(PredicateHelper.EMPTY_STRING, PredicateHelper.INT));
        this.xField.func_146180_a(String.valueOf(this.xCoord));
        this.yField = new GuiTextField(8, this.field_146289_q, this.field_146294_l / 2 + 5 + this.field_146289_q.func_78256_a("X:") + 10 + width + 10 + this.field_146289_q.func_78256_a("Y:") + 10, y, width, 20);
        this.yField.func_175205_a(Predicates.or(PredicateHelper.EMPTY_STRING, PredicateHelper.INT));
        this.yField.func_146180_a(String.valueOf(this.yCoord));
        this.calcSaveDirName();
        this.updateDisplayState();
    }

    private void updateDisplayState() {
        this.btnMapType.field_146126_j = I18n.func_135052_a((String)"selectWorld.mapType", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)WorldType.field_77139_a[this.selectedIndex].func_77128_b(), (Object[])new Object[0]);
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = !this.worldName.isEmpty() && this.radius > 0;
    }

    private void calcSaveDirName() {
        this.saveDirName = this.worldName.trim();
        for (char c0 : ChatAllowedCharacters.field_71567_b) {
            this.saveDirName = this.saveDirName.replace(c0, '_');
        }
        if (StringUtils.isEmpty((CharSequence)this.saveDirName)) {
            this.saveDirName = "World";
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (!button.field_146124_l) {
            return;
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else if (button.field_146127_k == 0) {
            long i = new Random().nextLong();
            String s = this.worldSeedField.func_146179_b();
            if (!StringUtils.isEmpty((CharSequence)s)) {
                try {
                    long j = Long.parseLong(s);
                    if (j != 0L) {
                        i = j;
                    }
                }
                catch (NumberFormatException var7) {
                    i = s.hashCode();
                }
            }
            WorldType.field_77139_a[this.selectedIndex].onGUICreateWorldPress();
            WorldSettings worldsettings = new WorldSettings(i, GameType.SURVIVAL, false, false, WorldType.field_77139_a[this.selectedIndex]);
            worldsettings.func_82750_a("");
            File imagesDir = new File(BiomeTweaker.getInstance().getConfig().getBtConfigFolder(), "output/images/");
            imagesDir.mkdirs();
            this.calcSaveDirName();
            File imageFile = new File(imagesDir, this.saveDirName + ".png");
            int newLine = 10;
            StringBuilder builder = new StringBuilder("You are about to generate a PNG image for the following biome layout:").append('\n').append('\n').append("World Name: ").append(this.worldName.trim()).append('\n').append("World Seed: ").append(i).append('\n').append("World Type: ").append(WorldType.field_77139_a[this.selectedIndex].func_77127_a()).append('\n').append("Size: ").append(this.radius * 2).append("x").append(this.radius * 2).append(" chunks").append('\n').append("Center: (").append(this.xCoord).append(", ").append(this.yCoord).append(')').append('\n').append('\n').append("The generated PNG file will have the following properties:").append('\n').append('\n').append("Location: ").append(this.field_146297_k.field_71412_D.getAbsoluteFile().toPath().relativize(imageFile.getAbsoluteFile().toPath())).append('\n').append("Dimensions: ").append(this.radius * 2).append('x').append(this.radius * 2).append(" pixels").append('\n').append('\n');
            builder.append("This may take a long time. You may cancel the process at any time.").append('\n').append("Continue?");
            boolean cont = StartupQuery.confirm((String)builder.toString());
            if (cont) {
                GuiGeneratingBiomeLayoutImage gui = new GuiGeneratingBiomeLayoutImage();
                this.field_146297_k.func_147108_a((GuiScreen)gui);
                new Thread(() -> new BiomePainter(this.worldName, worldsettings).paintImage(this.radius, new ChunkPos(this.xCoord, this.yCoord), imageFile, gui)).start();
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)this);
            }
        } else if (button.field_146127_k == 3) {
            ++this.selectedIndex;
            if (this.selectedIndex >= WorldType.field_77139_a.length) {
                this.selectedIndex = 0;
            }
            while (!this.canSelectCurWorldType()) {
                ++this.selectedIndex;
                if (this.selectedIndex < WorldType.field_77139_a.length) continue;
                this.selectedIndex = 0;
            }
            this.updateDisplayState();
        }
    }

    private boolean canSelectCurWorldType() {
        WorldType worldtype = WorldType.field_77139_a[this.selectedIndex];
        if (worldtype != null && worldtype.func_77126_d()) {
            return worldtype == WorldType.field_180272_g ? GuiScreen.func_146272_n() : true;
        }
        return false;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.worldNameField.func_146206_l()) {
            this.worldNameField.func_146201_a(typedChar, keyCode);
            this.worldName = this.worldNameField.func_146179_b();
        } else if (this.worldSeedField.func_146206_l()) {
            this.worldSeedField.func_146201_a(typedChar, keyCode);
            this.worldSeed = this.worldSeedField.func_146179_b();
        } else if (this.radiusField.func_146206_l()) {
            this.radiusField.func_146201_a(typedChar, keyCode);
            this.radius = this.radiusField.func_146179_b().isEmpty() ? 0 : Integer.parseInt(this.radiusField.func_146179_b());
        } else if (this.xField.func_146206_l()) {
            this.xField.func_146201_a(typedChar, keyCode);
            this.xCoord = this.xField.func_146179_b().isEmpty() ? 0 : Integer.parseUnsignedInt(this.xField.func_146179_b());
        } else if (this.yField.func_146206_l()) {
            this.yField.func_146201_a(typedChar, keyCode);
            int n = this.yCoord = this.yField.func_146179_b().isEmpty() ? 0 : Integer.parseUnsignedInt(this.yField.func_146179_b());
        }
        if (keyCode == 28 || keyCode == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = !this.worldNameField.func_146179_b().isEmpty() && this.radius > 0;
        this.calcSaveDirName();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.worldSeedField.func_146192_a(mouseX, mouseY, mouseButton);
        this.worldNameField.func_146192_a(mouseX, mouseY, mouseButton);
        this.radiusField.func_146192_a(mouseX, mouseY, mouseButton);
        this.xField.func_146192_a(mouseX, mouseY, mouseButton);
        this.yField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Biome Layout Image Setup", this.field_146294_l / 2, 20, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 98, -6250336);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.seedInfo", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 136, -6250336);
        this.worldSeedField.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterName", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 47, -6250336);
        this.func_73731_b(this.field_146289_q, "Image will be saved as " + this.saveDirName + "-layout.png", this.field_146294_l / 2 - 100, 85, -6250336);
        this.worldNameField.func_146194_f();
        this.radiusField.func_146194_f();
        this.xField.func_146194_f();
        this.yField.func_146194_f();
        int y = 173 + this.field_146289_q.field_78288_b + (this.field_146295_m - 28 - (173 + this.field_146289_q.field_78288_b)) / 2 - this.field_146289_q.field_78288_b / 2;
        int width = (150 - this.field_146289_q.func_78256_a("X:") - this.field_146289_q.func_78256_a("Y:") - 30) / 2;
        this.func_73731_b(this.field_146289_q, "Radius (chunks):", this.field_146294_l / 2 - 155, y, 0xE0E0E0);
        this.func_73731_b(this.field_146289_q, "X:", this.field_146294_l / 2 + 5, y, 0xE0E0E0);
        this.func_73731_b(this.field_146289_q, "Y:", this.field_146294_l / 2 + 5 + this.field_146289_q.func_78256_a("X:") + 10 + width + 10, y, 0xE0E0E0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

