/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.script.ParameterTypes;
import me.superckl.api.superscript.script.ParameterWrapper;
import me.superckl.api.superscript.script.ScriptContext;
import me.superckl.api.superscript.script.ScriptHandler;
import me.superckl.api.superscript.script.ScriptLine;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.api.superscript.script.command.ScriptCommandListing;
import me.superckl.api.superscript.script.object.ScriptObject;
import me.superckl.api.superscript.util.CollectionHelper;
import me.superckl.api.superscript.util.ConstructorListing;
import org.apache.commons.lang3.tuple.Pair;

public class ScriptParser {
    private static final Map<String, ConstructorListing<ScriptObject>> validObjects = new HashMap<String, ConstructorListing<ScriptObject>>();

    public static void registerValidObjectInst(String name, ConstructorListing<ScriptObject> listing) {
        validObjects.put(name, listing);
    }

    public static void parseScriptFile(File file) {
        try {
            List<ScriptLine> scriptLines = ScriptParser.parseScriptLines(file);
            new ScriptHandler(scriptLines).parse();
        }
        catch (Exception e) {
            APIInfo.log.error("Failed to parse a script file: " + file.getPath() + ". Reason: " + e.getMessage());
            APIInfo.log.debug("Full stacktrace of error provided below for bug reports.", (Throwable)e);
        }
    }

    public static List<ScriptLine> parseScriptLines(File file) throws IOException {
        ArrayList<ScriptLine> array = new ArrayList<ScriptLine>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int lineNum = 1;
            while ((line = r.readLine()) != null) {
                line.trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                array.add(new ScriptLine(line, new ScriptContext(file.getName(), lineNum++)));
            }
        }
        return array;
    }

    public static boolean isStringArg(String arg) {
        return arg.trim().startsWith("\"") && arg.endsWith("\"");
    }

    public static boolean isPositiveInteger(String arg) {
        return arg.matches("[0-9]+");
    }

    public static String getCommandCalled(String command) throws IllegalArgumentException {
        if (!command.endsWith(")") || !command.contains("(")) {
            throw new IllegalArgumentException("Improper argument array");
        }
        return command.substring(0, command.indexOf("("));
    }

    public static String[] parseArguments(String script) {
        if (!script.endsWith(")") || !script.contains("(")) {
            APIInfo.log.error("Tried to parse an invalid argument array!");
            return new String[0];
        }
        String args = script.substring(script.indexOf("(") + 1, script.length() - 1).trim();
        String[] split = args.isEmpty() ? new String[]{} : args.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
        return split;
    }

    public static Map<String, Object> parseAssignment(String script, ScriptContext context, ScriptHandler handler) throws Exception {
        String called;
        String[] split = script.split("=");
        if (split.length != 2) {
            APIInfo.log.error("Failed to parse object assignment: " + script + " @ " + context + ". Reason: Incorrect '=' placement.");
            return null;
        }
        String var = split[0].trim();
        String assign = split[1].trim();
        if (assign.startsWith("\"") && assign.endsWith("\"")) {
            String shortcut = (String)ParameterTypes.STRING.tryParse(assign, handler);
            return CollectionHelper.linkedMapWithEntry(var, shortcut);
        }
        try {
            called = ScriptParser.getCommandCalled(assign);
        }
        catch (IllegalArgumentException e) {
            APIInfo.log.error("Failed to parse object assignment: " + script + " @ " + context + ". Reason: " + e.getMessage());
            return null;
        }
        if (validObjects.containsKey(called)) {
            ConstructorListing<ScriptObject> listing = validObjects.get(called);
            String[] arguments = CollectionHelper.trimAll(ScriptParser.parseArguments(assign));
            for (Map.Entry<List<ParameterWrapper<?>>, Constructor<ScriptObject>> entry : listing.getConstructors().entrySet()) {
                ArrayList objs = new ArrayList();
                ArrayList params = new ArrayList(entry.getKey());
                Iterator it = params.iterator();
                while (it.hasNext()) {
                    ParameterWrapper wrap = (ParameterWrapper)it.next();
                    Pair<T[], String[]> parsed = wrap.parseArgs(handler, arguments);
                    CollectionHelper.addAllFromArray(objs, parsed.getKey());
                    arguments = (String[])parsed.getValue();
                    it.remove();
                }
                if (!params.isEmpty() || arguments.length != 0) continue;
                Object[] args = new Object[objs.size()];
                System.arraycopy(objs.toArray(), 0, args, 0, objs.size());
                ScriptObject obj = entry.getValue().getDeclaringClass().newInstance();
                obj.readArgs(args);
                return CollectionHelper.linkedMapWithEntry(var, obj);
            }
        }
        APIInfo.log.error("Failed to find meaning in object assignment " + script + " @ " + context + ". Reason: No matching objects or registrations found.");
        return null;
    }

    @Nullable
    public static Pair<Constructor<? extends ScriptCommand>, Object[]> findConstructor(ScriptCommandListing listing, String[] args, ScriptHandler handler) throws Exception {
        block0: for (Map.Entry entry : listing.getConstructors().entrySet()) {
            String[] arguments = Arrays.copyOf(args, args.length);
            ArrayList objs = new ArrayList();
            ArrayList params = new ArrayList(entry.getKey());
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParameterWrapper wrap = (ParameterWrapper)it.next();
                Pair<T[], String[]> parsed = wrap.parseArgs(handler, arguments);
                if (Array.getLength(parsed.getKey()) == 0 && !wrap.canReturnNothing()) continue block0;
                CollectionHelper.addAllFromArray(objs, parsed.getKey());
                arguments = (String[])parsed.getValue();
                it.remove();
            }
            if (!params.isEmpty() || arguments.length != 0) continue;
            return Pair.of(entry.getValue(), (Object)objs.toArray());
        }
        return null;
    }

    public static Map<String, ConstructorListing<ScriptObject>> getValidobjects() {
        return validObjects;
    }
}

