/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world.tools;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class SpawnTools {
    public static int spawnEntitiesInMachine(int id) {
        int count = 0;
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        EnumMachineSize size = WorldSavedDataMachines.getInstance().machineSizes.get(id);
        if (size == null) {
            return count;
        }
        BlockPos roomPos = WorldSavedDataMachines.getInstance().getMachineRoomPosition(id);
        if (roomPos == null) {
            return -1;
        }
        BlockPos start = roomPos.func_177982_a(1, 1, 1);
        BlockPos end = roomPos.func_177982_a(size.getDimension() - 1, size.getDimension() - 1, size.getDimension() - 1);
        List livingEntities = machineWorld.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(start, end));
        int maxEntities = size.getDimension() / 2;
        if (livingEntities.size() >= maxEntities) {
            return count;
        }
        boolean playerInside = livingEntities.stream().anyMatch(entity -> entity instanceof EntityPlayer);
        for (EnumCreatureType type : EnumCreatureType.values()) {
            EntityLiving entity2;
            boolean canSpawnAtPos;
            if (!type.func_75599_d() && playerInside || type.func_75599_d() && !ConfigurationHandler.MachineSettings.allowPeacefulSpawns || !type.func_75599_d() && !ConfigurationHandler.MachineSettings.allowHostileSpawns) continue;
            BlockPos randomPos = start.func_177982_a(machineWorld.field_73012_v.nextInt(size.getDimension() - 1), machineWorld.field_73012_v.nextInt(size.getDimension() - 1), machineWorld.field_73012_v.nextInt(size.getDimension() - 1));
            while (randomPos.func_177956_o() > 0 && machineWorld.func_175623_d(randomPos.func_177977_b())) {
                randomPos = randomPos.func_177977_b();
            }
            Biome.SpawnListEntry spawnEntry = machineWorld.func_175734_a(type, randomPos);
            if (spawnEntry == null || !(canSpawnAtPos = WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)spawnEntry.field_76300_b), (World)machineWorld, (BlockPos)randomPos))) continue;
            try {
                entity2 = spawnEntry.newInstance((World)machineWorld);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (entity2 == null) continue;
            float x = (float)randomPos.func_177958_n() + 0.5f;
            float y = (float)randomPos.func_177956_o() + 0.2f;
            float z = (float)randomPos.func_177952_p() + 0.5f;
            entity2.func_70012_b((double)x, (double)y, (double)z, machineWorld.field_73012_v.nextFloat() * 360.0f, 0.0f);
            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity2, (World)machineWorld, (float)x, (float)y, (float)z, (boolean)false);
            if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entity2.func_70601_bi() || !entity2.func_70058_J())) continue;
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entity2, (World)machineWorld, (float)x, (float)y, (float)z)) {
                entity2.func_180482_a(machineWorld.func_175649_E(new BlockPos((Entity)entity2)), null);
            }
            if (entity2.func_70058_J()) {
                ++count;
                machineWorld.func_72838_d((Entity)entity2);
                continue;
            }
            entity2.func_70106_y();
        }
        return count;
    }
}

