/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class ChunkLoadingMachines
implements ForgeChunkManager.LoadingCallback {
    public static boolean isMachineChunkLoaded(int id, BlockPos roomPos) {
        if (id == -1) {
            return false;
        }
        ImmutableSet chunkTickets = ChunkLoadingMachines.getPersistentChunksForMachineWorld().get((Object)new ChunkPos(roomPos));
        for (ForgeChunkManager.Ticket ticket : chunkTickets) {
            int[] nbtIds;
            NBTTagCompound data = ticket.getModData();
            if (ChunkLoadingMachines.isInvalid(ticket)) continue;
            for (int nbtId : nbtIds = data.func_74764_b("id") ? data.func_74759_k("id") : data.func_74759_k("coords")) {
                if (nbtId != id) continue;
                return true;
            }
        }
        return false;
    }

    public static void unforceChunk(int id, BlockPos roomPos) {
        if (id == -1 || roomPos == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(roomPos);
        ImmutableSet chunkTickets = ChunkLoadingMachines.getPersistentChunksForMachineWorld().get((Object)chunkPos);
        for (ForgeChunkManager.Ticket ticket : chunkTickets) {
            NBTTagCompound data = ticket.getModData();
            if (ChunkLoadingMachines.isInvalid(ticket)) continue;
            int[] nbtIds = data.func_74764_b("id") ? data.func_74759_k("id") : data.func_74759_k("coords");
            int usedChunks = data.func_74762_e("usedChunks");
            for (int i = 0; i < nbtIds.length; ++i) {
                if (nbtIds[i] != id) continue;
                CompactMachines3.logger.debug("ChunkLoading: Runtime: Unforcing chunk for machine: {}", (Object)id);
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
                if (usedChunks <= 1) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                } else {
                    nbtIds[i] = -1;
                    data.func_74768_a("usedChunks", usedChunks - 1);
                    data.func_74783_a("id", nbtIds);
                }
                return;
            }
        }
    }

    public static void forceChunk(int id, BlockPos roomPos) {
        if (id == -1 || roomPos == null) {
            return;
        }
        ForgeChunkManager.Ticket chunkTicket = null;
        for (ForgeChunkManager.Ticket ticket : ChunkLoadingMachines.getModTicketsForMachineWorld()) {
            NBTTagCompound data = ticket.getModData();
            int usedChunks = data.func_74762_e("usedChunks");
            if (usedChunks >= ticket.getMaxChunkListDepth()) continue;
            chunkTicket = ticket;
            break;
        }
        if (chunkTicket == null) {
            WorldServer machineWorld = DimensionTools.getServerMachineWorld();
            chunkTicket = ForgeChunkManager.requestTicket((Object)CompactMachines3.instance, (World)machineWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (chunkTicket == null) {
            return;
        }
        NBTTagCompound data = chunkTicket.getModData();
        int usedChunks = data.func_74762_e("usedChunks");
        int[] nbtIds = new int[chunkTicket.getMaxChunkListDepth()];
        Arrays.fill(nbtIds, -1);
        if (data.func_74764_b("id") || data.func_74764_b("coords")) {
            int[] tempIds = data.func_74764_b("id") ? data.func_74759_k("id") : data.func_74759_k("coords");
            System.arraycopy(tempIds, 0, nbtIds, 0, tempIds.length);
        }
        for (int i = 0; i < nbtIds.length; ++i) {
            if (nbtIds[i] != -1) continue;
            nbtIds[i] = id;
            break;
        }
        data.func_74783_a("id", nbtIds);
        data.func_74768_a("usedChunks", usedChunks + 1);
        CompactMachines3.logger.debug("ChunkLoading: Runtime: Forcing chunk for machine: {}", (Object)id);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)chunkTicket, (ChunkPos)new ChunkPos(roomPos));
    }

    private static ImmutableSetMultimap<ChunkPos, ForgeChunkManager.Ticket> getPersistentChunksForMachineWorld() {
        return ForgeChunkManager.getPersistentChunksFor((World)DimensionTools.getServerMachineWorld());
    }

    private static Set<ForgeChunkManager.Ticket> getModTicketsForMachineWorld() {
        HashSet<ForgeChunkManager.Ticket> tickets = new HashSet<ForgeChunkManager.Ticket>();
        HashSet<ForgeChunkManager.Ticket> seen = new HashSet<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : ChunkLoadingMachines.getPersistentChunksForMachineWorld().values()) {
            if (!seen.add(ticket) || !"compactmachines3".equals(ticket.getModId())) continue;
            tickets.add(ticket);
        }
        return tickets;
    }

    private static boolean isInvalid(ForgeChunkManager.Ticket ticket) {
        if (!"compactmachines3".equals(ticket.getModId())) {
            return true;
        }
        NBTTagCompound data = ticket.getModData();
        return !data.func_74764_b("coords") && !data.func_74764_b("id");
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (ConfigurationHandler.Settings.forceLoadChunks) {
            CompactMachines3.logger.info("Chunkloading is in always mode. Loading all previously loaded chunks.");
            for (ForgeChunkManager.Ticket ticket : tickets) {
                NBTTagCompound data = ticket.getModData();
                if (ChunkLoadingMachines.isInvalid(ticket)) continue;
                int[] nbtIds = data.func_74764_b("id") ? data.func_74759_k("id") : data.func_74759_k("coords");
                boolean foundMatch = false;
                for (int nbtId : nbtIds) {
                    if (nbtId == -1) continue;
                    CompactMachines3.logger.debug("ChunkLoading, Tickets Loaded: Forcing chunk for machine: {}", (Object)nbtId);
                    BlockPos roomPos = WorldSavedDataMachines.getInstance().getMachineRoomPosition(nbtId);
                    if (roomPos == null) continue;
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(roomPos));
                    foundMatch = true;
                }
                if (foundMatch) continue;
                CompactMachines3.logger.debug("ChunkLoading, Tickets Loaded: Ticket {} has no ids stored. Releasing it.", (Object)ticket);
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        } else {
            CompactMachines3.logger.info("Chunkloading is in smart mode. Releasing previously requested tickets...");
            for (ForgeChunkManager.Ticket ticket : tickets) {
                if (!"compactmachines3".equals(ticket.getModId())) continue;
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }
}

